/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.SpecialColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public interface IFancyFontRenderer {
    public int getXSize();

    public Font getFont();

    default public int titleTextColor() {
        return SpecialColors.TEXT_TITLE.argb();
    }

    default public int headingTextColor() {
        return SpecialColors.TEXT_HEADING.argb();
    }

    default public int subheadingTextColor() {
        return SpecialColors.TEXT_SUBHEADING.argb();
    }

    default public int screenTextColor() {
        return SpecialColors.TEXT_SCREEN.argb();
    }

    default public int activeButtonTextColor() {
        return SpecialColors.TEXT_ACTIVE_BUTTON.argb();
    }

    default public int inactiveButtonTextColor() {
        return SpecialColors.TEXT_INACTIVE_BUTTON.argb();
    }

    default public int drawString(GuiGraphics guiGraphics, Component component, int x, int y, int color) {
        return guiGraphics.m_280614_(this.getFont(), component, x, y, color, false);
    }

    default public int getStringWidth(Component component) {
        return this.getFont().m_92852_((FormattedText)component);
    }

    default public void drawCenteredText(GuiGraphics guiGraphics, Component component, float x, float y, int color) {
        this.drawCenteredText(guiGraphics, component, x, 0.0f, y, color);
    }

    default public void drawCenteredText(GuiGraphics guiGraphics, Component component, float xStart, float areaWidth, float y, int color) {
        int textWidth = this.getStringWidth(component);
        float centerX = xStart + areaWidth / 2.0f - (float)textWidth / 2.0f;
        this.drawTextExact(guiGraphics, component, centerX, y, color);
    }

    default public void drawTitleText(GuiGraphics guiGraphics, Component text, float y) {
        this.drawCenteredTextScaledBound(guiGraphics, text, this.getXSize() - 8, y, this.titleTextColor());
    }

    default public void drawScaledCenteredTextScaledBound(GuiGraphics guiGraphics, Component text, float left, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawScaledCenteredText(guiGraphics, text, left, y, color, scale);
    }

    default public void drawScaledCenteredText(GuiGraphics guiGraphics, Component text, float left, float y, int color, float scale) {
        int textWidth = this.getStringWidth(text);
        float centerX = left - (float)textWidth / 2.0f * scale;
        this.drawTextWithScale(guiGraphics, text, centerX, y, color, scale);
    }

    default public void drawCenteredTextScaledBound(GuiGraphics guiGraphics, Component text, float maxLength, float y, int color) {
        this.drawCenteredTextScaledBound(guiGraphics, text, maxLength, 0.0f, y, color);
    }

    default public void drawCenteredTextScaledBound(GuiGraphics guiGraphics, Component text, float maxLength, float x, float y, int color) {
        float scale = Math.min(1.0f, maxLength / (float)this.getStringWidth(text));
        this.drawScaledCenteredText(guiGraphics, text, x + (float)this.getXSize() / 2.0f, y, color, scale);
    }

    default public void drawTextExact(GuiGraphics guiGraphics, Component text, float x, float y, int color) {
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x, y, 0.0f);
        this.drawString(guiGraphics, text, 0, 0, color);
        pose.m_85849_();
    }

    default public float getNeededScale(Component text, float maxLength) {
        int length = this.getStringWidth(text);
        return (float)length <= maxLength ? 1.0f : maxLength / (float)length;
    }

    default public void drawTextScaledBound(GuiGraphics guiGraphics, String text, float x, float y, int color, float maxLength) {
        this.drawTextScaledBound(guiGraphics, (Component)TextComponentUtil.getString(text), x, y, color, maxLength);
    }

    default public void drawTextScaledBound(GuiGraphics guiGraphics, Component component, float x, float y, int color, float maxLength) {
        int length = this.getStringWidth(component);
        if ((float)length <= maxLength) {
            this.drawTextExact(guiGraphics, component, x, y, color);
        } else {
            this.drawTextWithScale(guiGraphics, component, x, y, color, maxLength / (float)length);
        }
    }

    default public void drawScaledTextScaledBound(GuiGraphics guiGraphics, Component text, float x, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawTextWithScale(guiGraphics, text, x, y, color, scale);
    }

    default public void drawTextWithScale(GuiGraphics guiGraphics, Component text, float x, float y, int color, float scale) {
        this.prepTextScale(guiGraphics, g -> this.drawString((GuiGraphics)g, text, 0, 0, color), x, y, scale);
    }

    default public void prepTextScale(GuiGraphics guiGraphics, Consumer<GuiGraphics> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x, y + yAdd, 0.0f);
        pose.m_85841_(scale, scale, scale);
        runnable.accept(guiGraphics);
        pose.m_85849_();
    }

    default public int drawWrappedTextWithScale(GuiGraphics guiGraphics, Component text, float x, float y, int color, float maxLength, float scale) {
        return new WrappedTextRenderer(this, text).renderWithScale(guiGraphics, x, y, color, maxLength, scale);
    }

    default public void drawWrappedCenteredText(GuiGraphics guiGraphics, Component text, float x, float y, int color, float maxLength) {
        new WrappedTextRenderer(this, text).renderCentered(guiGraphics, x, y, color, maxLength);
    }

    public static class WrappedTextRenderer {
        private final List<LineData> linesToDraw = new ArrayList<LineData>();
        private final IFancyFontRenderer font;
        private final String text;
        @Nullable
        private Font lastFont;
        private float lastMaxLength = -1.0f;
        private float lineLength = 0.0f;

        public WrappedTextRenderer(IFancyFontRenderer font, Component text) {
            this(font, text.getString());
        }

        public WrappedTextRenderer(IFancyFontRenderer font, String text) {
            this.font = font;
            this.text = text;
        }

        public void renderCentered(GuiGraphics guiGraphics, float x, float y, int color, float maxLength) {
            this.calculateLines(maxLength);
            float startY = y;
            for (LineData line : this.linesToDraw) {
                this.font.drawTextExact(guiGraphics, line.component(), x - line.length() / 2.0f, startY, color);
                startY += 9.0f;
            }
        }

        public int renderWithScale(GuiGraphics guiGraphics, float x, float y, int color, float maxLength, float scale) {
            this.calculateLines(maxLength / scale);
            this.font.prepTextScale(guiGraphics, g -> {
                int startY = 0;
                for (LineData line : this.linesToDraw) {
                    this.font.drawString((GuiGraphics)g, line.component(), 0, startY, color);
                    startY += 9;
                }
            }, x, y, scale);
            return this.linesToDraw.size();
        }

        void calculateLines(float maxLength) {
            Font font = this.font.getFont();
            if (font != null && (this.lastFont != font || this.lastMaxLength != maxLength)) {
                this.lastFont = font;
                this.lastMaxLength = maxLength;
                this.linesToDraw.clear();
                StringBuilder lineBuilder = new StringBuilder();
                StringBuilder wordBuilder = new StringBuilder();
                int spaceLength = this.lastFont.m_92895_(" ");
                int wordLength = 0;
                for (char c : this.text.toCharArray()) {
                    if (c == ' ') {
                        lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                        wordBuilder = new StringBuilder();
                        wordLength = 0;
                        continue;
                    }
                    wordBuilder.append(c);
                    wordLength += this.lastFont.m_92895_(Character.toString(c));
                }
                if (!wordBuilder.isEmpty()) {
                    lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                }
                if (!lineBuilder.isEmpty()) {
                    this.linesToDraw.add(new LineData((Component)TextComponentUtil.getString(lineBuilder.toString()), this.lineLength));
                }
            }
        }

        StringBuilder addWord(StringBuilder lineBuilder, StringBuilder wordBuilder, float maxLength, int spaceLength, int wordLength) {
            float spacingLength;
            float f = spacingLength = lineBuilder.isEmpty() ? 0.0f : (float)spaceLength;
            if (this.lineLength + spacingLength + (float)wordLength > maxLength) {
                this.linesToDraw.add(new LineData((Component)TextComponentUtil.getString(lineBuilder.toString()), this.lineLength));
                lineBuilder = new StringBuilder(wordBuilder);
                this.lineLength = wordLength;
            } else {
                if (spacingLength > 0.0f) {
                    lineBuilder.append(" ");
                }
                lineBuilder.append((CharSequence)wordBuilder);
                this.lineLength += spacingLength + (float)wordLength;
            }
            return lineBuilder;
        }

        public static int calculateHeightRequired(Font font, Component text, int width, float maxLength) {
            return WrappedTextRenderer.calculateHeightRequired(font, text.getString(), width, maxLength);
        }

        public static int calculateHeightRequired(final Font font, String text, final int width, float maxLength) {
            WrappedTextRenderer wrappedTextRenderer = new WrappedTextRenderer(new IFancyFontRenderer(){

                @Override
                public int getXSize() {
                    return width;
                }

                @Override
                public Font getFont() {
                    return font;
                }
            }, text);
            wrappedTextRenderer.calculateLines(maxLength);
            return 9 * wrappedTextRenderer.linesToDraw.size();
        }

        private record LineData(Component component, float length) {
        }
    }
}

