/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.CommandEvents;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageStartPos
implements Message<MessageStartPos> {
    private UUID player;
    private BlockPos startPos;
    private UUID worker;

    public MessageStartPos() {
    }

    public MessageStartPos(UUID player, BlockPos startPos, UUID worker) {
        this.player = player;
        this.startPos = startPos;
        this.worker = worker;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        List workers = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(AbstractWorkerEntity.class, context.getSender().m_20191_().m_82400_(64.0));
        for (AbstractWorkerEntity worker : workers) {
            if (!Objects.equals(worker.m_20148_(), this.worker)) continue;
            CommandEvents.setStartPosWorker(this.player, worker, this.startPos);
        }
    }

    @Override
    public MessageStartPos fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.startPos = buf.m_130135_();
        this.worker = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130064_(this.startPos);
        buf.m_130077_(this.worker);
    }
}

