/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.CommandEvents;
import com.talhanation.workers.entities.MerchantEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMerchantTradeButton
implements Message<MessageMerchantTradeButton> {
    private UUID uuid;
    private UUID merchant;
    private int trade;

    public MessageMerchantTradeButton() {
        this.uuid = new UUID(0L, 0L);
    }

    public MessageMerchantTradeButton(UUID merchant, UUID player, int trade) {
        this.trade = trade;
        this.uuid = player;
        this.merchant = merchant;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        if (!context.getSender().m_20148_().equals(this.uuid)) {
            return;
        }
        List list = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(MerchantEntity.class, context.getSender().m_20191_().m_82400_(100.0));
        for (MerchantEntity recruits : list) {
            if (!recruits.m_20148_().equals(this.merchant)) continue;
            CommandEvents.handleMerchantTrade((Player)context.getSender(), recruits, this.trade);
        }
    }

    @Override
    public MessageMerchantTradeButton fromBytes(FriendlyByteBuf buf) {
        this.trade = buf.readInt();
        this.uuid = buf.m_130259_();
        this.merchant = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.trade);
        buf.m_130077_(this.uuid);
        buf.m_130077_(this.merchant);
    }
}

