/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.network.MessageToClientUpdateMerchantScreen;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageMerchantResetCurrentTradeCounts
implements Message<MessageMerchantResetCurrentTradeCounts> {
    private UUID worker;
    private int index;

    public MessageMerchantResetCurrentTradeCounts() {
    }

    public MessageMerchantResetCurrentTradeCounts(UUID worker, int index) {
        this.worker = worker;
        this.index = index;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        player.m_20193_().m_6443_(MerchantEntity.class, player.m_20191_().m_82400_(16.0), v -> v.m_20148_().equals(this.worker)).stream().filter(LivingEntity::m_6084_).findAny().ifPresent(merchant -> this.resetCurrent(player, (MerchantEntity)merchant));
    }

    private void resetCurrent(ServerPlayer player, MerchantEntity merchant) {
        merchant.setCurrentTrades(this.index, 0);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateMerchantScreen(merchant.WAYPOINTS, merchant.WAYPOINT_ITEMS, merchant.getCurrentTrades(), merchant.getTradeLimits(), merchant.getTraveling(), merchant.getReturning()));
    }

    @Override
    public MessageMerchantResetCurrentTradeCounts fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        this.index = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
        buf.writeInt(this.index);
    }
}

