/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.inventory;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.init.ModMenuTypes;
import de.maxhenkel.workers.corelib.inventory.ContainerBase;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MerchantTradeContainer
extends ContainerBase {
    private final Container workerInventory;
    private final MerchantEntity merchant;

    public MerchantTradeContainer(int id, MerchantEntity merchant, Inventory playerInventory) {
        super((MenuType)ModMenuTypes.MERCHANT_TRADE_CONTAINER_TYPE.get(), id, (Container)playerInventory, (Container)merchant.getInventory());
        this.merchant = merchant;
        this.workerInventory = merchant.getTradeInventory();
        this.addWorkerTradeSlots();
        this.addWorkerPriceSlots();
        this.addPlayerInventorySlots();
    }

    @Override
    public int getInvOffset() {
        return 56;
    }

    public void addWorkerPriceSlots() {
        for (int k = 0; k < MerchantEntity.PRICE_SLOT.length; ++k) {
            this.m_38897_(new Slot(this.workerInventory, MerchantEntity.PRICE_SLOT[k], 26, 16 + k * 18){

                public boolean m_5857_(ItemStack itemStack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return false;
                }
            });
        }
    }

    public void addWorkerTradeSlots() {
        for (int k = 0; k < MerchantEntity.TRADE_SLOT.length; ++k) {
            this.m_38897_(new Slot(this.workerInventory, MerchantEntity.TRADE_SLOT[k], 80, 16 + k * 18){

                public boolean m_5857_(ItemStack itemStack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return false;
                }
            });
        }
    }

    public AbstractWorkerEntity getWorker() {
        return this.merchant;
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        if (this.workerInventory.m_6542_(playerIn) && this.merchant.m_6084_() && this.merchant.m_20270_((Entity)playerIn) < 8.0f) {
            this.merchant.isTrading = true;
            return true;
        }
        return false;
    }

    @Override
    public void m_6877_(Player playerIn) {
        this.merchant.isTrading = false;
        super.m_6877_(playerIn);
    }
}

