/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.init;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.init.ModBlocks;
import java.util.Collection;
import java.util.Set;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPois {
    private static final Logger logger = LogManager.getLogger((String)"workers");
    public static final DeferredRegister<PoiType> POIS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"workers");
    public static final RegistryObject<PoiType> POI_MINER = ModPois.makePoi("miner", ModBlocks.MINER_BLOCK);
    public static final RegistryObject<PoiType> POI_LUMBERJACK = ModPois.makePoi("lumberjack", ModBlocks.LUMBERJACK_BLOCK);
    public static final RegistryObject<PoiType> POI_FARMER = ModPois.makePoi("farmer", ModBlocks.FARMER_BLOCK);
    public static final RegistryObject<PoiType> POI_MERCHANT = ModPois.makePoi("merchant", ModBlocks.MERCHANT_BLOCK);
    public static final RegistryObject<PoiType> POI_SHEPHERD = ModPois.makePoi("shepherd", ModBlocks.SHEPHERD_BLOCK);
    public static final RegistryObject<PoiType> POI_FISHER = ModPois.makePoi("fisherman", ModBlocks.FISHER_BLOCK);
    public static final RegistryObject<PoiType> POI_CATTLE_FARMER = ModPois.makePoi("cattle_farmer", ModBlocks.CATTLE_FARMER_BLOCK);
    public static final RegistryObject<PoiType> POI_CHICKEN_FARMER = ModPois.makePoi("chicken_farmer", ModBlocks.CHICKEN_FARMER_BLOCK);
    public static final RegistryObject<PoiType> POI_SWINEHERD = ModPois.makePoi("swineherd", ModBlocks.SWINEHERD_BLOCK);

    private static RegistryObject<PoiType> makePoi(String name, RegistryObject<Block> block) {
        logger.info("Registering POI for " + block.getKey().toString());
        return POIS.register(name, () -> {
            ImmutableSet blockStates = ImmutableSet.copyOf((Collection)((Block)block.get()).m_49965_().m_61056_());
            return new PoiType((Set)blockStates, 1, 1);
        });
    }
}

