/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.CattleFarmerEntity;
import com.talhanation.workers.entities.ChickenFarmerEntity;
import com.talhanation.workers.entities.FarmerEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.entities.ShepherdEntity;
import com.talhanation.workers.entities.SwineherdEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class DepositItemsInChestGoal
extends Goal {
    private final AbstractWorkerEntity worker;
    public BlockPos chestPos;
    public Container container;
    public boolean messageCantFindChest;
    public boolean messageNoFood;
    public boolean messageChestFull;
    public int timer = 0;
    public boolean setTimer = false;
    public boolean noSpaceInvMessage;
    public boolean noToolMessage;
    public boolean messageNoChest;
    public boolean canResetPaymentTimer = false;

    public DepositItemsInChestGoal(AbstractWorkerEntity worker) {
        this.worker = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.worker.getStatus() == AbstractWorkerEntity.Status.DEPOSIT;
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.worker.getStatus() != AbstractWorkerEntity.Status.FOLLOW;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.messageNoFood = true;
        this.noSpaceInvMessage = true;
        this.noToolMessage = true;
        this.messageChestFull = true;
        this.messageNoChest = true;
        this.chestPos = this.worker.getChestPos();
        if (this.chestPos != null) {
            this.container = this.getContainer(this.chestPos);
            if (this.container == null) {
                if (this.messageCantFindChest && this.worker.m_269323_() != null) {
                    this.worker.tellPlayer(this.worker.m_269323_(), (Component)Translatable.TEXT_CANT_FIND_CHEST);
                    this.messageCantFindChest = false;
                }
                this.worker.clearChestPos();
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.container != null) {
            this.container.m_6596_();
            this.interactChest(this.container, false);
        }
        if (this.worker.paymentTimer == 0 && this.canResetPaymentTimer) {
            this.canResetPaymentTimer = false;
            this.worker.resetPaymentTimer();
        }
        this.timer = 0;
        this.setTimer = false;
        this.worker.resetFarmedItems();
        if (this.worker.getStatus() != AbstractWorkerEntity.Status.FOLLOW) {
            this.worker.setStatus(AbstractWorkerEntity.Status.IDLE);
        }
    }

    public void m_8037_() {
        this.chestPos = this.worker.getChestPos();
        if (this.chestPos != null) {
            this.worker.m_21573_().m_26519_((double)this.chestPos.m_123341_(), (double)this.chestPos.m_123342_(), (double)this.chestPos.m_123343_(), 1.1);
            if (this.chestPos.m_123314_((Vec3i)this.worker.m_20097_(), 2.5)) {
                this.worker.m_21573_().m_26573_();
                this.worker.m_21563_().m_24950_((double)this.chestPos.m_123341_(), (double)(this.chestPos.m_123342_() + 1), (double)this.chestPos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
                if (this.container != null) {
                    if (!this.setTimer) {
                        AbstractWorkerEntity abstractWorkerEntity;
                        this.interactChest(this.container, true);
                        if (this.worker.paymentTimer == 0) {
                            this.worker.checkPayment(this.container);
                            this.canResetPaymentTimer = true;
                        }
                        this.depositItems(this.container);
                        if (!this.canAddItemsInInventory() && this.worker.m_269323_() != null && this.noSpaceInvMessage) {
                            this.worker.tellPlayer(this.worker.m_269323_(), Translatable.TEXT_NO_SPACE_INV);
                            this.noSpaceInvMessage = false;
                        }
                        this.reequipMainTool();
                        this.reequipSecondTool();
                        if (this.worker instanceof MinerEntity && !this.hasEnoughOfItem(Items.f_42000_, 16)) {
                            this.getItemFromChest(Items.f_42000_);
                        }
                        if (this.worker instanceof FarmerEntity && !this.hasEnoughOfItem(Items.f_42499_, 32)) {
                            this.getItemFromChest(Items.f_42499_);
                        }
                        if ((abstractWorkerEntity = this.worker) instanceof ChickenFarmerEntity) {
                            ChickenFarmerEntity chickenFarmer = (ChickenFarmerEntity)abstractWorkerEntity;
                            if (chickenFarmer.getUseEggs()) {
                                this.getItemFromChest(Items.f_42521_);
                            }
                            if (!this.hasEnoughOfItem(Items.f_42404_, 32)) {
                                this.getItemFromChest(Items.f_42404_);
                            }
                            if (!this.hasEnoughOfItem(Items.f_42577_, 32)) {
                                this.getItemFromChest(Items.f_42577_);
                            }
                            if (!this.hasEnoughOfItem(Items.f_42578_, 32)) {
                                this.getItemFromChest(Items.f_42578_);
                            }
                            if (!this.hasEnoughOfItem(Items.f_42733_, 32)) {
                                this.getItemFromChest(Items.f_42733_);
                            }
                        }
                        if ((this.worker instanceof ShepherdEntity || this.worker instanceof CattleFarmerEntity) && !this.hasEnoughOfItem(Items.f_42405_, 32)) {
                            this.getItemFromChest(Items.f_42405_);
                        }
                        if (this.worker instanceof SwineherdEntity && !this.hasEnoughOfItem(Items.f_42619_, 32)) {
                            this.getItemFromChest(Items.f_42619_);
                        }
                        if (this.worker instanceof CattleFarmerEntity && !this.hasEnoughOfItem(Items.f_42455_, 3)) {
                            this.getItemFromChest(Items.f_42446_);
                        }
                        if (this.worker.needsToGetFood() && !this.hasFoodInInv()) {
                            if (this.isFoodInChest(this.container)) {
                                for (int i = 0; i < 3; ++i) {
                                    ItemStack foodItem = this.getFoodFromInv(this.container);
                                    if (foodItem == null) continue;
                                    ItemStack food = foodItem.m_41777_();
                                    food.m_41764_(1);
                                    this.worker.getInventory().m_19173_(food);
                                    foodItem.m_41774_(1);
                                }
                            } else if (this.worker.m_269323_() != null && this.messageNoFood) {
                                this.worker.tellPlayer(this.worker.m_269323_(), Translatable.TEXT_NO_FOOD);
                                this.messageNoFood = false;
                            }
                        }
                        if (((!this.worker.hasMainToolInInv() || this.worker.needsMainTool) && this.worker.hasAMainTool() || (!this.worker.hasSecondToolInInv() || this.worker.needsSecondTool) && this.worker.hasASecondTool()) && this.worker.m_269323_() != null && this.noToolMessage) {
                            this.worker.tellPlayer(this.worker.m_269323_(), Translatable.TEXT_OUT_OF_TOOLS());
                            this.noToolMessage = false;
                        }
                        this.timer = 30;
                        this.setTimer = true;
                    }
                } else {
                    this.container = this.getContainer(this.chestPos);
                    if (this.container == null) {
                        if (this.messageCantFindChest && this.worker.m_269323_() != null) {
                            this.worker.tellPlayer(this.worker.m_269323_(), (Component)Translatable.TEXT_CANT_FIND_CHEST);
                            this.messageCantFindChest = false;
                        }
                        this.worker.clearChestPos();
                    }
                }
            }
        } else if (this.messageNoChest && this.worker.m_269323_() != null) {
            this.worker.tellPlayer(this.worker.m_269323_(), Translatable.NEED_CHEST);
            this.messageNoChest = false;
        }
        if (this.setTimer) {
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer == 0) {
                this.m_8041_();
            }
        }
    }

    private Container getContainer(BlockPos chestPos) {
        BlockEntity entity = this.worker.m_20193_().m_7702_(chestPos);
        BlockState blockState = this.worker.m_20193_().m_8055_(chestPos);
        Block block = blockState.m_60734_();
        if (block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            return ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)blockState, (Level)this.worker.m_20193_(), (BlockPos)chestPos, (boolean)false);
        }
        if (entity instanceof Container) {
            Container containerEntity = (Container)entity;
            return containerEntity;
        }
        this.messageCantFindChest = true;
        return null;
    }

    @Nullable
    private ItemStack getFoodFromInv(Container inv) {
        ItemStack itemStack = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack2 = inv.m_8020_(i);
            if (!itemStack2.m_41614_() || itemStack2.getFoodProperties((LivingEntity)this.worker).m_38744_() <= 3) continue;
            itemStack = inv.m_8020_(i);
            break;
        }
        return itemStack;
    }

    private boolean canAddItemsInInventory() {
        for (int i = 0; i < this.worker.getInventory().m_6643_(); ++i) {
            if (!this.worker.getInventory().m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void interactChest(Container container, boolean open) {
        if (container instanceof CompoundContainer || container instanceof ChestBlockEntity) {
            BlockState state = this.worker.m_20193_().m_8055_(this.chestPos);
            Block block = state.m_60734_();
            boolean isOpened = false;
            CompoundTag compoundTag = new CompoundTag();
            BlockEntity blockEntity = this.worker.m_20193_().m_7702_(this.chestPos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                compoundTag = chestBlockEntity.getPersistentData();
                if (compoundTag.m_128441_("isOpened")) {
                    isOpened = compoundTag.m_128471_("isOpened");
                } else {
                    compoundTag.m_128379_("isOpened", false);
                }
            }
            if (open) {
                if (!isOpened) {
                    this.worker.m_20193_().m_7696_(this.chestPos, block, 1, 1);
                    this.worker.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11749_, this.worker.m_5720_(), 0.7f, 0.8f + 0.4f * this.worker.m_217043_().m_188501_());
                    compoundTag.m_128379_("isOpened", true);
                }
            } else if (isOpened) {
                this.worker.m_20193_().m_7696_(this.chestPos, block, 1, 0);
                this.worker.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11747_, this.worker.m_5720_(), 0.7f, 0.8f + 0.4f * this.worker.m_217043_().m_188501_());
                compoundTag.m_128379_("isOpened", false);
            }
            this.worker.m_20193_().m_142346_((Entity)this.worker, open ? GameEvent.f_157796_ : GameEvent.f_157793_, this.chestPos);
        }
    }

    private void reequipMainTool() {
        boolean hasMainHand = this.worker.getInventory().m_216874_(this.worker::isRequiredMainTool);
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (hasMainHand || !this.worker.isRequiredMainTool(stack) || !this.worker.hasAMainTool()) continue;
            this.take(stack);
            this.worker.needsMainTool = false;
            this.worker.updateNeedsTool();
            break;
        }
    }

    private void reequipSecondTool() {
        boolean hasOffHand = this.worker.getInventory().m_216874_(this.worker::isRequiredSecondTool);
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (hasOffHand || !this.worker.isRequiredSecondTool(stack) || !this.worker.hasASecondTool()) continue;
            this.take(stack);
            this.worker.needsSecondTool = false;
            this.worker.updateNeedsTool();
            break;
        }
    }

    private boolean hasEnoughOfItem(Item item, int x) {
        int amount = this.getAmountOfItem(item);
        return amount >= x;
    }

    public int getAmountOfItem(Item item) {
        int amount = 0;
        for (int i = 0; i < this.worker.getInventory().m_6643_(); ++i) {
            ItemStack containerItem = this.worker.getInventory().m_8020_(i);
            if (!containerItem.m_150930_(item)) continue;
            amount += containerItem.m_41613_();
        }
        return amount;
    }

    private void getItemFromChest(Item item) {
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_150930_(item)) continue;
            this.worker.getInventory().m_19173_(stack.m_41777_());
            this.container.m_8016_(i);
            break;
        }
    }

    private void take(ItemStack stack) {
        ItemStack tool = stack.m_41777_();
        this.worker.getInventory().m_19173_(tool);
        stack.m_41774_(1);
    }

    private void depositItems(Container container) {
        SimpleContainer inventory = this.worker.getInventory();
        if (this.isContainerFull(container)) {
            if (this.worker.m_269323_() != null && this.messageChestFull) {
                this.worker.tellPlayer(this.worker.m_269323_(), (Component)Translatable.TEXT_CHEST_FULL);
                this.messageChestFull = false;
            }
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_150930_(Items.f_41852_) || stack.m_41619_() || !this.worker.m_7243_(stack) || this.worker.wantsToKeep(stack) && this.getAmountOfItem(stack.m_41720_()) <= 64) continue;
            ItemStack remainder = this.deposit(stack, container);
            inventory.m_6836_(i, remainder);
        }
    }

    private boolean isContainerFull(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private ItemStack deposit(ItemStack stack, Container container) {
        ItemStack targetStack;
        int i;
        for (i = 0; i < container.m_6643_(); ++i) {
            targetStack = container.m_8020_(i);
            if (!targetStack.m_150930_(stack.m_41720_())) continue;
            int amountToDeposit = Math.min(stack.m_41613_(), targetStack.m_41741_() - targetStack.m_41613_());
            targetStack.m_41769_(amountToDeposit);
            stack.m_41774_(amountToDeposit);
            container.m_6836_(i, targetStack);
            if (!stack.m_41619_()) continue;
            return stack;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            targetStack = container.m_8020_(i);
            if (!targetStack.m_41619_()) continue;
            container.m_6836_(i, stack);
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private boolean hasFoodInInv() {
        return this.worker.getInventory().f_19147_.stream().filter(itemStack -> !itemStack.m_150930_(Items.f_42529_)).filter(itemStack -> itemStack.m_41614_() && itemStack.getFoodProperties((LivingEntity)this.worker).m_38744_() > 4).anyMatch(ItemStack::m_41614_);
    }

    private boolean isFoodInChest(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack foodItem = container.m_8020_(i);
            if (!foodItem.m_41614_() || foodItem.getFoodProperties((LivingEntity)this.worker).m_38744_() <= 4) continue;
            return true;
        }
        return false;
    }
}

