/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.AbstractAnimalFarmerEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AnimalFarmerAI
extends Goal {
    public AbstractAnimalFarmerEntity animalFarmer;
    public State state = State.IDLE;

    public void m_8037_() {
        super.m_8037_();
        switch (this.state) {
            case IDLE: {
                if (this.animalFarmer.getStartPos() == null) break;
                this.state = State.WORKING;
                break;
            }
            case WORKING: {
                if (this.animalFarmer.getStartPos() != null && this.animalFarmer.getStatus() == AbstractWorkerEntity.Status.WORK) {
                    double distance = this.animalFarmer.getStartPos().m_123331_((Vec3i)this.animalFarmer.m_20097_());
                    if (distance >= 80.0) {
                        this.state = State.MOVING_TO_WORK;
                        break;
                    }
                    if (this.animalFarmer.f_20911_) break;
                    this.performWork();
                    break;
                }
                this.state = State.IDLE;
                break;
            }
            case MOVING_TO_WORK: {
                if (this.animalFarmer.getStartPos() == null || this.animalFarmer.getStatus() != AbstractWorkerEntity.Status.WORK) break;
                double distance = this.animalFarmer.getStartPos().m_123331_((Vec3i)this.animalFarmer.m_20097_());
                if (distance <= 15.0) {
                    this.state = State.WORKING;
                    break;
                }
                this.animalFarmer.walkTowards(this.animalFarmer.getStartPos(), 1.0);
            }
        }
    }

    public abstract void performWork();

    public boolean hasBreedItem(Item breedItem) {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(breedItem) || itemStack.m_41613_() < 2) continue;
            return true;
        }
        return false;
    }

    public void consumeBreedItem(Item breedItem) {
        SimpleContainer inventory = this.animalFarmer.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(breedItem)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    private static enum State {
        IDLE,
        WORKING,
        MOVING_TO_WORK;

    }
}

