/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers;

import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ai.horse.HorseRiddenByMerchantGoal;
import com.talhanation.workers.init.ModBlocks;
import com.talhanation.workers.init.ModEntityTypes;
import com.talhanation.workers.init.ModProfessions;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerEvents {
    @SubscribeEvent
    public void attackWorkers(EntityJoinLevelEvent event) {
        Monster monster;
        Entity entity = event.getEntity();
        if (((Boolean)WorkersModConfig.PillagerAttackWorkers.get()).booleanValue() && entity instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)entity;
            illager.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)illager, AbstractWorkerEntity.class, true));
        }
        if (((Boolean)WorkersModConfig.MonsterAttackWorkers.get()).booleanValue() && entity instanceof Monster && !(entity instanceof EnderMan) && !((monster = (Monster)entity) instanceof Creeper)) {
            monster.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)monster, AbstractWorkerEntity.class, true));
        }
    }

    @SubscribeEvent
    public void onVillagerLivingUpdate(LivingEvent.LivingTickEvent event) {
        Villager villager;
        VillagerProfession profession;
        HashMap<VillagerProfession, EntityType<? extends AbstractWorkerEntity>> entitiesByProfession = new HashMap<VillagerProfession, EntityType<? extends AbstractWorkerEntity>>(){
            {
                this.put((VillagerProfession)ModProfessions.MINER.get(), (EntityType)ModEntityTypes.MINER.get());
                this.put((VillagerProfession)ModProfessions.LUMBERJACK.get(), (EntityType)ModEntityTypes.LUMBERJACK.get());
                this.put((VillagerProfession)ModProfessions.FISHER.get(), (EntityType)ModEntityTypes.FISHERMAN.get());
                this.put((VillagerProfession)ModProfessions.SHEPHERD.get(), (EntityType)ModEntityTypes.SHEPHERD.get());
                this.put((VillagerProfession)ModProfessions.FARMER.get(), (EntityType)ModEntityTypes.FARMER.get());
                this.put((VillagerProfession)ModProfessions.MERCHANT.get(), (EntityType)ModEntityTypes.MERCHANT.get());
                this.put((VillagerProfession)ModProfessions.CHICKEN_FARMER.get(), (EntityType)ModEntityTypes.CHICKEN_FARMER.get());
                this.put((VillagerProfession)ModProfessions.CATTLE_FARMER.get(), (EntityType)ModEntityTypes.CATTLE_FARMER.get());
                this.put((VillagerProfession)ModProfessions.SWINEHERD.get(), (EntityType)ModEntityTypes.SWINEHERD.get());
            }
        };
        LivingEntity entity = event.getEntity();
        if (entity instanceof Villager && entitiesByProfession.containsKey(profession = (villager = (Villager)entity).m_7141_().m_35571_())) {
            EntityType workerType = (EntityType)entitiesByProfession.get(profession);
            this.createWorker(villager, (EntityType<? extends AbstractWorkerEntity>)workerType);
        }
    }

    private void createWorker(Villager villager, EntityType<? extends AbstractWorkerEntity> workerType) {
        AbstractWorkerEntity worker = (AbstractWorkerEntity)workerType.m_20615_(villager.m_20193_());
        if (worker != null) {
            worker.m_20359_((Entity)villager);
            worker.initSpawn();
            for (ItemStack itemStack : villager.m_35311_().f_19147_) {
                worker.getInventory().m_19173_(itemStack);
            }
            Component name = villager.m_7770_();
            if (name != null) {
                worker.m_6593_(name);
            }
            if (((Boolean)WorkersModConfig.WorkersTablesPOIReleasing.get()).booleanValue()) {
                villager.m_35428_(MemoryModuleType.f_26360_);
            }
            villager.m_35428_(MemoryModuleType.f_26359_);
            villager.m_35428_(MemoryModuleType.f_26362_);
            villager.m_146870_();
            villager.m_20193_().m_7967_((Entity)worker);
        }
    }

    @SubscribeEvent
    public void onHorseJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.f_21345_.m_25352_(0, (Goal)new HorseRiddenByMerchantGoal(horse));
        }
    }

    @SubscribeEvent
    public void WanderingVillagerTrades(VillagerTradesEvent event) {
    }

    @SubscribeEvent
    public void villagerTrades(VillagerTradesEvent event) {
        List list;
        Trade block_trade;
        if (event.getType() == VillagerProfession.f_35595_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 30, (ItemLike)ModBlocks.MINER_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35590_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 23, (ItemLike)ModBlocks.LUMBERJACK_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35591_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 32, (ItemLike)ModBlocks.FISHER_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 35, (ItemLike)ModBlocks.SHEPHERD_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35597_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 25, (ItemLike)ModBlocks.SHEPHERD_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35594_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 45, (ItemLike)ModBlocks.MERCHANT_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35590_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 28, (ItemLike)ModBlocks.FARMER_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 40, (ItemLike)ModBlocks.CATTLE_FARMER_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 32, (ItemLike)ModBlocks.CHICKEN_FARMER_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            block_trade = new Trade((ItemLike)Items.f_42616_, 38, (ItemLike)ModBlocks.SWINEHERD_BLOCK.get(), 1, 4, 20);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
    }

    @SubscribeEvent
    public void onProfessionBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_().m_7705_().contains("workers")) {
            BlockState blockState = event.getState();
            Block block = blockState.m_60734_();
            BlockPos blockPos = event.getPos();
            ServerLevel level = Objects.requireNonNull(event.getLevel().m_7654_()).m_129783_();
            if (level != null && ((Boolean)WorkersModConfig.ProfessionBlocksDrop.get()).booleanValue()) {
                ItemEntity itementity = new ItemEntity((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_(), block.m_5456_().m_7968_());
                itementity.m_20334_(level.f_46441_.m_216328_(0.0, 0.11485000171139836), level.f_46441_.m_216328_(0.2, 0.11485000171139836), level.f_46441_.m_216328_(0.0, 0.11485000171139836));
                level.m_7967_((Entity)itementity);
            }
        }
    }

    static class Trade
    implements VillagerTrades.ItemListing {
        private final Item buyingItem;
        private final Item sellingItem;
        private final int buyingAmount;
        private final int sellingAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public Trade(ItemLike buyingItem, int buyingAmount, ItemLike sellingItem, int sellingAmount, int maxUses, int givenExp) {
            this.buyingItem = buyingItem.m_5456_();
            this.buyingAmount = buyingAmount;
            this.sellingItem = sellingItem.m_5456_();
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)this.buyingItem, this.buyingAmount), new ItemStack((ItemLike)this.sellingItem, this.sellingAmount), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }
}

