/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.forge;

import javax.annotation.Nullable;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModLoadingUtilImpl {
    public static boolean isModLoaded(String modid) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modid);
        }
        return ModLoadingUtilImpl.isModPreLoaded(modid);
    }

    public static boolean isModPreLoaded(String modid) {
        return ModLoadingUtilImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }

    public static boolean isModLoadedWithVersion(String modid, String minVersion) {
        if (ModLoadingUtilImpl.isModLoaded(modid)) {
            ModList modList = ModList.get();
            ArtifactVersion version = modList != null ? ((ModContainer)modList.getModContainerById(modid).get()).getModInfo().getVersion() : ModLoadingUtilImpl.getPreLoadedModVersion(modid);
            DefaultArtifactVersion min = new DefaultArtifactVersion(minVersion);
            return version.compareTo((Object)min) >= 0;
        }
        return false;
    }

    public static ArtifactVersion getPreLoadedModVersion(String modid) {
        ModInfo info = ModLoadingUtilImpl.getPreLoadedModInfo(modid);
        if (info == null) {
            throw new RuntimeException("Couldn't find mod: " + modid);
        }
        return info.getVersion();
    }
}

