/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichUtils;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.entity.util.EntityAdapter;
import com.cerbon.bosses_of_mass_destruction.entity.util.EntityStats;
import com.cerbon.bosses_of_mass_destruction.packet.BMDPacketHandler;
import com.cerbon.bosses_of_mass_destruction.packet.custom.HealS2CPacket;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.cerbon.cerbons_api.capability.CerbonsApiCapabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class VoidBlossomBlock
extends Block {
    private static final int healAnimationDelay = 16;
    private static final int healDelay = 64;
    private final VoxelShape shape = VoidBlossomBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    public VoidBlossomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.m_186460_(pos, (Block)this, 64);
        this.healNearbyEntities(level, pos);
    }

    private void healNearbyEntities(ServerLevel level, BlockPos pos) {
        level.m_45976_(VoidBlossomEntity.class, new AABB(pos).m_82377_(40.0, 20.0, 40.0)).forEach(voidBlossom -> {
            CerbonsApiCapabilities.getLevelEventScheduler((Level)level).addEvent((IEvent)new TimedEvent(() -> LichUtils.cappedHeal(new EntityAdapter((LivingEntity)voidBlossom), new EntityStats((LivingEntity)voidBlossom), VoidBlossomEntity.hpMilestones, 10.0f, arg_0 -> ((VoidBlossomEntity)((Object)voidBlossom)).m_5634_(arg_0)), 16));
            BMDPacketHandler.sendToAllPlayersTrackingChunk(new HealS2CPacket(VecUtils.asVec3((BlockPos)pos).m_82549_(VecUtils.unit.m_82490_(0.5)), voidBlossom.m_20182_().m_82549_(VecUtils.yAxis.m_82490_(5.0))), level, voidBlossom.m_20182_());
        });
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, pos)) {
            this.m_6786_(level, pos, state);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return VoidBlossomBlock.m_49863_((LevelReader)level, (BlockPos)pos, (Direction)Direction.UP) && !level.m_46801_(pos);
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos pos1;
                    if (x == 0 && z == 0 || level.m_8055_(pos1 = pos.m_7918_(x, y, z)).m_60734_() != BMDBlocks.VINE_WALL.get()) continue;
                    level.m_186460_(pos1, (Block)BMDBlocks.VINE_WALL.get(), (2 - y) * 20 + RandomUtils.range((int)0, (int)19));
                }
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape;
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (level.f_46443_) {
            for (int i = 0; i < 12; ++i) {
                Vec3 vel = VecUtils.yAxis.m_82490_(RandomUtils.range((double)0.1, (double)0.2));
                Vec3 spawnPos = VecUtils.asVec3((BlockPos)pos).m_82549_(VecUtils.unit.m_82490_(0.5)).m_82549_(VecUtils.planeProject((Vec3)RandomUtils.randVec(), (Vec3)VecUtils.yAxis).m_82541_().m_82490_(0.5));
                Particles.spikeParticleFactory.build(spawnPos, vel);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleVoidBlossomHeal(ClientLevel level, Vec3 source, Vec3 dest) {
        VoidBlossomBlock.spawnHealParticle(dest, source, level);
        VoidBlossomBlock.spawnChargeParticle(source, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnChargeParticle(Vec3 source, ClientLevel level) {
        Vec3 particlePos = source.m_82549_(VecUtils.yAxis.m_82490_(0.25));
        CerbonsApiCapabilities.getLevelEventScheduler((Level)level).addEvent((IEvent)new TimedEvent(() -> Particles.healParticleFactory.build(particlePos.m_82549_(RandomUtils.randVec().m_82490_(0.2)), Vec3.f_82478_), 32, 32, () -> false));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnHealParticle(Vec3 dest, Vec3 source, ClientLevel level) {
        ArrayList particlePositions = new ArrayList();
        int numCirclePoints = 16;
        List circlePoints = MathUtils.circlePoints((double)0.5, (int)numCirclePoints, (Vec3)dest.m_82546_(source).m_82541_()).stream().toList();
        MathUtils.lineCallback((Vec3)source, (Vec3)dest, (int)32, (pos, i) -> particlePositions.add(pos.m_82549_((Vec3)circlePoints.get(i % numCirclePoints))));
        AtomicInteger i2 = new AtomicInteger();
        CerbonsApiCapabilities.getLevelEventScheduler((Level)level).addEvent((IEvent)new TimedEvent(() -> {
            Particles.healParticleFactory.build((Vec3)particlePositions.get(i2.get()), Vec3.f_82478_);
            Particles.healParticleFactory.build((Vec3)particlePositions.get(i2.get() + 1), Vec3.f_82478_);
            i2.addAndGet(2);
        }, 0, 16, () -> false));
    }

    public static void handleVoidBlossomPlace(Vec3 pos) {
        for (int i = 0; i <= 12; ++i) {
            Vec3 spawnPos = pos.m_82549_(VecUtils.planeProject((Vec3)RandomUtils.randVec(), (Vec3)VecUtils.yAxis).m_82541_().m_82490_(0.5));
            Vec3 vel = VecUtils.yAxis.m_82490_(RandomUtils.range((double)0.1, (double)0.3));
            int randomRot = RandomUtils.range((int)0, (int)360);
            float angularMomentum = (float)RandomUtils.randSign() * 4.0f;
            Particles.petalParticleFactory.continuousRotation(f -> Float.valueOf((float)randomRot + (float)f.getAge() * angularMomentum)).continuousVelocity(f -> vel.m_82490_(1.0 - (double)f.ageRatio)).build(spawnPos, vel);
        }
    }

    public static class Particles {
        private static final ClientParticleBuilder spikeParticleFactory = new ClientParticleBuilder((ParticleOptions)BMDParticles.LINE.get()).color(f -> MathUtils.lerpVec((float)f.floatValue(), (Vec3)Vec3Colors.VOID_PURPLE, (Vec3)Vec3Colors.ULTRA_DARK_PURPLE)).colorVariation(0.15).brightness(0xF000F0).scale(0.25f).age(10, 15);
        private static final ClientParticleBuilder healParticleFactory = new ClientParticleBuilder((ParticleOptions)BMDParticles.OBSIDILITH_BURST.get()).color(f -> MathUtils.lerpVec((float)f.floatValue(), (Vec3)Vec3Colors.PINK, (Vec3)Vec3Colors.ULTRA_DARK_PURPLE)).colorVariation(0.15).brightness(0xF000F0).scale(f -> Float.valueOf(0.4f * (1.0f - f.floatValue() * 0.75f))).age(10);
        private static final ClientParticleBuilder petalParticleFactory = new ClientParticleBuilder((ParticleOptions)BMDParticles.PETAL.get()).color(f -> MathUtils.lerpVec((float)f.floatValue(), (Vec3)Vec3Colors.PINK, (Vec3)Vec3Colors.ULTRA_DARK_PURPLE)).brightness(0xF000F0).colorVariation(0.15).scale(f -> Float.valueOf(0.15f * (1.0f - f.floatValue() * 0.25f))).age(30);
    }
}

