/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.HangingSignTileExtension;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class HangingSignRendererExtension {
    public static LayerDefinition createMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("extension_6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(4.0f, -8.0f, -2.0f, 2.0f, 6.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.m_171599_("extension_5", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(4.0f, -8.0f, -2.0f, 2.0f, 5.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.m_171599_("extension_4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(4.0f, -8.0f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.m_171599_("extension_3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(4.0f, -8.0f, -2.0f, 2.0f, 3.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public static LayerDefinition createChainMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        root.m_171599_("chainL1", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171423_((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("chainL2", CubeListBuilder.m_171558_().m_171514_(6, 7).m_171481_(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171423_((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("chainR1", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("chainR2", CubeListBuilder.m_171558_().m_171514_(6, 7).m_171481_(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static void render(SignBlockEntity tile, HangingSignTileExtension extension, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, BlockState state, HangingSignRenderer.HangingSignModel model, List<ModelPart> barModel, ModelPart chains, Material material, Material extensionMaterial, SignRenderer renderer, float colorMult, boolean translucent) {
        VertexConsumer vc2;
        ModBlockProperties.PostType left;
        ModBlockProperties.PostType right;
        block13: {
            block12: {
                poseStack.m_85836_();
                boolean wallSign = !(state.m_60734_() instanceof CeilingHangingSignBlock);
                boolean attached = !wallSign && state.m_61138_((Property)BlockStateProperties.f_61386_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61386_) != false;
                poseStack.m_85837_(0.5, 0.875, 0.5);
                Quaternionf yaw = attached ? Axis.f_252436_.m_252977_(-RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)CeilingHangingSignBlock.f_244083_)))) : Axis.f_252436_.m_252977_(HangingSignRendererExtension.getSignAngle(state, wallSign));
                poseStack.m_252781_(yaw);
                model.m_246561_(state);
                VertexConsumer vertexConsumer = material.m_119194_(bufferSource, translucent ? RenderType::m_110473_ : arg_0 -> ((HangingSignRenderer.HangingSignModel)model).m_103119_(arg_0));
                poseStack.m_85841_(1.0f, -1.0f, -1.0f);
                boolean visible = model.f_244294_.f_104207_;
                boolean visibleC = model.f_243977_.f_104207_;
                model.f_244294_.f_104207_ = false;
                if (wallSign) {
                    model.f_243977_.f_104207_ = false;
                }
                poseStack.m_85836_();
                Quaternionf pitch = new Quaternionf();
                if (extension.canSwing()) {
                    float rot = extension.getClientAnimation().getAngle(partialTicks);
                    pitch = !wallSign && attached ? Axis.f_252436_.m_252977_(rot) : Axis.f_252529_.m_252977_(rot);
                    if (!wallSign) {
                        poseStack.m_85837_(0.0, -0.125, 0.0);
                    }
                    poseStack.m_252781_(pitch);
                    if (!wallSign) {
                        poseStack.m_85837_(0.0, 0.125, 0.0);
                    }
                }
                Vector3f norm = Direction.SOUTH.m_253071_().rotate((Quaternionfc)pitch).rotate((Quaternionfc)yaw);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.25, 0.0);
                model.f_244554_.m_104301_(poseStack, vertexConsumer, light, overlay);
                if (wallSign) {
                    chains.m_104301_(poseStack, vertexConsumer, light, overlay);
                    model.f_243977_.f_104207_ = visibleC;
                }
                model.f_244294_.f_104207_ = visible;
                poseStack.m_85849_();
                poseStack.m_85841_(1.0f, -1.0f, -1.0f);
                Minecraft mc = Minecraft.m_91087_();
                Camera camera = mc.f_91063_.m_109153_();
                Font font = mc.f_91062_;
                boolean filtered = mc.m_167974_();
                LOD lod = new LOD(camera, tile.m_58899_());
                poseStack.m_85836_();
                HangingSignRendererExtension.renderFront(tile, extension, poseStack, bufferSource, light, overlay, renderer, colorMult, norm, font, filtered, lod);
                poseStack.m_85849_();
                poseStack.m_85836_();
                HangingSignRendererExtension.renderBack(tile, extension, poseStack, bufferSource, light, overlay, renderer, colorMult, norm, font, filtered, lod);
                poseStack.m_85849_();
                poseStack.m_85849_();
                poseStack.m_85837_(0.0, 0.25, 0.0);
                if (visible) {
                    model.f_244294_.m_104301_(poseStack, vertexConsumer, light, overlay);
                }
                right = extension.getRightAttachment();
                left = extension.getLeftAttachment();
                if (!ClientConfigs.SIGN_ATTACHMENT.get().booleanValue()) {
                    right = null;
                    left = null;
                }
                vc2 = null;
                if (right != null) break block12;
                if (left == null) break block13;
            }
            vc2 = extensionMaterial.m_119194_(bufferSource, arg_0 -> ((HangingSignRenderer.HangingSignModel)model).m_103119_(arg_0));
        }
        if (left != null) {
            poseStack.m_85836_();
            poseStack.m_252880_(1.0f, 0.0f, 0.0f);
            barModel.get(left.ordinal()).m_104301_(poseStack, vc2, light, overlay);
            poseStack.m_85849_();
        }
        if (right != null) {
            poseStack.m_85836_();
            poseStack.m_252781_(RotHlpr.Y180);
            poseStack.m_252880_(1.0f, 0.0f, 0.0f);
            barModel.get(right.ordinal()).m_104301_(poseStack, vc2, light, overlay);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void renderFront(SignBlockEntity tile, HangingSignTileExtension extension, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, SignRenderer renderer, float colorMult, Vector3f norm, Font font, boolean filtered, LOD lod) {
        Item item;
        ItemStack item2 = extension.getFrontItem();
        if (item2.m_41619_()) {
            renderer.m_278823_(poseStack, true, renderer.m_278725_());
            HangingSignRendererExtension.renderSignText(tile.m_277142_(), font, poseStack, buffer, light, norm, lod, filtered, tile.m_245065_(), tile.m_245123_(), colorMult);
        } else if (CompatHandler.SUPPLEMENTARIES && (item = item2.m_41720_()) instanceof BannerPatternItem) {
            BannerPatternItem banner = (BannerPatternItem)item;
            HangingSignRendererExtension.renderBannerPattern(tile.m_58904_(), tile.m_277142_(), poseStack, buffer, light, banner);
        } else {
            poseStack.m_252781_(RotHlpr.Y180);
            HangingSignRendererExtension.renderItem(item2, poseStack, buffer, light, overlay, tile.m_58904_());
        }
    }

    private static void renderBack(SignBlockEntity tile, HangingSignTileExtension extension, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, SignRenderer renderer, float colorMult, Vector3f norm, Font font, boolean filtered, LOD lod) {
        Item item;
        ItemStack item2 = extension.getBackItem();
        if (item2.m_41619_()) {
            renderer.m_278823_(poseStack, false, renderer.m_278725_());
            HangingSignRendererExtension.renderSignText(tile.m_277159_(), font, poseStack, buffer, light, norm.mul(-1.0f), lod, filtered, tile.m_245065_(), tile.m_245123_(), colorMult);
        } else if (CompatHandler.SUPPLEMENTARIES && (item = item2.m_41720_()) instanceof BannerPatternItem) {
            BannerPatternItem banner = (BannerPatternItem)item;
            poseStack.m_252781_(RotHlpr.Y180);
            HangingSignRendererExtension.renderBannerPattern(tile.m_58904_(), tile.m_277159_(), poseStack, buffer, light, banner);
        } else {
            HangingSignRendererExtension.renderItem(item2, poseStack, buffer, light, overlay, tile.m_58904_());
        }
    }

    private static float getSignAngle(BlockState state, boolean attachedToWall) {
        return attachedToWall ? -((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_() : -((float)((Integer)state.m_61143_((Property)CeilingHangingSignBlock.f_244083_) * 360) / 16.0f);
    }

    public static void renderSignText(SignText signText, Font font, PoseStack poseStack, MultiBufferSource buffer, int light, Vector3f normal, LOD lod, boolean filtered, int lineHeight, int lineWidth, float colorMult) {
        TextUtil.RenderProperties properties = TextUtil.renderProperties((DyeColor)signText.m_276773_(), (boolean)signText.m_276843_(), (float)colorMult, (int)light, (Style)Style.f_131099_, (Vector3f)normal, () -> ((LOD)lod).isVeryNear());
        FormattedCharSequence[] formattedCharSequences = signText.m_277130_(filtered, component -> {
            List list = font.m_92923_((FormattedText)component, lineWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        for (int i = 0; i < formattedCharSequences.length; ++i) {
            TextUtil.renderLine((FormattedCharSequence)formattedCharSequences[i], (Font)font, (float)(lineHeight * i), (PoseStack)poseStack, (MultiBufferSource)buffer, (TextUtil.RenderProperties)properties);
        }
    }

    private static void renderBannerPattern(Level level, SignText sign, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, BannerPatternItem banner) {
        Material renderMaterial = SuppCompat.getFlagMaterial(level, banner);
        if (renderMaterial != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.5625, 0.0635);
            float scale = ClientConfigs.getItemPixelScale() / 14.0f;
            poseStack.m_85841_(scale, -scale, -1.0f);
            VertexConsumer consumer = renderMaterial.m_119194_(bufferSource, RenderType::m_110482_);
            float[] color = sign.m_276773_().m_41068_();
            int b = (int)(color[2] * 255.0f);
            int g = (int)(color[1] * 255.0f);
            int r = (int)(color[0] * 255.0f);
            int light = packedLight;
            if (sign.m_276843_()) {
                light = 0xF000F0;
            }
            int lu = light & 0xFFFF;
            int lv = light >> 16 & 0xFFFF;
            VertexUtil.addQuad((VertexConsumer)consumer, (PoseStack)poseStack, (float)-0.4375f, (float)-0.4375f, (float)0.4375f, (float)0.4375f, (float)0.59375f, (float)0.9375f, (float)0.15625f, (float)0.0625f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
            poseStack.m_85849_();
        }
    }

    public static void renderItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, Level level) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, level, null, 0);
        poseStack.m_85836_();
        float z = model.m_7539_() ? 0.109375f : 0.078125f;
        poseStack.m_252880_(0.0f, -0.5625f, -z);
        float scale = ClientConfigs.getItemPixelScale() / 16.0f;
        poseStack.m_85841_(scale, scale, scale);
        itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, light, overlay, model);
        poseStack.m_85849_();
    }
}

