/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

@Label(name="Melee Attacking", description="Changes mobs attack range to use the 1.20.2 mechanic")
@LoadFeature(module="enhancedai:mobs")
public class MeleeAttacking
extends Feature {
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    @Config
    @Label(name="Melee Attacks Attribute Based", description="If true melee monsters (zombies, etc) will attack based off the forge:entity_reach attribute instead of a fixed ~0.82 blocks. By default, mobs' forge:attack_range is set to 0.82 blocks, like vanilla 1.20.2.")
    public static Boolean meleeAttacksAttributeBased = true;
    @Config
    @Label(name="Attack Speed.Enabled", description="If true melee monsters (zombies, etc) attack rate is defined by their attack speed -40%, minimum once every 0.5 seconds with no weapon. This effectively buffs any mob that has no weapon.")
    public static Boolean meleeAttackSpeedBased = true;
    @Config(min=0.0, max=4.0)
    @Label(name="Attack Speed.Multiplier", description="Multiplies the attack speed of monsters by this value. E.g. 0.6 means that mobs attack 40% slower than the player with the same equipment")
    public static Difficulty attackSpeedMultiplier = new Difficulty(0.4, 0.5, 0.6);
    @Config(min=0.0, max=4.0)
    @Label(name="Attack Speed.Maximum", description="The maximum attack speed a mob can attack with (in attacks per second, 2 is an attack every 0.5 seconds, 1.25 is an attack every 0.8s, 1 is an attack every 1s). In vanilla mobs have 1 attack speed.")
    public static Double attackSpeedMaximum = 2.0;

    public MeleeAttacking(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attributeModificationEvent(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (!event.has(entityType, (Attribute)ForgeMod.ENTITY_REACH.get())) {
                event.add(entityType, (Attribute)ForgeMod.ENTITY_REACH.get(), DEFAULT_ATTACK_REACH);
            }
            if (event.has(entityType, Attributes.f_22283_)) continue;
            event.add(entityType, Attributes.f_22283_, 4.0);
        }
    }

    public static Boolean shouldChangeAttackRange() {
        return MeleeAttacking.isEnabled(MeleeAttacking.class) && meleeAttacksAttributeBased != false;
    }

    public static Boolean shouldUseAttackSpeedAttribute() {
        return MeleeAttacking.isEnabled(MeleeAttacking.class) && meleeAttackSpeedBased != false;
    }

    public static boolean isWithinMeleeAttackRange(LivingEntity attacker, LivingEntity attacked) {
        return MeleeAttacking.getAttackBoundingBox(attacker).m_82381_(MeleeAttacking.getHitbox(attacked));
    }

    protected static AABB getAttackBoundingBox(LivingEntity attacker) {
        AABB aabb;
        Entity entity = attacker.m_20202_();
        if (entity != null) {
            AABB veichleAABB = entity.m_20191_();
            AABB attackerAABB = attacker.m_20191_();
            aabb = new AABB(Math.min(attackerAABB.f_82288_, veichleAABB.f_82288_), attackerAABB.f_82289_, Math.min(attackerAABB.f_82290_, veichleAABB.f_82290_), Math.max(attackerAABB.f_82291_, veichleAABB.f_82291_), attackerAABB.f_82292_, Math.max(attackerAABB.f_82293_, veichleAABB.f_82293_));
        } else {
            aabb = attacker.m_20191_();
        }
        double attackReach = DEFAULT_ATTACK_REACH;
        if (MeleeAttacking.shouldChangeAttackRange().booleanValue()) {
            attackReach = attacker.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        }
        return aabb.m_82377_(attackReach, 0.0, attackReach);
    }

    protected static AABB getHitbox(LivingEntity entity) {
        AABB aabb = entity.m_20191_();
        Entity veichle = entity.m_20202_();
        if (veichle != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_(), veichle.m_6048_(), entity.m_20186_());
            return aabb.m_165887_(Math.max(vec3.f_82480_, aabb.f_82289_));
        }
        return aabb;
    }
}

