/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import java.util.EnumSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Jump", description="Makes mobs be able to jump in place when target is a few blocks above the mob.")
@LoadFeature(module="enhancedai:mobs")
public class Jump
extends Feature {
    public static final TagKey<EntityType<?>> ALLOW_JUMPING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "allow_jumping"));

    public Jump(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Mob && (mob = (Mob)entity).m_6095_().m_204039_(ALLOW_JUMPING))) {
            return;
        }
        mob.f_21345_.m_25352_(1, (Goal)new JumpGoal(mob));
    }

    public static class JumpGoal
    extends Goal {
        protected LivingEntity target;
        protected Mob goalOwner;
        protected int ticksWithoutPath;

        public JumpGoal(Mob goalOwner) {
            this.goalOwner = goalOwner;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (!this.goalOwner.m_20096_()) {
                return false;
            }
            this.target = this.goalOwner.m_5448_();
            if (this.target == null) {
                return false;
            }
            if (this.goalOwner.m_21573_().m_26571_() || this.goalOwner.m_21573_().m_26577_()) {
                ++this.ticksWithoutPath;
            } else {
                this.ticksWithoutPath = 0;
                return false;
            }
            double yDistance = this.target.m_20186_() - this.goalOwner.m_20186_();
            double distance = this.goalOwner.m_20280_((Entity)this.target);
            return distance < 36.0 && yDistance > 0.0 && yDistance <= (double)(1 + Mth.m_14167_((float)this.goalOwner.m_20206_())) && this.ticksWithoutPath > this.m_183277_(25);
        }

        public void m_8041_() {
            this.ticksWithoutPath = 0;
        }

        public void m_8056_() {
            this.goalOwner.m_21569_().m_24901_();
            this.m_8041_();
        }
    }
}

