/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper;

import insane96mcp.enhancedai.modules.creeper.CreeperSwell;
import insane96mcp.enhancedai.modules.creeper.CreeperUtils;
import insane96mcp.enhancedai.modules.mobs.avoidexplosion.AvoidExplosionGoal;
import insane96mcp.insanelib.util.MCUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.Vec3;

public class EACreeperSwellGoal
extends Goal {
    private static final UUID WALKING_FUSE_SPEED_MODIFIER_UUID = UUID.fromString("ab376fec-5a15-4d3e-8fa2-0be4b6bc1849");
    protected final Creeper swellingCreeper;
    private LivingEntity creeperAttackTarget;
    private boolean walkingFuse = false;
    private boolean ignoreWalls = false;
    private boolean breaching = false;
    private boolean isBreaching = false;
    private boolean forceExplode = false;
    private float explosionSize;
    private float explosionSizeSqr;
    private final double IGNITE_DISTANCE_MULTIPLIER_SQR = 1.8225000000000002;
    boolean beta = false;
    float angle = 0.0f;
    boolean betaStrafeLeft;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = 0;

    public EACreeperSwellGoal(Creeper creeper) {
        this.swellingCreeper = creeper;
    }

    public boolean m_8036_() {
        if (this.explosionSize == 0.0f) {
            this.explosionSize = CreeperUtils.getExplosionSize(this.swellingCreeper);
            this.explosionSizeSqr = this.explosionSize * this.explosionSize;
        }
        this.creeperAttackTarget = this.swellingCreeper.m_5448_();
        if (this.creeperAttackTarget == null) {
            return false;
        }
        this.isBreaching = this.breaching && this.canBreach(this.swellingCreeper, this.creeperAttackTarget);
        boolean ignoresWalls = this.ignoreWalls && this.swellingCreeper.m_20280_((Entity)this.creeperAttackTarget) < (double)this.explosionSizeSqr;
        return this.swellingCreeper.m_32310_() > 0 || ignoresWalls || this.isBreaching || this.swellingCreeper.m_21574_().m_148306_((Entity)this.creeperAttackTarget) && this.swellingCreeper.m_20280_((Entity)this.creeperAttackTarget) < (double)this.explosionSizeSqr * 1.8225000000000002;
    }

    public void m_8056_() {
        if (!this.walkingFuse) {
            this.swellingCreeper.m_21573_().m_26573_();
        } else {
            MCUtils.applyModifier((LivingEntity)this.swellingCreeper, (Attribute)Attributes.f_22279_, (UUID)WALKING_FUSE_SPEED_MODIFIER_UUID, (String)"Walking fuse speed modifier", (double)CreeperSwell.walkingFuseSpeedModifier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
        this.swellingCreeper.m_32283_(1);
        this.swellingCreeper.m_21391_((Entity)this.creeperAttackTarget, 30.0f, 30.0f);
        this.angle = (float)Math.toDegrees(Math.atan2(this.swellingCreeper.m_20189_() - this.creeperAttackTarget.m_20189_(), this.swellingCreeper.m_20185_() - this.creeperAttackTarget.m_20185_())) - 90.0f;
        if (this.betaStrafeLeft) {
            this.angle += 180.0f;
        }
        this.explosionSize = CreeperUtils.getExplosionSize(this.swellingCreeper);
        this.explosionSizeSqr = this.explosionSize * this.explosionSize;
        if (CreeperSwell.iguanaTweaksIntegration.booleanValue()) {
            this.swellingCreeper.getPersistentData().m_128350_("iguanatweaksreborn:explosion_ray_strength_multiplier", this.isBreaching ? 0.01f : 0.3f);
        }
    }

    public void m_8041_() {
        this.creeperAttackTarget = null;
        this.isBreaching = false;
        this.swellingCreeper.m_32283_(-1);
        AttributeInstance movementSpeed = this.swellingCreeper.m_21051_(Attributes.f_22279_);
        if (movementSpeed != null) {
            movementSpeed.m_22120_(WALKING_FUSE_SPEED_MODIFIER_UUID);
        }
        this.angle = 0.0f;
    }

    public void m_8037_() {
        if (this.creeperAttackTarget == null || !this.creeperAttackTarget.m_6084_()) {
            this.tryCancelSwell();
        } else if (this.swellingCreeper.m_20280_((Entity)this.creeperAttackTarget) > (double)this.explosionSizeSqr * 2.0 * 2.0 && !this.isBreaching) {
            this.tryCancelSwell();
        } else if (!(this.swellingCreeper.m_21574_().m_148306_((Entity)this.creeperAttackTarget) || this.ignoreWalls || this.isBreaching)) {
            this.tryCancelSwell();
        } else {
            if (this.swellingCreeper.f_19797_ % 5 == 0) {
                this.swellingCreeper.m_32283_(1);
                this.alertNearby();
            }
            this.swellingCreeper.m_21391_((Entity)this.creeperAttackTarget, 30.0f, 30.0f);
            if (this.beta && !this.walkingFuse && this.swellingCreeper.m_20096_()) {
                Vec3 mov = new Vec3(this.swellingCreeper.m_20184_().f_82479_ + Math.cos(Math.toRadians(this.angle)) * (double)(this.explosionSize * 0.075f) * this.swellingCreeper.m_21133_(Attributes.f_22279_), this.swellingCreeper.m_20184_().f_82480_, this.swellingCreeper.m_20184_().f_82481_ + Math.sin(Math.toRadians(this.angle)) * (double)(this.explosionSize * 0.075f) * this.swellingCreeper.m_21133_(Attributes.f_22279_));
                this.swellingCreeper.m_20256_(mov);
                Direction direction = Direction.m_122364_((double)(this.angle - 90.0f));
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.swellingCreeper.m_20185_() + mov.f_82479_, this.swellingCreeper.m_20186_(), this.swellingCreeper.m_20189_() + mov.f_82481_).m_122173_(direction);
                if (this.swellingCreeper.m_9236_().m_8055_((BlockPos)blockPos).m_280296_()) {
                    this.swellingCreeper.m_21569_().m_24901_();
                }
                float angleDelta = (float)((double)(1.0f / this.explosionSize * 25.0f) * this.swellingCreeper.m_21133_(Attributes.f_22279_));
                this.angle = this.betaStrafeLeft ? (this.angle += angleDelta) : (this.angle -= angleDelta);
            }
        }
    }

    private void alertNearby() {
        List creaturesNearby = this.swellingCreeper.m_9236_().m_45976_(PathfinderMob.class, this.swellingCreeper.m_20191_().m_82400_((double)(this.explosionSize * 2.0f)));
        for (PathfinderMob creatureEntity : creaturesNearby) {
            if (creatureEntity == this.swellingCreeper || creatureEntity == this.swellingCreeper.m_20202_()) continue;
            creatureEntity.f_21345_.f_25345_.forEach(prioritizedGoal -> {
                Goal patt6436$temp = prioritizedGoal.m_26015_();
                if (patt6436$temp instanceof AvoidExplosionGoal) {
                    AvoidExplosionGoal avoidExplosionGoal = (AvoidExplosionGoal)patt6436$temp;
                    avoidExplosionGoal.run((Entity)this.swellingCreeper, this.explosionSize);
                }
            });
        }
    }

    private void tryCancelSwell() {
        if (!this.forceExplode) {
            this.swellingCreeper.m_32283_(-1);
        }
    }

    public EACreeperSwellGoal setIgnoreWalls(boolean ignoreWalls) {
        this.ignoreWalls = ignoreWalls;
        return this;
    }

    public EACreeperSwellGoal setWalkingFuse(boolean walkingFuse) {
        if (walkingFuse) {
            this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        } else {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }
        this.walkingFuse = walkingFuse;
        return this;
    }

    public EACreeperSwellGoal setBreaching(boolean breaching) {
        this.breaching = breaching;
        return this;
    }

    public EACreeperSwellGoal setForceExplode(boolean forceExplode) {
        this.forceExplode = forceExplode;
        return this;
    }

    public EACreeperSwellGoal setBeta(boolean beta) {
        this.beta = beta;
        if (beta) {
            this.betaStrafeLeft = this.swellingCreeper.m_217043_().m_188499_();
        }
        return this;
    }

    public boolean canBreach(Creeper creeper, LivingEntity target) {
        if (!creeper.getPersistentData().m_128441_("enhancedai:breach")) {
            return false;
        }
        double yDistance = creeper.m_20186_() - target.m_20186_();
        double x = target.m_20185_() - creeper.m_20185_();
        double z = target.m_20189_() - creeper.m_20189_();
        double xzDistance = x * x + z * z;
        return this.isStuck() && !creeper.m_21574_().m_148306_((Entity)target) && !creeper.m_20069_() && xzDistance < (double)(CreeperSwell.breachHorizontalRange * CreeperSwell.breachHorizontalRange) && yDistance > (double)(-CreeperUtils.getExplosionSize(creeper) - 2.0f);
    }

    public static boolean canCreeperBreach(Creeper creeper, LivingEntity target) {
        Set availableGoals = creeper.f_21345_.m_148105_();
        return availableGoals.stream().filter(wrappedGoal -> wrappedGoal.m_26015_() instanceof EACreeperSwellGoal).anyMatch(eaCreeperSwellGoal -> ((EACreeperSwellGoal)eaCreeperSwellGoal.m_26015_()).canBreach(creeper, target));
    }

    public boolean isStuck() {
        if (this.swellingCreeper.m_5448_() == null) {
            return false;
        }
        if (this.lastPosition == null || this.swellingCreeper.m_20238_(this.lastPosition) > 2.25) {
            this.lastPosition = this.swellingCreeper.m_20182_();
            this.lastPositionTickstamp = this.swellingCreeper.f_19797_;
        }
        return this.swellingCreeper.m_21573_().m_26571_() || this.swellingCreeper.f_19797_ - this.lastPositionTickstamp >= 30;
    }

    public boolean m_183429_() {
        return true;
    }
}

