/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.toomanyentities.forge.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import dev.tr7zw.entityculling.EntityCullingModBase;
import io.github.discusser.toomanyentities.TooManyEntities;
import io.github.discusser.toomanyentities.config.TooManyEntitiesConfig;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class EntityCullingWorldRendererMixin {
    @Unique
    private int too_many_entities$previousRenderedEntities = 0;

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/WorldRenderer;regularEntityCount:I", ordinal=1, shift=At.Shift.AFTER)})
    private void afterEntityCountIncrement(CallbackInfo info, @Local Entity entity) {
        String key = entity.m_6095_().m_20675_();
        if (TooManyEntitiesConfig.instance.useEntityCulling.booleanValue()) {
            int current = EntityCullingModBase.instance.renderedEntities;
            int previous = this.too_many_entities$previousRenderedEntities;
            if (current - previous > 0) {
                TooManyEntities.entityCounts.put(key, TooManyEntities.entityCounts.getOrDefault(key, 0) + current - previous);
            }
            this.too_many_entities$previousRenderedEntities = current;
        } else {
            TooManyEntities.entityCounts.put(key, TooManyEntities.entityCounts.getOrDefault(key, 0) + 1);
        }
    }
}

