/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.renderers.items.LunchBoxItemRenderer;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.forge.LunchBoxItemImpl;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends SelectableContainerItem<Data>
implements ICustomItemRendererProvider,
ILeftClickReact {
    public LunchBoxItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void m_7373_(ItemStack pStack, Level level, List<Component> list, TooltipFlag pIsAdvanced) {
        Data data;
        super.m_7373_(pStack, level, list, pIsAdvanced);
        if (MiscUtils.showsHints((BlockGetter)level, pIsAdvanced)) {
            LunchBoxItem.addClientTooltip(list);
        }
        if ((data = this.getData(pStack)) != null) {
            boolean open = data.canEatFrom();
            list.add((Component)(open ? Component.m_237115_((String)"message.supplementaries.lunch_box.tooltip.open") : Component.m_237115_((String)"message.supplementaries.lunch_box.tooltip.closed")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addClientTooltip(List<Component> list) {
        list.add((Component)Component.m_237110_((String)"message.supplementaries.lunch_box.tooltip", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92096_.m_90863_()}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand hand) {
        ItemStack basket = player.m_21120_(hand);
        Data data = this.getData(basket);
        if (data.canEatFrom()) {
            ItemStack food = data.getSelected();
            if (food.m_41619_()) {
                return InteractionResultHolder.m_19100_((Object)basket);
            }
            player.m_21008_(hand, food);
            InteractionResultHolder result = food.m_41682_(pLevel, player, hand);
            ItemStack resItem = (ItemStack)result.m_19095_();
            LunchBoxItem.swapWithSelected((LivingEntity)player, resItem, data, food);
            ((LivingEntityAccessor)player).setUseItem(basket);
            player.m_21008_(hand, basket);
            return new InteractionResultHolder(result.m_19089_(), (Object)basket);
        }
        return super.m_7203_(pLevel, player, hand);
    }

    public boolean onLeftClick(ItemStack stack, Player player, InteractionHand hand) {
        Data data = this.getData(stack);
        boolean open = data.canEatFrom();
        if (open) {
            player.m_5496_(ModSounds.LUNCH_BASKET_CLOSE.get(), 0.3f, 1.0f + player.m_9236_().m_213780_().m_188501_() * 0.3f);
        } else {
            player.m_5496_(ModSounds.LUNCH_BASKET_OPEN.get(), 0.3f, 1.6f + player.m_9236_().m_213780_().m_188501_() * 0.3f);
        }
        data.switchMode();
        return true;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return SuppPlatformStuff.getFoodProperties(data.getSelected(), entity);
        }
        return super.m_41473_();
    }

    @Override
    public int m_8105_(ItemStack stack) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return data.getSelected().m_41779_();
        }
        return super.m_8105_(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return data.getSelected().m_41780_();
        }
        return super.m_6164_(stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            ItemStack selected = data.getSelected();
            ItemStack copy = selected.m_255036_(1);
            ItemStack result = copy.m_41671_(level, livingEntity);
            LunchBoxItem.swapWithSelected(livingEntity, result, data, copy);
            return stack;
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    private static void swapWithSelected(LivingEntity livingEntity, ItemStack result, Data data, ItemStack copy) {
        if (result.m_41619_()) {
            data.consumeSelected();
        } else if (result != copy) {
            Player p;
            data.consumeSelected();
            ItemStack remaining = data.tryAdding(result);
            if (!remaining.m_41619_() && livingEntity instanceof Player && !(p = (Player)livingEntity).m_150109_().m_36054_(remaining)) {
                p.m_36176_(remaining, false);
            }
        }
    }

    @Override
    protected void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(ModSounds.LUNCH_BASKET_INSERT.get(), 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return LunchBoxItemRenderer::new;
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.LUNCH_BOX_SLOTS.get();
    }

    @Override
    public Data getData(ItemStack stack) {
        return LunchBoxItem.getLunchBoxData(stack);
    }

    @NotNull
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getLunchBoxData(ItemStack stack) {
        return LunchBoxItemImpl.getLunchBoxData(stack);
    }

    @NotNull
    public static ItemStack findActiveLunchBox(LivingEntity entity) {
        return LunchBoxItem.findActiveLunchBoxSlot(entity).get(entity);
    }

    @NotNull
    public static SlotReference findActiveLunchBoxSlot(LivingEntity entity) {
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.m_41720_() instanceof LunchBoxItem);
    }

    public static boolean canAcceptItem(ItemStack toInsert) {
        if (!toInsert.m_41720_().m_142095_()) {
            return false;
        }
        if (toInsert.m_204117_(ModTags.LUNCH_BASKET_BLACKLIST)) {
            return false;
        }
        UseAnim animation = toInsert.m_41720_().m_6164_(toInsert);
        return animation == UseAnim.DRINK || animation == UseAnim.EAT;
    }

    public static interface Data
    extends SelectableContainerItem.AbstractData {
        @Override
        default public boolean canAcceptItem(ItemStack toInsert) {
            return LunchBoxItem.canAcceptItem(toInsert);
        }

        public boolean canEatFrom();

        public void switchMode();
    }
}

