/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.repack.bml.client.rows.columns;

import com.black_dog20.tabstats.repack.bml.client.rows.RowDrawingContext;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.Column;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ITextComponentColumn
extends Column {
    private final Component component;

    protected ITextComponentColumn(String id, Component component, Column.Alignment alignment) {
        super(id, alignment);
        this.component = component;
    }

    public static ITextComponentColumn of(String id, Component component) {
        return new ITextComponentColumn(id, component, Column.Alignment.LEFT);
    }

    public static ITextComponentColumn of(String id, Component component, Column.Alignment alignment) {
        return new ITextComponentColumn(id, component, alignment);
    }

    @Override
    public int getWidth() {
        if (this.hasValue()) {
            return Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.component);
        }
        return 0;
    }

    @Override
    public void render(RowDrawingContext context) {
        if (this.hasValue()) {
            float x = context.x;
            int valueWidth = context.fontRenderer.m_92852_((FormattedText)this.component);
            switch (this.alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    x += (float)(context.columnMaxWidth - valueWidth);
                    break;
                }
                case CENTER: {
                    x += (float)context.columnMaxWidth / 2.0f - (float)valueWidth / 2.0f;
                }
            }
            context.guiGraphics.m_280614_(context.fontRenderer, this.component, (int)x, (int)context.y, -1, true);
        }
    }

    @Override
    public int getHeight() {
        if (this.hasValue()) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9;
        }
        return 0;
    }

    private boolean hasValue() {
        return this.component != null && !this.component.getString().isEmpty();
    }
}

