/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.repack.bml.client.rows;

import com.black_dog20.tabstats.repack.bml.client.DrawingContext;
import com.black_dog20.tabstats.repack.bml.client.rows.Row;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.Column;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RowHelper {
    public static int drawRows(DrawingContext context, List<Row> rows) {
        Map<String, Integer> columnMap = RowHelper.getColumnMaxWidthMap(rows);
        int currentY = (int)context.y;
        for (Row row : rows) {
            currentY += row.render(context.of(context.x, currentY), columnMap);
        }
        return currentY;
    }

    public static int drawRowsWithBackground(DrawingContext context, List<Row> rows) {
        Map<String, Integer> columnMap = RowHelper.getColumnMaxWidthMap(rows);
        int maxWidth = RowHelper.getMaxWidth(rows);
        int maxHeight = RowHelper.getMaxHeight(rows);
        context.guiGraphics.m_280509_((int)context.x - 1, (int)context.y - 1, context.width / 2 + maxWidth / 2 + 1, (int)context.y + rows.size() * maxHeight, Integer.MIN_VALUE);
        int currentY = (int)context.y;
        for (Row row : rows) {
            context.guiGraphics.m_280509_(context.width / 2 - maxWidth / 2, currentY, context.width / 2 + maxWidth / 2, currentY + RowHelper.getHeight(row) - 1, 0x20FFFFFF);
            currentY += row.render(context.of(context.x, currentY), columnMap);
        }
        return currentY;
    }

    public static int getMaxWidth(List<Row> rows) {
        return RowHelper.getColumnMaxWidthMap(rows).values().stream().reduce(0, Integer::sum);
    }

    public static int getMaxHeight(List<Row> rows) {
        return RowHelper.getColumnMaxHeightMap(rows).values().stream().max(Comparator.naturalOrder()).orElse(0);
    }

    private static Map<String, Integer> getColumnMaxWidthMap(List<Row> rows) {
        return rows.stream().map(Row::getColumns).flatMap(Collection::stream).collect(Collectors.toMap(Column::getId, Column::getWidth, Math::max));
    }

    private static Map<String, Integer> getColumnMaxHeightMap(List<Row> rows) {
        return rows.stream().map(Row::getColumns).flatMap(Collection::stream).collect(Collectors.toMap(Column::getId, Column::getHeight, Math::max));
    }

    public static int getHeight(Row row) {
        return row.getColumns().stream().map(Column::getHeight).max(Comparator.naturalOrder()).orElse(0);
    }
}

