/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.capability;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BossCapability
implements ICapabilitySerializable<Tag> {
    public static final Capability<BossCapability> BOSS_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<BossCapability>(){});
    private BossType bossEntry = null;
    private Entity entity = null;
    private ResourceLocation lootTable = null;
    private BlockPos spawnPos = BlockPos.f_121853_;
    private LazyOptional<BossCapability> optional = LazyOptional.of(() -> this);
    private static final String KEY = "bbosspath";
    private static final String NAMESPACE = "bbossnamesp";
    private static final String LTKEY = "bbossltk";
    private static final String LTNAMESPACE = "bbossltn";
    private static final String XSPAWN = "spX";
    private static final String YSPAWN = "spY";
    private static final String ZSPAWN = "spZ";
    private static final String SHOWBOSSBAR = "shb";
    public static ResourceLocation ID = new ResourceLocation("brutalbosses", "bosscap");

    public BossCapability(Entity entity) {
        this.entity = entity;
    }

    public BossCapability() {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap != BOSS_CAP) {
            return LazyOptional.empty();
        }
        return this.optional.cast();
    }

    public CompoundTag serializeNBT() {
        if (this.bossEntry == null) {
            return new CompoundTag();
        }
        CompoundTag compoundNbt = new CompoundTag();
        compoundNbt.m_128359_(NAMESPACE, this.bossEntry.getID().m_135827_());
        compoundNbt.m_128359_(KEY, this.bossEntry.getID().m_135815_());
        if (this.lootTable != null) {
            compoundNbt.m_128359_(LTKEY, this.lootTable.m_135827_());
            compoundNbt.m_128359_(LTNAMESPACE, this.lootTable.m_135815_());
        }
        if (this.spawnPos != BlockPos.f_121853_) {
            compoundNbt.m_128405_(XSPAWN, this.spawnPos.m_123341_());
            compoundNbt.m_128405_(YSPAWN, this.spawnPos.m_123342_());
            compoundNbt.m_128405_(ZSPAWN, this.spawnPos.m_123343_());
        }
        compoundNbt.m_128379_(SHOWBOSSBAR, this.bossEntry.showBossBar());
        return compoundNbt;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt == null) {
            return;
        }
        CompoundTag compoundNbt = (CompoundTag)nbt;
        if (!compoundNbt.m_128441_(NAMESPACE) || !compoundNbt.m_128441_(KEY)) {
            return;
        }
        String nameSpace = compoundNbt.m_128461_(NAMESPACE);
        String path = compoundNbt.m_128461_(KEY);
        ResourceLocation id = new ResourceLocation(nameSpace, path);
        if (compoundNbt.m_128441_(LTKEY) && compoundNbt.m_128441_(LTNAMESPACE)) {
            this.lootTable = new ResourceLocation(compoundNbt.m_128423_(LTKEY).m_7916_(), compoundNbt.m_128423_(LTNAMESPACE).m_7916_());
        }
        if (compoundNbt.m_128441_(XSPAWN)) {
            this.spawnPos = new BlockPos(compoundNbt.m_128451_(XSPAWN), compoundNbt.m_128451_(YSPAWN), compoundNbt.m_128451_(ZSPAWN));
        }
        this.bossEntry = BossTypeManager.instance.bosses.get(id);
        if (this.bossEntry == null) {
            BrutalBosses.LOGGER.warn("Could not find boss for id:" + id);
        } else {
            if (!this.entity.m_9236_().m_5776_()) {
                this.bossEntry.initForEntity((LivingEntity)this.entity);
            } else {
                this.bossEntry.initForClientEntity((LivingEntity)this.entity);
            }
            this.bossEntry.setBossBar(compoundNbt.m_128471_(SHOWBOSSBAR));
        }
    }

    public void setBossType(BossType bossEntry) {
        this.bossEntry = bossEntry;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos pos) {
        this.spawnPos = pos;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public boolean isBoss() {
        return this.bossEntry != null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public BossType getBossType() {
        return this.bossEntry;
    }
}

