/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class ChasingGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:chasetarget");
    private final Mob mob;
    private float chaseDist;
    private LivingEntity target = null;
    private final ChaseParams params;
    private int ticksToNextUpdate = 0;

    public ChasingGoal(Mob mob, IAIParams params) {
        this.params = (ChaseParams)params;
        this.chaseDist = this.params.chasedistance * this.params.chasedistance;
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr <= (double)this.chaseDist && this.mob.m_21574_().m_148306_((Entity)this.target)) {
            this.mob.m_21573_().m_26573_();
        } else {
            Path path = this.mob.m_21573_().m_26570_();
            if (path != null) {
                BlockPos endPos;
                double endPosDist;
                Node endNode = path.m_77395_();
                if (endNode != null && ((endPosDist = this.target.m_20275_((double)(endPos = new BlockPos(endNode.f_77271_, endNode.f_77272_, endNode.f_77273_)).m_123341_(), (double)endPos.m_123342_(), (double)endPos.m_123343_())) > (double)this.chaseDist || !this.mob.m_21574_().m_148306_((Entity)this.target))) {
                    this.mob.m_21573_().m_5624_((Entity)this.target, 1.0);
                }
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, 1.0);
            }
        }
    }

    public static class ChaseParams
    extends IAIParams.DefaultParams {
        private float chasedistance = 2.0f;
        private static final String CHASE_DIST = "chasedistance";

        public ChaseParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHASE_DIST)) {
                this.chasedistance = jsonElement.get(CHASE_DIST).getAsFloat();
            }
            return this;
        }
    }
}

