/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.CustomEntityRenderData;
import com.brutalbosses.entity.IEntityCapReader;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.EventHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BossType {
    private final EntityType entityToUse;
    private CompoundTag creationData = null;
    private final ResourceLocation id;
    private ImmutableMap<MobEffect, Integer> potionMobEffects = ImmutableMap.of();
    private ImmutableMap<EquipmentSlot, ItemStack> gearMap = ImmutableMap.of();
    private ImmutableMap<ResourceLocation, IAIParams> aiData = ImmutableMap.of();
    private ImmutableMap<Attribute, Float> attributes = ImmutableMap.of();
    private ImmutableMap<ResourceLocation, Integer> spawnTables = ImmutableMap.of();
    private ImmutableMap<String, Float> customAttributes = ImmutableMap.of();
    private String desc;
    private float scale = 1.0f;
    private int experienceDropped = 1;
    private int itemLootCount = 3;
    private boolean showBossBar = true;
    private boolean nameVisible = true;
    private boolean protectsTreasure = true;
    private int randomSpawnChance = 0;

    public BossType(EntityType entityToUse, ResourceLocation id) {
        this.entityToUse = entityToUse;
        this.id = id;
    }

    public Mob createBossEntity(Level world) {
        Entity entity = this.entityToUse.m_20615_(world);
        if (entity instanceof AbstractVillager) {
            ((AbstractVillager)entity).f_35261_ = new MerchantOffers();
        }
        if (this.creationData != null) {
            if (this.creationData.m_128441_("Pos")) {
                entity.m_20258_(this.creationData);
            } else {
                if (this.creationData.m_128425_("ForgeCaps", 10) && entity instanceof IEntityCapReader) {
                    ((IEntityCapReader)entity).readCapsFrom(this.creationData.m_128469_("ForgeCaps"));
                }
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_7378_(this.creationData);
                }
            }
        }
        if (!(entity instanceof Mob)) {
            BrutalBosses.LOGGER.warn("Not supported boss entity:" + ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityToUse));
            return null;
        }
        ((BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)).setBossType(this);
        this.initForEntity((LivingEntity)((Mob)entity));
        return (Mob)entity;
    }

    public void initForClientEntity(LivingEntity entity) {
        if (entity instanceof CustomEntityRenderData) {
            ((CustomEntityRenderData)entity).setVisualScale(this.scale);
            ((CustomEntityRenderData)entity).setDimension(this.entityToUse.m_20680_().m_20388_(this.scale));
        }
    }

    public void initForEntity(LivingEntity boss) {
        this.initGear(boss);
        this.initStats(boss);
        this.initAI(boss);
        if (boss instanceof Mob) {
            ((Mob)boss).m_21530_();
            if (boss.m_21204_().m_22171_(Attributes.f_22277_)) {
                // empty if block
            }
        }
        boss.m_6593_((Component)Component.m_237113_((String)this.desc));
        boss.m_20340_(this.nameVisible);
        if (this.protectsTreasure) {
            EventHandler.protectedBlocks.put(((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).getSpawnPos(), boss.m_20148_());
        }
    }

    private void initStats(LivingEntity boss) {
        float healthPct = boss.m_21223_() / boss.m_21233_();
        for (Map.Entry attributeEntry : this.attributes.entrySet()) {
            if (boss.m_21204_().m_22171_((Attribute)attributeEntry.getKey())) {
                if (attributeEntry.getKey() == Attributes.f_22276_ || attributeEntry.getKey() == Attributes.f_22281_) {
                    boss.m_21051_((Attribute)attributeEntry.getKey()).m_22100_((double)((Float)attributeEntry.getValue()).floatValue() * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalDifficultyMultiplier);
                    continue;
                }
                boss.m_21051_((Attribute)attributeEntry.getKey()).m_22100_((double)((Float)attributeEntry.getValue()).floatValue());
                continue;
            }
            BrutalBosses.LOGGER.debug("Boss:" + this.id.toString() + " Attribute: " + ((Attribute)attributeEntry.getKey()).m_22087_() + " is not applicable to: " + ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityToUse));
        }
        boss.m_21153_(boss.m_21233_() * healthPct);
        for (Map.Entry MobEffectEntry : this.potionMobEffects.entrySet()) {
            boss.m_21221_().put((MobEffect)MobEffectEntry.getKey(), new MobEffectInstance((MobEffect)MobEffectEntry.getKey(), 10000000, ((Integer)MobEffectEntry.getValue()).intValue()));
        }
    }

    public void initGear(LivingEntity boss) {
        if (boss instanceof Mob) {
            for (Map.Entry gearEntry : this.gearMap.entrySet()) {
                boss.m_8061_((EquipmentSlot)gearEntry.getKey(), (ItemStack)gearEntry.getValue());
            }
        }
    }

    private void initAI(LivingEntity boss) {
        if (this.customAttributes.containsKey((Object)"removespellcastinggoals") && boss instanceof Mob) {
            Iterator iterator = ((Mob)boss).f_21345_.f_25345_.iterator();
            while (iterator.hasNext()) {
                WrappedGoal goal = (WrappedGoal)iterator.next();
                if (!(goal.m_26015_() instanceof SpellcasterIllager.SpellcasterUseSpellGoal)) continue;
                goal.m_8041_();
                iterator.remove();
            }
        }
        for (Map.Entry data : this.aiData.entrySet()) {
            if (!BossTypeManager.instance.aiCreatorRegistry.containsKey(data.getKey())) continue;
            BossTypeManager.instance.aiCreatorRegistry.get(data.getKey()).accept((Entity)boss, (IAIParams)data.getValue());
        }
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public void setMobEffects(ImmutableMap<MobEffect, Integer> potionMobEffects) {
        this.potionMobEffects = potionMobEffects;
    }

    public void setGear(ImmutableMap<EquipmentSlot, ItemStack> gearMap) {
        this.gearMap = gearMap;
    }

    public void setAttributes(ImmutableMap<Attribute, Float> attributes) {
        this.attributes = attributes;
    }

    public void setAIData(ImmutableMap<ResourceLocation, IAIParams> aiData) {
        this.aiData = aiData;
    }

    public EntityType getEntityType() {
        return this.entityToUse;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSpawnTable(ImmutableMap<ResourceLocation, Integer> spawnData) {
        this.spawnTables = spawnData;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof BossType) {
            return this.id.equals((Object)((BossType)other).id);
        }
        return false;
    }

    public ImmutableMap<ResourceLocation, Integer> getSpawnTables() {
        return this.spawnTables;
    }

    public void setVisualScale(float scale) {
        this.scale = scale;
    }

    public float getVisualScale() {
        return this.scale;
    }

    public float getCustomAttributeValueOrDefault(String attributeID, float defaultValue) {
        return ((Float)this.customAttributes.getOrDefault((Object)attributeID, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    public void setCustomAttributes(ImmutableMap<String, Float> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setRandomSpawnChance(int randomSpawnChance) {
        this.randomSpawnChance = randomSpawnChance;
    }

    public int getExperienceDrop() {
        return this.experienceDropped;
    }

    public void setExperienceDrop(int exp) {
        this.experienceDropped = exp;
    }

    public IAIParams getAIParams(ResourceLocation id) {
        return (IAIParams)this.aiData.get((Object)id);
    }

    public int getItemLootCount() {
        return this.itemLootCount;
    }

    public void setItemLootCount(int itemLootCount) {
        this.itemLootCount = itemLootCount;
    }

    public CompoundTag serializeToClient() {
        CompoundTag CompoundTag2 = new CompoundTag();
        CompoundTag2.m_128359_("id", this.id.toString());
        CompoundTag2.m_128359_("etype", ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityToUse).toString());
        CompoundTag2.m_128350_("scale", this.scale);
        return CompoundTag2;
    }

    public static BossType deserializeAtClient(CompoundTag CompoundTag2) {
        ResourceLocation id = ResourceLocation.m_135820_((String)CompoundTag2.m_128461_("id"));
        ResourceLocation entity = ResourceLocation.m_135820_((String)CompoundTag2.m_128461_("etype"));
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entity);
        if (type == null) {
            return null;
        }
        BossType bossType = new BossType(type, id);
        bossType.setVisualScale(CompoundTag2.m_128457_("scale"));
        return bossType;
    }

    public void setBossBar(boolean show) {
        this.showBossBar = show;
    }

    public boolean showBossBar() {
        return this.showBossBar;
    }

    public void setEntityNBT(CompoundTag entityNBT) {
        this.creationData = entityNBT;
    }

    public void setNameVisible(boolean visible) {
        this.nameVisible = visible;
    }

    public void setProtectsTreasure(boolean protectsTreasure) {
        this.protectsTreasure = protectsTreasure;
    }

    public boolean rollRandomSpawn() {
        return BrutalBosses.rand.nextInt(100) < this.randomSpawnChance;
    }
}

