/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.event.EventHandler;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BossJsonListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String ID = "id";
    public static final String ENTITY = "entity";
    public static final String ENTITY_NBT = "entitynbt";
    public static final String MobEffectS = "effects";
    public static final String STATS = "attributes";
    public static final String CUSTOMSTATS = "customattributes";
    public static final String GEAR = "gear";
    public static final String MAINHAND = "mainhand";
    public static final String OFFHAND = "offhand";
    public static final String HELMET = "helmet";
    public static final String CHESTPLATE = "chestplate";
    public static final String LEGGINGS = "leggings";
    public static final String FEET = "feet";
    public static final String AI = "ai-goals";
    public static final String SPAWNCHESTTABLES = "spawnatchest";
    public static final String Name = "name";
    public static final String NAME_VISIBLE = "namevisible";
    public static final String SCALE = "visualscale";
    public static final String EXP = "experience";
    public static final String ITEM_LOOT_COUNT = "droppeditemamount";
    public static final String SHOW_BAR = "showbossbar";
    private static final String PROTECT_TREASURE = "protect_treasure";
    private static final String RANDOM_SPAWN = "random_spawn";
    private static final Random rand = new Random();
    public static final BossJsonListener instance = new BossJsonListener();

    private BossJsonListener() {
        super(GSON, "bosses");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder bossTypes = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            BossType bossType;
            if (!entry.getKey().m_135827_().equals("brutalbosses") || (bossType = this.tryParse(entry)) == null) continue;
            bossTypes.put((Object)bossType.getID(), (Object)bossType);
        }
        BossTypeManager.instance.setBossTypes((ImmutableMap<ResourceLocation, BossType>)bossTypes.build());
        BossTypeManager.instance.afterLoad();
    }

    private BossType tryParse(Map.Entry<ResourceLocation, JsonElement> entry) {
        try {
            JsonElement MobEffectData;
            JsonObject data = (JsonObject)entry.getValue();
            ResourceLocation bossID = entry.getKey();
            EntityType entityTypeEntry = null;
            if (data.has(ENTITY)) {
                ResourceLocation entityType = ResourceLocation.m_135820_((String)data.get(ENTITY).getAsString());
                if (entityType == null) {
                    BrutalBosses.LOGGER.error("Missing or malformed field  entity in bossfile:" + entry.getKey());
                    return null;
                }
                entityTypeEntry = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityType);
                if (entityTypeEntry == EntityType.f_20510_) {
                    BrutalBosses.LOGGER.error("Cannot find entity type for:" + entityType + " id in bossfile:" + entry.getKey());
                    return null;
                }
            } else {
                BrutalBosses.LOGGER.error("Missing or malformed field  entity in bossfile:" + entry.getKey());
                return null;
            }
            BossType bossType = BossTypeManager.instance.bosses.getOrDefault(bossID, new BossType(entityTypeEntry, bossID));
            if (data.has(ENTITY_NBT)) {
                try {
                    bossType.setEntityNBT(TagParser.m_129359_((String)data.get(ENTITY_NBT).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (data.has(Name)) {
                bossType.setDesc(data.get(Name).getAsString());
            }
            if (data.has(NAME_VISIBLE)) {
                bossType.setNameVisible(data.get(Name).getAsBoolean());
            }
            if (data.has(PROTECT_TREASURE)) {
                bossType.setProtectsTreasure(data.get(PROTECT_TREASURE).getAsBoolean());
            }
            if (data.has(SCALE)) {
                bossType.setVisualScale(data.get(SCALE).getAsFloat());
            }
            if (data.has(EXP)) {
                bossType.setExperienceDrop(data.get(EXP).getAsInt());
            }
            if (data.has(ITEM_LOOT_COUNT)) {
                bossType.setItemLootCount(data.get(ITEM_LOOT_COUNT).getAsInt());
            }
            if (data.has(MobEffectS)) {
                ImmutableMap.Builder MobEffects = ImmutableMap.builder();
                MobEffectData = data.get(MobEffectS);
                for (Map.Entry MobEffectEntry : MobEffectData.getAsJsonObject().entrySet()) {
                    ResourceLocation MobEffectID = new ResourceLocation((String)MobEffectEntry.getKey());
                    MobEffect MobEffect2 = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(MobEffectID);
                    if (MobEffect2 == null) {
                        BrutalBosses.LOGGER.error("Bad MobEffect id:" + MobEffectID + " in:" + entry.getKey());
                        return null;
                    }
                    MobEffects.put((Object)MobEffect2, (Object)((JsonElement)MobEffectEntry.getValue()).getAsInt());
                }
                bossType.setMobEffects((ImmutableMap<MobEffect, Integer>)MobEffects.build());
            }
            if (data.has(STATS)) {
                ImmutableMap.Builder attributeModifiers = ImmutableMap.builder();
                MobEffectData = data.get(STATS);
                for (Map.Entry statsEntry : MobEffectData.getAsJsonObject().entrySet()) {
                    Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation((String)statsEntry.getKey()));
                    if (attribute == null) {
                        BrutalBosses.LOGGER.error("Bad attribute id:" + new ResourceLocation((String)statsEntry.getKey()) + " in:" + entry.getKey());
                        continue;
                    }
                    float modifier = ((JsonElement)statsEntry.getValue()).getAsFloat();
                    attributeModifiers.put((Object)attribute, (Object)Float.valueOf(modifier));
                }
                bossType.setAttributes((ImmutableMap<Attribute, Float>)attributeModifiers.build());
            }
            if (data.has(CUSTOMSTATS)) {
                ImmutableMap.Builder customAttributeBuilder = ImmutableMap.builder();
                MobEffectData = data.get(CUSTOMSTATS);
                for (Map.Entry statsEntry : MobEffectData.getAsJsonObject().entrySet()) {
                    float modifier = ((JsonElement)statsEntry.getValue()).getAsFloat();
                    customAttributeBuilder.put((Object)((String)statsEntry.getKey()), (Object)Float.valueOf(modifier));
                }
                bossType.setCustomAttributes((ImmutableMap<String, Float>)customAttributeBuilder.build());
            }
            if (data.has(GEAR)) {
                ImmutableMap.Builder gearList = ImmutableMap.builder();
                JsonElement jsonEntry = data.get(GEAR);
                if (jsonEntry.isJsonObject()) {
                    JsonObject gearData = jsonEntry.getAsJsonObject();
                    if (gearData.has(MAINHAND)) {
                        gearList.put((Object)EquipmentSlot.MAINHAND, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(MAINHAND).getAsString())));
                    }
                    if (gearData.has(OFFHAND)) {
                        gearList.put((Object)EquipmentSlot.OFFHAND, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(OFFHAND).getAsString())));
                    }
                    if (gearData.has(HELMET)) {
                        gearList.put((Object)EquipmentSlot.HEAD, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(HELMET).getAsString())));
                    }
                    if (gearData.has(CHESTPLATE)) {
                        gearList.put((Object)EquipmentSlot.CHEST, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(CHESTPLATE).getAsString())));
                    }
                    if (gearData.has(LEGGINGS)) {
                        gearList.put((Object)EquipmentSlot.LEGS, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(LEGGINGS).getAsString())));
                    }
                    if (gearData.has(FEET)) {
                        gearList.put((Object)EquipmentSlot.FEET, (Object)ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)gearData.get(FEET).getAsString())));
                    }
                }
                bossType.setGear((ImmutableMap<EquipmentSlot, ItemStack>)gearList.build());
            }
            if (data.has(AI)) {
                ImmutableMap.Builder aiParamMap = ImmutableMap.builder();
                JsonElement aiData = data.get(AI);
                for (Map.Entry aiEntry : aiData.getAsJsonObject().entrySet()) {
                    ResourceLocation aiID = new ResourceLocation((String)aiEntry.getKey());
                    if (!BossTypeManager.instance.aiCreatorRegistry.containsKey(aiID)) {
                        BrutalBosses.LOGGER.error("Unkown AI id:" + aiID + " in:" + entry.getKey());
                        continue;
                    }
                    Function<JsonObject, IAIParams> paramReader = BossTypeManager.instance.aiParamParsers.get(aiID);
                    IAIParams params = IAIParams.EMPTY;
                    if (paramReader != null && ((JsonElement)aiEntry.getValue()).isJsonObject()) {
                        params = paramReader.apply(((JsonElement)aiEntry.getValue()).getAsJsonObject());
                    }
                    aiParamMap.put((Object)aiID, (Object)params);
                }
                bossType.setAIData((ImmutableMap<ResourceLocation, IAIParams>)aiParamMap.build());
            }
            if (data.has(SPAWNCHESTTABLES)) {
                ImmutableMap.Builder spawnMap = ImmutableMap.builder();
                JsonElement spawnLootableData = data.get(SPAWNCHESTTABLES);
                for (Map.Entry spawnLootTableEntry : spawnLootableData.getAsJsonObject().entrySet()) {
                    ResourceLocation lootTableID = new ResourceLocation((String)spawnLootTableEntry.getKey());
                    spawnMap.put((Object)lootTableID, (Object)((JsonElement)spawnLootTableEntry.getValue()).getAsInt());
                }
                bossType.setSpawnTable((ImmutableMap<ResourceLocation, Integer>)spawnMap.build());
            }
            if (data.has(SHOW_BAR)) {
                bossType.setBossBar(data.get(SHOW_BAR).getAsBoolean());
            }
            if (data.has(RANDOM_SPAWN)) {
                int chance = data.get(RANDOM_SPAWN).getAsInt();
                if (chance < 0 || chance > 100) {
                    BrutalBosses.LOGGER.error("Bad random spawn chance in bossfile:" + entry.getKey() + " chance:" + chance + " has to be within 0-100");
                }
                chance = Math.min(100, Math.max(0, chance));
                Set<BossType> possibleBosses = EventHandler.randomSpawns.get(bossType.getEntityType());
                if (possibleBosses == null) {
                    possibleBosses = new HashSet<BossType>();
                }
                possibleBosses.add(bossType);
                EventHandler.randomSpawns.put(entityTypeEntry, possibleBosses);
                bossType.setRandomSpawnChance(chance);
            }
            return bossType;
        }
        catch (Exception e) {
            BrutalBosses.LOGGER.warn("Could not parse boss for:" + entry.getKey(), (Throwable)e);
            return null;
        }
    }
}

