/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots;

import io.github.lgatodu47.screenshot_viewer.config.ScreenshotListOrder;
import io.github.lgatodu47.screenshot_viewer.config.VisibilityState;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

final class ScreenshotList
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry,
ScreenshotImageList,
ScreenshotWidget.Context {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final int x;
    private final int y;
    private final List<ScreenshotWidget> screenshotWidgets = new ArrayList<ScreenshotWidget>();
    private final List<GuiEventListener> elements = new ArrayList<GuiEventListener>();
    private final Scrollbar scrollbar = new Scrollbar();
    private int width;
    private int height;
    private int scrollY;
    private int scrollSpeedFactor;
    private int screenshotsPerRow;
    private int spacing;
    private int childWidth;
    private int childHeight;
    private boolean invertedOrder;
    private boolean invertedScroll;
    private boolean namesHidden;
    private File screenshotsFolder;
    private boolean scrollbarClicked;

    ScreenshotList(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height) {
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.screenScrollSpeed.get();
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.initialScreenshotAmountPerRow.get();
        this.invertedOrder = ((ScreenshotListOrder)((Object)ManageScreenshotsScreen.CONFIG.defaultListOrder.get())).isInverted();
        this.screenshotsFolder = new File((String)ManageScreenshotsScreen.CONFIG.screenshotsFolder.get());
        this.invertedScroll = (Boolean)ManageScreenshotsScreen.CONFIG.invertZoomDirection.get();
        this.namesHidden = ManageScreenshotsScreen.CONFIG.screenshotElementTextVisibility.get() == VisibilityState.HIDDEN;
        this.updateVariables();
    }

    void updateSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    void configUpdated() {
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.screenScrollSpeed.get();
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.initialScreenshotAmountPerRow.get();
        this.invertedScroll = (Boolean)ManageScreenshotsScreen.CONFIG.invertZoomDirection.get();
        this.namesHidden = ManageScreenshotsScreen.CONFIG.screenshotElementTextVisibility.get() == VisibilityState.HIDDEN;
        File currentScreenshotFolder = new File((String)ManageScreenshotsScreen.CONFIG.screenshotsFolder.get());
        if (!Objects.equals(this.screenshotsFolder, currentScreenshotFolder)) {
            this.screenshotsFolder = currentScreenshotFolder;
            this.init();
            return;
        }
        if (this.invertedOrder != ((ScreenshotListOrder)((Object)ManageScreenshotsScreen.CONFIG.defaultListOrder.get())).isInverted()) {
            this.invertOrder();
            return;
        }
        this.updateChildren(true);
    }

    void init() {
        this.clearChildren();
        File[] files = this.screenshotsFolder.listFiles();
        if (files != null) {
            Arrays.sort(files, this.invertedOrder ? Comparator.reverseOrder() : Comparator.naturalOrder());
            this.updateVariables();
            int maxXOff = this.screenshotsPerRow - 1;
            int childX = this.x + this.spacing;
            int childY = this.y + this.spacing;
            int xOff = 0;
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".png") && !file.getName().endsWith(".jpg") && !file.getName().endsWith(".jpeg")) continue;
                ScreenshotWidget widget = new ScreenshotWidget(this.mainScreen, childX, childY, this.childWidth, this.childHeight, this, file);
                this.screenshotWidgets.add(widget);
                this.elements.add((GuiEventListener)widget);
                if (xOff == maxXOff) {
                    xOff = 0;
                    childX = this.x + this.spacing;
                    childY += this.childHeight + this.spacing;
                    continue;
                }
                ++xOff;
                childX += this.childWidth + this.spacing;
            }
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
    }

    void updateScreenshotsPerRow(double scrollAmount) {
        double d = scrollAmount = this.invertedScroll ? -scrollAmount : scrollAmount;
        if (scrollAmount > 0.0) {
            if (this.screenshotsPerRow < 8) {
                this.screenshotsPerRow = Math.min(8, this.screenshotsPerRow + 1);
            }
        } else if (scrollAmount < 0.0 && this.screenshotsPerRow > 2) {
            this.screenshotsPerRow = Math.max(2, this.screenshotsPerRow - 1);
        }
        this.updateChildren(false);
    }

    void updateChildren(boolean configUpdated) {
        this.scrollY = 0;
        this.updateVariables();
        int maxXOff = this.screenshotsPerRow - 1;
        int childX = this.x + this.spacing;
        int childY = this.y + this.spacing;
        int xOff = 0;
        for (ScreenshotWidget widget : this.screenshotWidgets) {
            widget.m_252865_(childX);
            widget.updateBaseY(childY);
            widget.m_93674_(this.childWidth);
            widget.setHeight(this.childHeight);
            if (configUpdated) {
                widget.onConfigUpdate();
            }
            if (xOff == maxXOff) {
                xOff = 0;
                childX = this.x + this.spacing;
                childY += this.childHeight + this.spacing;
                continue;
            }
            ++xOff;
            childX += this.childWidth + this.spacing;
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
    }

    List<ScreenshotWidget> deletionList() {
        return this.mainScreen.isFastDeleteToggled() ? this.screenshotWidgets.stream().filter(ScreenshotWidget::isSelectedForDeletion).toList() : List.of();
    }

    void resetDeleteSelection() {
        this.screenshotWidgets.forEach(ScreenshotWidget::deselectForDeletion);
    }

    private void updateVariables() {
        float windowAspect = (float)this.client.m_91268_().m_85443_() / (float)this.client.m_91268_().m_85444_();
        int scrollbarWidth = 6;
        int scrollbarSpacing = 2;
        this.spacing = 4;
        this.childWidth = (this.width - (this.screenshotsPerRow + 1) * this.spacing - 6 - 2) / this.screenshotsPerRow;
        this.childHeight = (int)((this.namesHidden ? 1.0 : 1.08) * (double)this.childWidth / (double)windowAspect);
    }

    private void clearChildren() {
        this.close();
        this.screenshotWidgets.clear();
        this.elements.clear();
    }

    public void close() {
        this.screenshotWidgets.forEach(ScreenshotWidget::close);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, boolean updateHoverState) {
        graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, FastColor.ARGB32.m_13660_((int)178, (int)0, (int)0, (int)0));
        if (this.screenshotWidgets.isEmpty()) {
            graphics.m_280653_(this.client.f_91062_, ScreenshotViewerTexts.NO_SCREENSHOTS, (this.x + this.width) / 2, (this.y + this.height + 8) / 2, 0xFFFFFF);
        }
        for (ScreenshotWidget screenshotWidget : this.screenshotWidgets) {
            screenshotWidget.updateY(this.scrollY);
            int viewportY = this.y + this.spacing;
            int viewportBottom = this.y + this.height - this.spacing;
            screenshotWidget.updateHoverState(mouseX, mouseY, viewportY, viewportBottom, updateHoverState);
            if (screenshotWidget.m_252907_() + screenshotWidget.m_93694_() < this.y || screenshotWidget.m_252907_() > this.y + this.height) continue;
            screenshotWidget.render(graphics, mouseX, mouseY, delta, viewportY, viewportBottom);
        }
        if (this.canScroll()) {
            this.scrollbar.render(graphics, mouseX, mouseY, this.scrollY, updateHoverState, this.scrollbarClicked);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.elements;
    }

    @Override
    public ScreenshotImageHolder getScreenshot(int index) {
        return this.screenshotWidgets.get(index);
    }

    @Override
    public Optional<ScreenshotImageHolder> findByFileName(File file) {
        return this.screenshotWidgets.stream().filter(screenshotWidget -> screenshotWidget.getScreenshotFile().equals(file)).map(ScreenshotImageHolder.class::cast).findFirst();
    }

    @Override
    public int size() {
        return this.screenshotWidgets.size();
    }

    @Override
    public int screenshotsPerRow() {
        return this.screenshotsPerRow;
    }

    @Override
    public int currentIndex(ScreenshotWidget widget) {
        return this.screenshotWidgets.indexOf(widget);
    }

    @Override
    public void removeEntry(ScreenshotWidget widget) {
        this.screenshotWidgets.remove(widget);
        this.elements.remove(widget);
        this.updateChildren(false);
    }

    void invertOrder() {
        Collections.reverse(this.screenshotWidgets);
        this.invertedOrder = !this.invertedOrder;
        int previousScrollY = this.scrollY;
        this.updateChildren(false);
        this.scrollY = previousScrollY;
    }

    boolean isInvertedOrder() {
        return this.invertedOrder;
    }

    private boolean canScroll() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        return totalHeightOfTheChildrens > (viewHeight = this.height - 2 * this.spacing);
    }

    private boolean canScrollDown() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        int leftOver = totalHeightOfTheChildrens - (viewHeight = this.height - 2 * this.spacing);
        return this.scrollY < leftOver;
    }

    private int getTotalHeightOfChildren() {
        int rows = Mth.m_14167_((float)((float)this.screenshotWidgets.size() / (float)this.screenshotsPerRow));
        return rows * this.childHeight + this.spacing * (rows - 1);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.canScroll()) {
            int scrollSpeed = Math.abs((int)((double)((float)this.scrollSpeedFactor * (6.0f / (float)this.screenshotsPerRow)) * amount));
            if (this.scrollY > 0 && amount > 0.0) {
                this.scrollY = Math.max(0, this.scrollY - scrollSpeed);
            }
            if (this.canScrollDown() && amount < 0.0) {
                int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
                int viewHeight = this.height - 2 * this.spacing;
                int leftOver = totalHeightOfTheChildrens - viewHeight;
                this.scrollY = Math.min(leftOver, this.scrollY + scrollSpeed);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrollbarClicked = false;
        if (this.canScroll() && this.scrollbar.mouseClicked(mouseX, mouseY, button, this.scrollY)) {
            this.scrollbarClicked = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollbarClicked = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollbarClicked && this.canScroll()) {
            int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
            int scrollDelta = this.scrollbar.getScrollOffsetDelta(deltaY, totalHeightOfTheChildrens);
            if (this.scrollY > 0 && scrollDelta > 0) {
                this.scrollY = Math.max(0, this.scrollY - scrollDelta);
            }
            if (this.canScrollDown() && scrollDelta < 0) {
                int viewHeight = this.height - 2 * this.spacing;
                int leftOver = totalHeightOfTheChildrens - viewHeight;
                this.scrollY = Math.min(leftOver, this.scrollY - scrollDelta);
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.screenshotWidgets.stream().anyMatch(widget -> widget.m_7933_(keyCode, scanCode, modifiers));
    }

    public void m_142291_(@NotNull NarrationElementOutput builder) {
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    private static class Scrollbar {
        private final int spacing = 2;
        private final int width = 6;
        private final int trackWidth = 2;
        private int x;
        private int height;
        private int trackX;
        private int trackY;
        private int trackHeight;
        private IntUnaryOperator scrollbarYGetter;

        private Scrollbar() {
        }

        void repositionScrollbar(int listX, int listY, int listWith, int listHeight, int listSpacing, int totalHeightOfTheChildrens) {
            this.x = listX + listWith - 2 - 6;
            this.trackX = this.x + 2;
            this.trackY = listY + listSpacing;
            this.trackHeight = listHeight - 2 * listSpacing;
            int scrollbarSpacedTrackHeight = this.trackHeight + 4;
            this.scrollbarYGetter = scrollOffset -> Mth.m_14167_((float)((float)(scrollOffset * scrollbarSpacedTrackHeight) / (float)totalHeightOfTheChildrens)) + listY + 2;
            this.height = this.trackHeight * scrollbarSpacedTrackHeight / totalHeightOfTheChildrens;
        }

        void render(GuiGraphics graphics, double mouseX, double mouseY, int scrollOffset, boolean updateHoverState, boolean clicked) {
            int y = this.scrollbarYGetter.applyAsInt(scrollOffset);
            graphics.m_280509_(this.trackX, this.trackY, this.trackX + 2, this.trackY + this.trackHeight, -1);
            graphics.m_280509_(this.x, y, this.x + 6, y + this.height, clicked ? -1 : (this.isHovered(mouseX, mouseY, y) && updateHoverState ? -9605779 : -14803426));
        }

        boolean mouseClicked(double mouseX, double mouseY, double button, int scrollOffset) {
            return button == 0.0 && this.isHovered(mouseX, mouseY, this.scrollbarYGetter.applyAsInt(scrollOffset));
        }

        int getScrollOffsetDelta(double scrollbarDelta, double totalHeightOfTheChildrens) {
            int scrollbarSpacedTrackHeight = this.trackHeight + 4;
            return Mth.m_14165_((double)(-scrollbarDelta * totalHeightOfTheChildrens / (double)scrollbarSpacedTrackHeight));
        }

        private boolean isHovered(double mouseX, double mouseY, int y) {
            return mouseX >= (double)this.x && mouseY >= (double)y && mouseX < (double)(this.x + 6) && mouseY < (double)(y + this.height);
        }
    }
}

