/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerMacOsUtils;
import io.github.lgatodu47.screenshot_viewer.screens.CopyScreenshotToast;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class ScreenshotViewerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static final Clipboard AWT_CLIPBOARD = ScreenshotViewerUtils.tryGetAWTClipboard();
    private static Method DRAW_TOOLTIP;
    private static boolean errorLogged;

    public static File getVanillaScreenshotsFolder() {
        return new File(Minecraft.m_91087_().f_91069_, "screenshots");
    }

    public static void drawTexture(GuiGraphics context, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        int x2 = x + width;
        int y2 = y + height;
        float u1 = (float)u / (float)textureWidth;
        float u2 = ((float)u + (float)regionWidth) / (float)textureWidth;
        float v1 = (float)v / (float)textureHeight;
        float v2 = ((float)v + (float)regionHeight) / (float)textureHeight;
        Matrix4f matrix4f = context.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x, (float)y2, 0.0f).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, 0.0f).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y, 0.0f).m_7421_(u2, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    @Nullable
    private static Clipboard tryGetAWTClipboard() {
        if (Minecraft.f_91002_) {
            return null;
        }
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable t) {
            LOGGER.error("Unable to retrieve Java AWT Clipboard instance!", t);
            return null;
        }
    }

    public static void copyImageToClipboard(File screenshotFile) {
        if (Minecraft.f_91002_) {
            ScreenshotViewerMacOsUtils.doCopyMacOS(screenshotFile.getAbsolutePath());
            return;
        }
        if (AWT_CLIPBOARD != null && screenshotFile.exists()) {
            CompletableFuture.runAsync(() -> {
                MutableComponent toastText;
                try {
                    BufferedImage img = ImageIO.read(screenshotFile);
                    BufferedImage rgbImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                    rgbImg.createGraphics().drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
                    ImageTransferable imageTransferable = new ImageTransferable(rgbImg);
                    AWT_CLIPBOARD.setContents(imageTransferable, null);
                    toastText = ScreenshotViewerTexts.TOAST_COPY_SUCCESS;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to copy screenshot image to clipboard!", t);
                    toastText = ScreenshotViewerTexts.translatable("toast", "copy_fail", t.getClass().getSimpleName());
                }
                Minecraft client = Minecraft.m_91087_();
                CopyScreenshotToast.show(client.m_91300_(), (Component)toastText, (Component)Component.m_237113_((String)screenshotFile.getName()), 3000L);
            }, Util.m_183991_());
        }
    }

    public static List<ClientTooltipComponent> toColoredComponents(Minecraft client, Component text) {
        return Tooltip.m_257868_((Minecraft)client, (Component)text).stream().map(ColoredTooltipComponent::new).collect(Collectors.toList());
    }

    public static void renderTooltip(GuiGraphics context, Font textRenderer, List<ClientTooltipComponent> tooltipComponents, int posX, int posY) {
        block3: {
            if (DRAW_TOOLTIP == null) {
                DRAW_TOOLTIP = ObfuscationReflectionHelper.findMethod(GuiGraphics.class, (String)"m_280497_", (Class[])new Class[]{Font.class, List.class, Integer.TYPE, Integer.TYPE, ClientTooltipPositioner.class});
                DRAW_TOOLTIP.setAccessible(true);
            }
            try {
                DRAW_TOOLTIP.invoke((Object)context, textRenderer, tooltipComponents, posX, posY, DefaultTooltipPositioner.f_262752_);
            }
            catch (Exception e) {
                if (errorLogged) break block3;
                LOGGER.error("Failed to render Screenshot Viewer tooltip", (Throwable)e);
                errorLogged = true;
            }
        }
    }

    public static void forEachDrawable(Screen screen, Consumer<Renderable> renderer) {
        ScreenshotViewerUtils.forEachOfType(screen, Renderable.class, renderer);
    }

    public static <T> void forEachOfType(Screen screen, Class<T> type, Consumer<T> action) {
        screen.m_6702_().stream().filter(type::isInstance).map(type::cast).forEachOrdered(action);
    }

    record ImageTransferable(Image image) implements Transferable
    {
        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image();
        }
    }

    static class ColoredTooltipComponent
    implements ClientTooltipComponent {
        private final FormattedCharSequence text;

        public ColoredTooltipComponent(FormattedCharSequence text) {
            this.text = text;
        }

        public int m_142069_(Font textRenderer) {
            return textRenderer.m_92724_(this.text);
        }

        public int m_142103_() {
            return 10;
        }

        public void m_142440_(@NotNull Font textRenderer, int x, int y, @NotNull Matrix4f matrix, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull MultiBufferSource.BufferSource vertexConsumers) {
            float[] colors = RenderSystem.getShaderColor();
            if (colors.length != 4) {
                colors = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            }
            int alpha = Math.max((int)(colors[3] * 255.0f), 5);
            int textColor = FastColor.ARGB32.m_13660_((int)alpha, (int)((int)(colors[0] * 255.0f)), (int)((int)(colors[1] * 255.0f)), (int)((int)(colors[2] * 255.0f)));
            textRenderer.m_272191_(this.text, (float)x, (float)y, textColor, true, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }
}

