/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.network.NetworkHandler;
import artifacts.network.ToggleArtifactPacket;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;

public class ToggleKeyHandler {
    private static final Map<WearableArtifactItem, KeyMapping> TOGGLE_KEY_MAPPINGS = new HashMap<WearableArtifactItem, KeyMapping>();

    public static void register() {
        ToggleKeyHandler.addToggleInputHandler(ModItems.NIGHT_VISION_GOGGLES.get(), ModKeyMappings.TOGGLE_NIGHT_VISION_GOGGLES);
        ToggleKeyHandler.addToggleInputHandler(ModItems.UNIVERSAL_ATTRACTOR.get(), ModKeyMappings.TOGGLE_UNIVERSAL_ATTRACTOR);
    }

    public static KeyMapping getToggleKey(WearableArtifactItem item) {
        return TOGGLE_KEY_MAPPINGS.get((Object)item);
    }

    private static void addToggleInputHandler(WearableArtifactItem item, KeyMapping toggleKey) {
        TOGGLE_KEY_MAPPINGS.put(item, toggleKey);
        ToggleInputHandler handler = new ToggleInputHandler(item);
        ClientTickEvent.CLIENT_PRE.register(instance -> handler.onClientTick());
    }

    private static class ToggleInputHandler {
        private boolean wasToggleKeyDown;
        private final WearableArtifactItem item;

        public ToggleInputHandler(WearableArtifactItem item) {
            this.item = item;
        }

        public void onClientTick() {
            boolean isToggleKeyDown = ToggleKeyHandler.getToggleKey(this.item).m_90857_();
            if (isToggleKeyDown && !this.wasToggleKeyDown) {
                NetworkHandler.CHANNEL.sendToServer((Object)new ToggleArtifactPacket(this.item));
            }
            this.wasToggleKeyDown = isToggleKeyDown;
        }
    }
}

