/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.annotation.Issue;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Issue(modId="minecraft", issueId="Ingredient Deduplication", versionRange="1.20.1", mixins={"main.IngredientMixin", "main.IngredientMixin$IngredientAccessor", "main.IngredientMixin$TagValueMixin", "main.IngredientMixin$TagValueAccessor", "main.IngredientMixin$ItemValueMixin", "main.IngredientMixin$ItemValueAccessor"}, config="ingredientDedupe", configActivated=false, description="Deduplicates VANILLA ingredients to reduce memory usage")
public class IngredientDedupe
implements PreparableReloadListener {
    private static final ObjectOpenCustomHashSet<Ingredient> INGREDIENT_CACHE;
    public static IngredientDedupe INSTANCE;

    public static IngredientDedupe getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IngredientDedupe();
        }
        return INSTANCE;
    }

    public static synchronized Ingredient intern(Ingredient ingredient) {
        return (Ingredient)INGREDIENT_CACHE.addOrGet((Object)ingredient);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> INGREDIENT_CACHE.clear(), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0));
    }

    public String m_7812_() {
        return "atl_ingredient_dedupe";
    }

    static {
        Hash.Strategy<Ingredient> BASIC_HASH_STRATEGY = new Hash.Strategy<Ingredient>(){

            public int hashCode(Ingredient o) {
                return Objects.hashCode(o);
            }

            public boolean equals(Ingredient a, Ingredient b) {
                return Objects.equals(a, b);
            }
        };
        INGREDIENT_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
    }
}

