/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.util.FormationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.phys.Vec3;

public class NPCArmy {
    private List<LivingEntity> allUnits;
    private List<LivingEntity> ranged;
    private List<LivingEntity> shieldmen;
    private List<LivingEntity> infantry;
    private List<LivingEntity> cavalry;
    private List<UUID> uuids;
    private final ServerLevel level;

    public NPCArmy(ServerLevel level, @Nullable List<LivingEntity> units, @Nullable List<UUID> uuids) {
        this.level = level;
        this.allUnits = units;
        this.uuids = uuids;
        this.initRecruits(this.uuids != null && this.allUnits == null);
    }

    public int getTotalUnits() {
        return this.allUnits.size();
    }

    public double getAverageHealth() {
        if (this.allUnits.isEmpty()) {
            return 0.0;
        }
        double totalHealth = 0.0;
        for (LivingEntity recruit : this.allUnits) {
            totalHealth += (double)recruit.m_21223_();
        }
        return totalHealth / (double)this.allUnits.size();
    }

    public double getAverageArmor() {
        if (this.allUnits.isEmpty()) {
            return 0.0;
        }
        double totalArmor = 0.0;
        for (LivingEntity recruit : this.allUnits) {
            totalArmor += (double)recruit.m_21230_();
        }
        return totalArmor / (double)this.allUnits.size();
    }

    public double getLowHealthPercentage(double threshold) {
        if (this.allUnits.isEmpty()) {
            return 0.0;
        }
        int lowHealthCount = 0;
        for (LivingEntity recruit : this.allUnits) {
            if (!((double)recruit.m_21223_() < threshold)) continue;
            ++lowHealthCount;
        }
        return (double)lowHealthCount / (double)this.allUnits.size() * 100.0;
    }

    public double getAverageMorale() {
        if (this.allUnits.isEmpty()) {
            return 0.0;
        }
        double totalMorale = 0.0;
        for (LivingEntity living : this.allUnits) {
            if (living instanceof AbstractRecruitEntity) {
                AbstractRecruitEntity recruit = (AbstractRecruitEntity)living;
                totalMorale += (double)recruit.getMorale();
                continue;
            }
            totalMorale += 40.0;
        }
        return totalMorale / (double)this.allUnits.size();
    }

    public boolean isInfantry(LivingEntity recruit) {
        if (recruit.m_20202_() instanceof AbstractHorse) {
            return false;
        }
        return !(recruit.m_21205_().m_41720_() instanceof BowItem) && !(recruit.m_21205_().m_41720_() instanceof CrossbowItem);
    }

    public boolean isShieldmen(LivingEntity recruit) {
        if (recruit.m_20202_() instanceof AbstractHorse) {
            return false;
        }
        return recruit.m_21206_().m_41720_() instanceof ShieldItem;
    }

    public static boolean isRanged(LivingEntity recruit) {
        return recruit.m_21205_().m_41720_() instanceof BowItem || recruit.m_21205_().m_41720_() instanceof CrossbowItem;
    }

    public boolean isCavalry(LivingEntity recruit) {
        if (recruit.m_21205_().m_41720_() instanceof BowItem || recruit.m_21205_().m_41720_() instanceof CrossbowItem) {
            return false;
        }
        return recruit.m_20202_() instanceof AbstractHorse;
    }

    public void updateArmy() {
        this.allUnits = this.allUnits.stream().filter(LivingEntity::m_6084_).collect(Collectors.toList());
        this.initRecruits(false);
    }

    public List<AbstractRecruitEntity> getAllRecruitUnits() {
        return this.getRecruitFromList(this.allUnits);
    }

    public List<AbstractRecruitEntity> getRecruitInfantry() {
        return this.getRecruitFromList(this.infantry);
    }

    public List<AbstractRecruitEntity> getRecruitShieldmen() {
        return this.getRecruitFromList(this.shieldmen);
    }

    public List<AbstractRecruitEntity> getRecruitRanged() {
        return this.getRecruitFromList(this.ranged);
    }

    public List<AbstractRecruitEntity> getRecruitCavalry() {
        return this.getRecruitFromList(this.cavalry);
    }

    private List<AbstractRecruitEntity> getRecruitFromList(List<LivingEntity> list) {
        ArrayList<AbstractRecruitEntity> recruits = new ArrayList<AbstractRecruitEntity>();
        for (LivingEntity living : list) {
            if (!(living instanceof AbstractRecruitEntity)) continue;
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)living;
            recruits.add(recruit);
        }
        return recruits;
    }

    public List<LivingEntity> getAllUnits() {
        return this.allUnits;
    }

    public List<LivingEntity> getInfantry() {
        return this.infantry;
    }

    public List<LivingEntity> getShieldmen() {
        return this.shieldmen;
    }

    public List<LivingEntity> getRanged() {
        return this.ranged;
    }

    public List<LivingEntity> getCavalry() {
        return this.cavalry;
    }

    public void save(CompoundTag nbt) {
        if (this.uuids != null) {
            ListTag recruitsTag = new ListTag();
            for (UUID recruitId : this.uuids) {
                CompoundTag recruitTag = new CompoundTag();
                recruitTag.m_128362_("Recruit", recruitId);
                recruitsTag.add((Object)recruitTag);
            }
            nbt.m_128365_("Recruits", (Tag)recruitsTag);
        }
    }

    public static NPCArmy load(ServerLevel serverLevel, CompoundTag nbt) {
        ListTag recruitsTag = nbt.m_128437_("Recruits", 10);
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < recruitsTag.size(); ++i) {
            CompoundTag recruitTag = recruitsTag.m_128728_(i);
            uuids.add(recruitTag.m_128342_("Recruit"));
        }
        return new NPCArmy(serverLevel, null, uuids);
    }

    public List<LivingEntity> getFromUUIDListRecruits(List<UUID> recruitUUIDs) {
        ArrayList<LivingEntity> recruits = new ArrayList<LivingEntity>();
        for (UUID uuid : recruitUUIDs) {
            Entity entity = this.level.m_8791_(uuid);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity recruit = (LivingEntity)entity;
            recruits.add(recruit);
        }
        return recruits;
    }

    public List<UUID> getUUIDListFromRecruits(List<LivingEntity> recruits) {
        return recruits.stream().map(Entity::m_20148_).collect(Collectors.toList());
    }

    public void initRecruits(boolean fromUUID) {
        if (this.uuids == null || this.uuids.isEmpty() && this.allUnits != null && !this.allUnits.isEmpty()) {
            this.uuids = this.getUUIDListFromRecruits(this.allUnits);
        }
        if (fromUUID) {
            this.allUnits = this.getFromUUIDListRecruits(this.uuids);
        }
        this.ranged = new ArrayList<LivingEntity>();
        this.shieldmen = new ArrayList<LivingEntity>();
        this.infantry = new ArrayList<LivingEntity>();
        this.cavalry = new ArrayList<LivingEntity>();
        for (LivingEntity recruit : this.allUnits) {
            if (NPCArmy.isRanged(recruit)) {
                this.ranged.add(recruit);
                continue;
            }
            if (this.isCavalry(recruit)) {
                this.cavalry.add(recruit);
                continue;
            }
            if (this.isShieldmen(recruit)) {
                this.shieldmen.add(recruit);
                continue;
            }
            if (!this.isInfantry(recruit)) continue;
            this.infantry.add(recruit);
        }
    }

    public Vec3 getPosition() {
        return FormationUtils.getCenterOfPositions(this.allUnits, this.level);
    }

    public int size() {
        return this.allUnits.size();
    }
}

