/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.common.ForgeMod;

public abstract class AttackUtil {
    public static void checkAndPerformAttack(double distanceSqrToTarget, double reach, AbstractRecruitEntity recruit, LivingEntity target) {
        if (distanceSqrToTarget <= reach) {
            AttackUtil.performAttack(recruit, target);
        }
    }

    public static void performAttack(AbstractRecruitEntity recruit, LivingEntity target) {
        if (recruit.attackCooldown == 0 && !recruit.f_20911_ && recruit.m_21563_().m_186069_()) {
            if (AttackUtil.canPerformHorseAttack(recruit, target)) {
                if (target.m_20202_() != null) {
                    recruit.m_7327_(target.m_20202_());
                }
            } else {
                recruit.m_7327_((Entity)target);
            }
            recruit.m_6674_(InteractionHand.MAIN_HAND);
            recruit.attackCooldown = AttackUtil.getAttackCooldown(recruit);
        }
    }

    public static boolean canPerformHorseAttack(AbstractRecruitEntity recruit, LivingEntity target) {
        Random random = new Random();
        if (target.m_20202_() instanceof Animal) {
            int level = recruit.getXpLevel();
            int chance = Math.min(level * 2, 100);
            return random.nextInt(0, 100) <= chance;
        }
        return false;
    }

    public static int getAttackCooldown(AbstractRecruitEntity recruit) {
        double attackSpeed = recruit.m_21133_(Attributes.f_22283_);
        int base = (int)Math.round(20.0 / attackSpeed);
        return base + 7;
    }

    public static double getAttackReachSqr(LivingEntity living) {
        double attackReach;
        float base = 5.0f;
        if (living.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()) != null && (attackReach = living.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get())) > 0.0) {
            return (double)(2.0f * base) * attackReach;
        }
        return base;
    }
}

