/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.google.common.collect.ImmutableSet;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.pathfinding.AsyncPath;
import com.talhanation.recruits.pathfinding.AsyncPathProcessor;
import com.talhanation.recruits.pathfinding.AsyncPathfinder;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncPathNavigation
extends PathNavigation {
    private static BiFunction<Integer, NodeEvaluator, PathFinder> pathfinderSupplier = (p_26453_, nodeEvaluator) -> new PathFinder(nodeEvaluator, p_26453_.intValue());
    @Nullable
    private BlockPos targetPos;
    private int reachRange;
    private final PathFinder pathFinder;
    private boolean isStuck;
    private long pathfindFailures = 0L;
    private long lastFailure = 0L;

    public AsyncPathNavigation(PathfinderMob p_26515_, Level p_26516_) {
        super((Mob)p_26515_, p_26516_);
        int i = Mth.m_14107_((double)(p_26515_.m_21133_(Attributes.f_22277_) * 16.0));
        if (((Boolean)RecruitsServerConfig.UseAsyncPathfinding.get()).booleanValue()) {
            pathfinderSupplier = (p_26453_, nodeEvaluator) -> new AsyncPathfinder((NodeEvaluator)nodeEvaluator, (int)p_26453_, this.f_26495_);
        }
        this.pathFinder = this.m_5532_(i);
    }

    @NotNull
    protected PathFinder m_5532_(int p_26531_) {
        return pathfinderSupplier.apply(p_26531_, this.f_26508_);
    }

    @Nullable
    public final Path createPathAsync(double p_26525_, double p_26526_, double p_26527_, int p_26528_) {
        return this.m_7864_(new BlockPos((int)p_26525_, (int)p_26526_, (int)p_26527_), p_26528_);
    }

    @Nullable
    public Path m_26556_(Stream<BlockPos> p_26557_, int p_26558_) {
        return this.m_26551_(p_26557_.collect(Collectors.toSet()), 8, false, p_26558_);
    }

    @Nullable
    public Path m_26548_(Set<BlockPos> p_26549_, int p_26550_) {
        return this.m_26551_(p_26549_, 8, false, p_26550_);
    }

    @Nullable
    public Path m_7864_(BlockPos p_26546_, int p_26547_) {
        return this.m_26551_((Set<BlockPos>)ImmutableSet.of((Object)p_26546_), 8, false, p_26547_);
    }

    @Nullable
    public Path m_148218_(BlockPos p_148219_, int p_148220_, int p_148221_) {
        return this.m_148222_((Set<BlockPos>)ImmutableSet.of((Object)p_148219_), 8, false, p_148220_, p_148221_);
    }

    @Nullable
    public Path m_6570_(Entity p_26534_, int p_26535_) {
        return this.m_26551_((Set<BlockPos>)ImmutableSet.of((Object)p_26534_.m_20183_()), 16, true, p_26535_);
    }

    @Nullable
    protected Path m_26551_(Set<BlockPos> p_26552_, int p_26553_, boolean p_26554_, int p_26555_) {
        return this.m_148222_(p_26552_, p_26553_, p_26554_, p_26555_, (float)this.f_26494_.m_21133_(Attributes.f_22277_));
    }

    @Nullable
    protected Path m_148222_(Set<BlockPos> p_148223_, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        AsyncPath asyncPath;
        Path path;
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return null;
        }
        if (p_148223_.isEmpty()) {
            return null;
        }
        if (this.f_26494_.m_20186_() < (double)this.f_26495_.m_141937_()) {
            return null;
        }
        if (!this.m_7632_()) {
            return null;
        }
        if (this.f_26496_ != null && (path = this.f_26496_) instanceof AsyncPath && !(asyncPath = (AsyncPath)path).isProcessed() && asyncPath.hasSameProcessingPositions(p_148223_)) {
            return this.f_26496_;
        }
        if (this.f_26496_ != null && !this.f_26496_.m_77392_() && p_148223_.contains(this.targetPos)) {
            return this.f_26496_;
        }
        BlockPos blockpos = p_148225_ ? this.f_26494_.m_20183_().m_7494_() : this.f_26494_.m_20183_();
        int i = (int)(p_148227_ + (float)p_148224_);
        PathNavigationRegion pathnavigationregion = new PathNavigationRegion(this.f_26495_, blockpos.m_7918_(-i, -i, -i), blockpos.m_7918_(i, i, i));
        float maxVisitedNodesMultiplier = 1.0f;
        Path path2 = this.pathFinder.m_77427_(pathnavigationregion, this.f_26494_, p_148223_, p_148227_, p_148226_, maxVisitedNodesMultiplier);
        if (!p_148223_.isEmpty()) {
            this.targetPos = p_148223_.iterator().next();
        }
        if (((Boolean)RecruitsServerConfig.UseAsyncPathfinding.get()).booleanValue()) {
            AsyncPathProcessor.awaitProcessing(path2, this.f_26495_.m_7654_(), processedPath -> {
                if (processedPath != this.f_26496_) {
                    return;
                }
                if (processedPath != null) {
                    this.targetPos = processedPath.m_77406_();
                    this.reachRange = p_148226_;
                    this.m_26565_();
                }
            });
        }
        return path2;
    }

    public boolean m_26519_(double p_26520_, double p_26521_, double p_26522_, double p_26523_) {
        Path path = this.m_7864_(new BlockPos((int)p_26520_, (int)p_26521_, (int)p_26522_), 1);
        return this.m_26536_(path, p_26523_);
    }

    public boolean m_5624_(@NotNull Entity p_26532_, double p_26533_) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return false;
        }
        long currentTick = this.f_26495_.m_46467_();
        if (this.pathfindFailures > 10L && this.f_26496_ == null && currentTick < this.lastFailure + 40L) {
            return false;
        }
        Path path = this.m_6570_(p_26532_, 1);
        if (path != null && this.m_26536_(path, p_26533_)) {
            this.lastFailure = 0L;
            this.pathfindFailures = 0L;
            return true;
        }
        ++this.pathfindFailures;
        this.lastFailure = currentTick;
        return false;
    }

    public boolean m_26536_(@Nullable Path p_26537_, double p_26538_) {
        boolean isProcessed;
        AsyncPath asyncPath;
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return false;
        }
        if (p_26537_ == null) {
            this.f_26496_ = null;
            return false;
        }
        if (!p_26537_.m_77385_(this.f_26496_)) {
            this.f_26496_ = p_26537_;
        }
        if (this.m_26571_()) {
            return false;
        }
        Path path = this.f_26496_;
        if (path instanceof AsyncPath && (asyncPath = (AsyncPath)path).isProcessed() || !((path = this.f_26496_) instanceof AsyncPath)) {
            v0 = true;
        } else {
            AsyncPath asyncPath2 = (AsyncPath)path;
            v0 = isProcessed = false;
        }
        if (isProcessed) {
            this.m_6804_();
            if (this.f_26496_.m_77398_() <= 0) {
                return false;
            }
        }
        this.f_26497_ = p_26538_;
        Vec3 vec3 = this.m_7475_();
        this.f_26499_ = this.f_26498_;
        this.f_26500_ = vec3;
        return true;
    }

    protected void m_6804_() {
        if (this.f_26496_ == null) {
            return;
        }
        for (int i = 0; i < this.f_26496_.m_77398_(); ++i) {
            Node node = this.f_26496_.m_77375_(i);
            Node node1 = i + 1 < this.f_26496_.m_77398_() ? this.f_26496_.m_77375_(i + 1) : null;
            BlockState blockstate = this.f_26495_.m_8055_(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_));
            if (!blockstate.m_204336_(BlockTags.f_144269_)) continue;
            this.f_26496_.m_77377_(i, node.m_77289_(node.f_77271_, node.f_77272_ + 1, node.f_77273_));
            if (node1 == null || node.f_77272_ < node1.f_77272_) continue;
            this.f_26496_.m_77377_(i + 1, node.m_77289_(node1.f_77271_, node.f_77272_ + 1, node1.f_77273_));
        }
    }

    public void m_7638_() {
        AsyncPath asyncPath;
        Path path;
        ++this.f_26498_;
        if (this.f_26506_) {
            this.m_26569_();
        }
        if ((path = this.f_26496_) instanceof AsyncPath && !(asyncPath = (AsyncPath)path).isProcessed()) {
            return;
        }
        if (!this.m_26571_()) {
            if (this.m_7632_()) {
                this.m_7636_();
            } else if (this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                Vec3 vec3 = this.m_7475_();
                Vec3 vec31 = this.f_26496_.m_77380_((Entity)this.f_26494_);
                if (vec3.f_82480_ > vec31.f_82480_ && !this.f_26494_.m_20096_() && Mth.m_14107_((double)vec3.f_82479_) == Mth.m_14107_((double)vec31.f_82479_) && Mth.m_14107_((double)vec3.f_82481_) == Mth.m_14107_((double)vec31.f_82481_)) {
                    this.f_26496_.m_77374_();
                }
            }
            DebugPackets.m_133703_((Level)this.f_26495_, (Mob)this.f_26494_, (Path)this.f_26496_, (float)this.f_26505_);
            if (!this.m_26571_()) {
                Vec3 vec32 = this.f_26496_.m_77380_((Entity)this.f_26494_);
                this.f_26494_.m_21566_().m_6849_(vec32.f_82479_, this.m_183345_(vec32), vec32.f_82481_, this.f_26497_);
            }
        }
    }

    protected void m_7636_() {
        boolean flag;
        AsyncPath asyncPath;
        Path path = this.f_26496_;
        if (path instanceof AsyncPath && !(asyncPath = (AsyncPath)path).isProcessed()) {
            return;
        }
        Vec3 vec3 = this.m_7475_();
        this.f_26505_ = this.f_26494_.m_20205_() > 0.75f ? this.f_26494_.m_20205_() / 2.0f : 0.75f - this.f_26494_.m_20205_() / 2.0f;
        BlockPos vec3i = this.f_26496_.m_77400_();
        double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vec3i.m_123341_() + (double)(this.f_26494_.m_20205_() + 1.0f) / 2.0));
        double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vec3i.m_123342_());
        double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vec3i.m_123343_() + (double)(this.f_26494_.m_20205_() + 1.0f) / 2.0));
        boolean bl = flag = d0 <= (double)this.f_26505_ && d2 <= (double)this.f_26505_ && d1 < 1.0;
        if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vec3)) {
            this.f_26496_.m_77374_();
        }
        this.m_6481_(vec3);
    }

    private boolean m_26559_(Vec3 p_26560_) {
        Vec3 vec33;
        if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
            return false;
        }
        Vec3 vec3 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
        if (!p_26560_.m_82509_((Position)vec3, 2.0)) {
            return false;
        }
        if (this.m_183431_(p_26560_, this.f_26496_.m_77380_((Entity)this.f_26494_))) {
            return true;
        }
        Vec3 vec31 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
        Vec3 vec32 = vec31.m_82546_(vec3);
        return vec32.m_82526_(vec33 = p_26560_.m_82546_(vec3)) > 0.0;
    }

    public void m_26569_() {
        if (this.f_26495_.m_46467_() - this.f_26507_ > 20L) {
            if (this.targetPos != null) {
                this.f_26496_ = null;
                this.f_26496_ = this.m_7864_(this.targetPos, this.reachRange);
                this.f_26507_ = this.f_26495_.m_46467_();
                this.f_26506_ = false;
            }
        } else {
            this.f_26506_ = true;
        }
    }

    private void m_26565_() {
        this.f_26501_ = Vec3i.f_123288_;
        this.f_26502_ = 0L;
        this.f_26504_ = 0.0;
        this.isStuck = false;
    }

    public boolean m_26577_() {
        return this.isStuck;
    }
}

