/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.talhanation.recruits.pathfinding.AsyncPathProcessor;
import com.talhanation.recruits.util.ProcessState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncPath
extends Path {
    private volatile ProcessState processState = ProcessState.WAITING;
    private final List<Runnable> postProcessing = new ArrayList<Runnable>(0);
    private final Set<BlockPos> positions;
    private final Supplier<Path> pathSupplier;
    private final List<Node> nodes;
    @Nullable
    private BlockPos target;
    private float distToTarget = 0.0f;
    private boolean canReach = true;
    private Level level;

    public AsyncPath(@NotNull List<Node> emptyNodeList, @NotNull Set<BlockPos> positions, @NotNull Level level, @NotNull Supplier<Path> pathSupplier) {
        super(emptyNodeList, null, false);
        this.nodes = emptyNodeList;
        this.positions = positions;
        this.pathSupplier = pathSupplier;
        this.level = level;
        AsyncPathProcessor.queue(this);
    }

    public boolean isProcessed() {
        return this.processState == ProcessState.COMPLETED;
    }

    public synchronized void postProcessing(@NotNull Runnable runnable) {
        if (this.isProcessed()) {
            runnable.run();
        } else {
            this.postProcessing.add(runnable);
        }
    }

    public boolean hasSameProcessingPositions(Set<BlockPos> positions) {
        if (this.positions.size() != positions.size()) {
            return false;
        }
        return this.positions.containsAll(positions);
    }

    public synchronized void process() {
        if (this.processState == ProcessState.COMPLETED || this.processState == ProcessState.PROCESSING) {
            return;
        }
        this.processState = ProcessState.PROCESSING;
        Path bestPath = this.pathSupplier.get();
        this.nodes.addAll(bestPath.f_77362_);
        this.target = bestPath.m_77406_();
        this.distToTarget = bestPath.m_77407_();
        this.canReach = bestPath.m_77403_();
        this.processState = ProcessState.COMPLETED;
        for (Runnable runnable : this.postProcessing) {
            runnable.run();
        }
    }

    private void checkProcessed() {
        if (this.processState == ProcessState.WAITING || this.processState == ProcessState.PROCESSING) {
            this.process();
        }
    }

    @NotNull
    public BlockPos m_77406_() {
        this.checkProcessed();
        return Objects.requireNonNull(this.target);
    }

    public float m_77407_() {
        this.checkProcessed();
        return this.distToTarget;
    }

    public boolean m_77403_() {
        this.checkProcessed();
        return this.canReach;
    }

    public boolean m_77392_() {
        return this.isProcessed() && super.m_77392_();
    }

    public void m_77374_() {
        this.checkProcessed();
        super.m_77374_();
    }

    public boolean m_77387_() {
        this.checkProcessed();
        return super.m_77387_();
    }

    @Nullable
    public Node m_77395_() {
        this.checkProcessed();
        return super.m_77395_();
    }

    @NotNull
    public Node m_77375_(int index) {
        this.checkProcessed();
        return super.m_77375_(index);
    }

    public void m_77388_(int length) {
        this.checkProcessed();
        super.m_77388_(length);
    }

    public void m_77377_(int index, @NotNull Node node) {
        this.checkProcessed();
        super.m_77377_(index, node);
    }

    public int m_77398_() {
        this.checkProcessed();
        return super.m_77398_();
    }

    public int m_77399_() {
        this.checkProcessed();
        return super.m_77399_();
    }

    public void m_77393_(int nodeIndex) {
        this.checkProcessed();
        super.m_77393_(nodeIndex);
    }

    @NotNull
    public Vec3 m_77382_(@NotNull Entity entity, int index) {
        this.checkProcessed();
        return super.m_77382_(entity, index);
    }

    @NotNull
    public BlockPos m_77396_(int index) {
        this.checkProcessed();
        return super.m_77396_(index);
    }

    @NotNull
    public Vec3 m_77380_(@NotNull Entity entity) {
        this.checkProcessed();
        return super.m_77380_(entity);
    }

    @NotNull
    public BlockPos m_77400_() {
        this.checkProcessed();
        return super.m_77400_();
    }

    @NotNull
    public Node m_77401_() {
        this.checkProcessed();
        return super.m_77401_();
    }

    @Nullable
    public Node m_77402_() {
        this.checkProcessed();
        return super.m_77402_();
    }
}

