/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.network.MessageToClientUpdateLeaderScreen;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessagePatrolLeaderRemoveWayPoint
implements Message<MessagePatrolLeaderRemoveWayPoint> {
    private UUID worker;

    public MessagePatrolLeaderRemoveWayPoint() {
    }

    public MessagePatrolLeaderRemoveWayPoint(UUID recruit) {
        this.worker = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractLeaderEntity.class, player.m_20191_().m_82400_(100.0), v -> v.m_20148_().equals(this.worker) && v.m_6084_()).forEach(merchant -> this.removeLastWayPoint(player, (AbstractLeaderEntity)merchant));
    }

    private void removeLastWayPoint(ServerPlayer player, AbstractLeaderEntity leaderEntity) {
        if (!leaderEntity.WAYPOINTS.isEmpty()) {
            leaderEntity.WAYPOINTS.pop();
        }
        if (!leaderEntity.WAYPOINT_ITEMS.isEmpty()) {
            leaderEntity.WAYPOINT_ITEMS.pop();
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateLeaderScreen(leaderEntity.WAYPOINTS, leaderEntity.WAYPOINT_ITEMS, leaderEntity.getArmySize()));
    }

    @Override
    public MessagePatrolLeaderRemoveWayPoint fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
    }
}

