/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenSpecialScreen
implements Message<MessageOpenSpecialScreen> {
    private UUID player;
    private UUID recruit;

    public MessageOpenSpecialScreen() {
        this.player = new UUID(0L, 0L);
    }

    public MessageOpenSpecialScreen(Player player, UUID recruit) {
        this.player = player.m_20148_();
        this.recruit = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        if (!player.m_20148_().equals(this.player)) {
            return;
        }
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(16.0), v -> v.m_20148_().equals(this.recruit) && v.m_6084_()).forEach(recruit -> this.tryToOpenSpecialGUI((AbstractRecruitEntity)((Object)recruit), player));
    }

    private void tryToOpenSpecialGUI(AbstractRecruitEntity recruit, ServerPlayer player) {
        if (recruit instanceof ICompanion) {
            ICompanion companion = (ICompanion)((Object)recruit);
            companion.openSpecialGUI((Player)player);
        }
    }

    @Override
    public MessageOpenSpecialScreen fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.recruit = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130077_(this.recruit);
    }
}

