/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.network.MessageToClientUpdateLeaderScreen;
import com.talhanation.recruits.util.NPCArmy;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageAssignGroupToCompanion
implements Message<MessageAssignGroupToCompanion> {
    private UUID ownerUUID;
    private UUID companionUUID;

    public MessageAssignGroupToCompanion() {
    }

    public MessageAssignGroupToCompanion(UUID owner, UUID companionUUID) {
        this.ownerUUID = owner;
        this.companionUUID = companionUUID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerLevel serverLevel = context.getSender().m_20194_().m_129783_();
        int group = -1;
        AbstractLeaderEntity companionEntity = null;
        List list = Objects.requireNonNull(serverLevel.m_45976_(LivingEntity.class, Objects.requireNonNull(context.getSender()).m_20191_().m_82400_(100.0)));
        for (LivingEntity companion : list) {
            if (!companion.m_20148_().equals(this.companionUUID)) continue;
            group = ((AbstractLeaderEntity)companion).getGroup();
            companionEntity = (AbstractLeaderEntity)companion;
            break;
        }
        if (companionEntity == null) {
            return;
        }
        int finalGroup = group;
        list.removeIf(living -> {
            AbstractRecruitEntity recruit;
            return !(living instanceof AbstractRecruitEntity) || (recruit = (AbstractRecruitEntity)((Object)living)).getOwnerUUID() != null && !recruit.getOwnerUUID().equals(this.ownerUUID) || recruit.getGroup() != finalGroup || recruit.m_20148_().equals(this.companionUUID);
        });
        for (LivingEntity living2 : list) {
            if (!(living2 instanceof AbstractRecruitEntity)) continue;
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)living2;
            ICompanion.assignToLeaderCompanion(companionEntity, recruit);
        }
        companionEntity.army = new NPCArmy(serverLevel, list, null);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new MessageToClientUpdateLeaderScreen(companionEntity.WAYPOINTS, companionEntity.WAYPOINT_ITEMS, companionEntity.getArmySize()));
    }

    @Override
    public MessageAssignGroupToCompanion fromBytes(FriendlyByteBuf buf) {
        this.ownerUUID = buf.m_130259_();
        this.companionUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.ownerUUID);
        buf.m_130077_(this.companionUUID);
    }
}

