/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.navigation;

import com.talhanation.recruits.entities.IBoatController;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class SailorNodeEvaluator
extends SwimNodeEvaluator {
    private float oldWaterMalus;
    private float oldBlockedMalus;
    private float oldBreachMalus;

    public SailorNodeEvaluator() {
        super(false);
    }

    public void m_6028_(@NotNull PathNavigationRegion region, @NotNull Mob mob) {
        super.m_6028_(region, mob);
        this.oldWaterMalus = mob.m_21439_(BlockPathTypes.WATER);
        mob.m_21441_(BlockPathTypes.WATER, 8.0f);
        this.oldBlockedMalus = mob.m_21439_(BlockPathTypes.BLOCKED);
        mob.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
        this.oldBreachMalus = mob.m_21439_(BlockPathTypes.BREACH);
        mob.m_21441_(BlockPathTypes.BREACH, 0.0f);
        Entity vehicle = this.f_77313_.m_20202_();
        float width = vehicle != null ? vehicle.m_20205_() + 3.0f : mob.m_20205_() + 1.0f;
        float height = vehicle != null ? vehicle.m_20206_() + 1.0f : mob.m_20206_() + 1.0f;
        this.f_77315_ = Mth.m_14143_((float)width);
        this.f_77316_ = Mth.m_14143_((float)height);
    }

    @Nullable
    protected Node m_5676_(int x, int y, int z) {
        float f;
        Node node = null;
        BlockPathTypes blockpathtypes = this.m_192967_(x, y, z);
        if ((blockpathtypes == BlockPathTypes.WATER || blockpathtypes == BlockPathTypes.BREACH) && (f = this.f_77313_.m_21439_(blockpathtypes)) >= 0.0f && (node = this.getNodeRaw(x, y, z)) != null) {
            node.f_77282_ = blockpathtypes;
            node.f_77281_ = Math.max(node.f_77281_, f);
            BlockPos pos = new BlockPos(x, y, z);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.f_77312_.m_6425_(pos.m_5484_(direction, 2)).m_76178_()) {
                    node.f_77281_ += 4.0f;
                }
                if (this.f_77312_.m_6425_(pos.m_5484_(direction, 4)).m_76178_()) {
                    node.f_77281_ += 8.0f;
                }
                if (!this.f_77312_.m_6425_(pos.m_5484_(direction, 6)).m_76178_()) continue;
                node.f_77281_ += 16.0f;
            }
            if (this.f_77312_.m_6425_(pos.m_6625_(2)).m_76178_()) {
                node.f_77281_ += 4.0f;
            }
            if (this.f_77312_.m_6425_(pos.m_6625_(1)).m_76178_()) {
                node.f_77281_ += 8.0f;
            }
        }
        return node;
    }

    @Nullable
    protected Node getNodeRaw(int x, int y, int z) {
        return (Node)this.f_77314_.computeIfAbsent(Node.m_77295_((int)x, (int)y, (int)z), node -> new Node(x, y, z));
    }

    public void m_6802_() {
        this.f_77313_.m_21441_(BlockPathTypes.WATER, this.oldWaterMalus);
        this.f_77313_.m_21441_(BlockPathTypes.BLOCKED, this.oldBlockedMalus);
        this.f_77313_.m_21441_(BlockPathTypes.BREACH, this.oldBreachMalus);
        super.m_6802_();
    }

    @NotNull
    public Node m_7171_() {
        boolean isWaterDeep = IBoatController.getWaterDepth(this.f_77313_.m_20097_(), (LivingEntity)this.f_77313_) > 3;
        AABB boundingBox = this.f_77313_.m_20202_().m_20191_();
        double nodeX = isWaterDeep ? boundingBox.f_82291_ : boundingBox.f_82288_;
        double nodeZ = isWaterDeep ? boundingBox.f_82293_ : boundingBox.f_82290_;
        return this.getNodeRaw(Mth.m_14107_((double)nodeX), Mth.m_14107_((double)this.f_77313_.m_20186_()), Mth.m_14107_((double)nodeZ));
    }

    @Nullable
    public Target m_7568_(double p_77550_, double p_77551_, double p_77552_) {
        return this.m_230615_(this.getNodeRaw(Mth.m_14107_((double)p_77550_), Mth.m_14107_((double)p_77551_), Mth.m_14107_((double)p_77552_)));
    }
}

