/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.ai.async.FindTarget;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindTargetProcessor {
    private static final int workersCount = (Integer)RecruitsServerConfig.AsyncTargetFindingThreadsCount.get();
    private static final Executor commonExecutor = new ThreadPoolExecutor(1, workersCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("recruits-target-find-processor-%d").setPriority(3).build());

    public static <T extends LivingEntity> void queue(@NotNull FindTarget<T> target, Level level) {
        if (level.m_5776_()) {
            return;
        }
        CompletableFuture.runAsync(target::findTargetNormal, commonExecutor);
    }

    public static <T extends LivingEntity> void awaitProcessing(@Nullable FindTarget<T> findTarget, Level level, Consumer<@Nullable FindTarget<T>> afterProcessing) {
        if (level.m_5776_()) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(level.m_7654_());
        if (findTarget == null) {
            afterProcessing.accept(null);
            return;
        }
        if (!findTarget.isProcessed()) {
            findTarget.postProcessing(() -> server.execute(() -> afterProcessing.accept(findTarget)));
        } else {
            afterProcessing.accept(findTarget);
        }
    }
}

