/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;

public class RecruitProtectEntityGoal
extends Goal {
    private final AbstractRecruitEntity recruit;
    private LivingEntity protectingMob;
    private double range;
    private int timeToRecalcPath;

    public RecruitProtectEntityGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    public boolean m_8036_() {
        return this.recruit.getShouldProtect();
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.protectingMob != null;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.getProtecting();
        boolean isHorseBack = this.recruit.m_20202_() instanceof AbstractHorse;
        this.range = isHorseBack ? 20.0 : 10.0;
    }

    public void clear() {
        this.recruit.shouldProtect(false, null);
        this.recruit.setFollowState(3);
        this.protectingMob = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.protectingMob != null) {
            boolean isClose;
            boolean bl = isClose = (double)this.protectingMob.m_20270_((Entity)this.recruit) <= this.range;
            if (!isClose) {
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.m_183277_(10);
                    this.recruit.m_21573_().m_5624_((Entity)this.protectingMob, (double)1.15f);
                }
                if (this.recruit.f_19862_ || this.recruit.f_185931_) {
                    this.recruit.m_21569_().m_24901_();
                }
            }
        }
        if (this.protectingMob == null || !this.protectingMob.m_6084_()) {
            if (this.protectingMob != null && !this.protectingMob.m_6084_() && this.recruit.getOwner() != null) {
                this.recruit.getOwner().m_213846_((Component)this.TEXT_PROTECT_DIED(this.recruit.m_7755_().getString()));
            }
            this.clear();
        }
        if (this.recruit.f_19797_ % 20 == 0) {
            this.getProtecting();
            this.checkMounts();
        }
    }

    public void getProtecting() {
        List list = this.recruit.m_20193_().m_45976_(LivingEntity.class, this.recruit.m_20191_().m_82400_(32.0));
        for (LivingEntity livings : list) {
            if (this.recruit.getProtectUUID() == null || !livings.m_20148_().equals(this.recruit.getProtectUUID())) continue;
            this.protectingMob = livings;
        }
    }

    private MutableComponent TEXT_PROTECT_DIED(String name) {
        return Component.m_237110_((String)"chat.recruits.text.protect_died", (Object[])new Object[]{name});
    }

    private void checkMounts() {
        if (this.protectingMob != null) {
            Entity protectingVehicle = this.protectingMob.m_20202_();
            Entity ownVehicle = this.recruit.m_20202_();
            if (protectingVehicle == null) {
                if (ownVehicle instanceof AbstractHorse) {
                    ownVehicle.m_8127_();
                } else {
                    this.recruit.m_8127_();
                }
            } else if (protectingVehicle instanceof Boat) {
                Boat boat = (Boat)protectingVehicle;
                if (ownVehicle instanceof AbstractHorse) {
                    ownVehicle.m_20329_((Entity)boat);
                } else {
                    this.recruit.shouldMount(true, boat.m_20148_());
                }
            }
        }
    }
}

