/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.async.FindTarget;
import com.talhanation.recruits.entities.ai.async.FindTargetProcessor;
import com.talhanation.recruits.util.ProcessState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;

public class RecruitNearestAttackableTargetGoal<T extends LivingEntity>
extends Goal {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Predicate<LivingEntity> predicate;
    protected final Class<T> targetType;
    private final AbstractRecruitEntity recruit;
    protected Deque<LivingEntity> targets = new ArrayDeque<LivingEntity>();
    private long lastCanUseCheck;
    private FindTarget<T> findTarget;

    public RecruitNearestAttackableTargetGoal(AbstractRecruitEntity recruit, Class<T> targetType, boolean mustSee, boolean mustReach, @Nullable Predicate<LivingEntity> predicate) {
        this.recruit = recruit;
        this.targetType = targetType;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.predicate = predicate;
    }

    public boolean m_8036_() {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return false;
        }
        long i = this.recruit.m_20193_().m_46467_();
        if (i - this.lastCanUseCheck >= 20L) {
            this.lastCanUseCheck = i;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.targets.isEmpty();
    }

    public void m_8056_() {
        if (this.findTarget == null) {
            this.findTarget = new FindTarget<T>((Mob)this.recruit, this.targetType, this.getFollowDistance(), this.predicate);
        } else {
            this.findTarget.reset();
        }
        if (((Boolean)RecruitsServerConfig.UseAsyncTargetFinding.get()).booleanValue()) {
            this.scheduleFindTargets();
        } else {
            this.findNewTargets();
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        LivingEntity entity = this.recruit.m_5448_();
        if (!(this.targets.isEmpty() || entity != null && entity.m_6084_())) {
            this.selectNextTarget();
        }
    }

    private void findNewTargets() {
        this.findTarget.findTargetNormal();
        if (this.findTarget.getTargets() == null) {
            return;
        }
        this.targets = this.findTarget.getTargets();
    }

    private void selectNextTarget() {
        while (!this.targets.isEmpty()) {
            LivingEntity target = this.targets.pop();
            if (target == null) {
                return;
            }
            boolean seeing = this.recruit.m_142582_((Entity)target);
            boolean isInFight = this.isInFight(target);
            boolean alive = target.m_6084_();
            if (!alive || !seeing || isInFight) continue;
            this.recruit.m_6710_(target);
            return;
        }
    }

    private boolean canReach(LivingEntity p_26149_) {
        int j;
        Path path = this.recruit.m_21573_().m_6570_((Entity)p_26149_, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - p_26149_.m_146903_();
        return (double)(i * i + (j = node.f_77273_ - p_26149_.m_146907_()) * j) <= 2.25;
    }

    private boolean isInFight(LivingEntity living) {
        if (living != null) {
            int targetLastHurt = this.recruit.f_19797_ - living.m_21213_();
            LivingEntity targetHurtEntity = living.m_21188_();
            if (targetHurtEntity != null && !targetHurtEntity.equals((Object)this.recruit)) {
                return targetLastHurt < 10;
            }
        }
        return false;
    }

    protected double getFollowDistance() {
        return this.recruit.m_21133_(Attributes.f_22277_);
    }

    private synchronized void scheduleFindTargets() {
        this.lock.readLock().lock();
        try {
            if (this.findTarget.processState == ProcessState.PROCESSING) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            FindTargetProcessor.queue(this.findTarget, this.recruit.m_20193_());
            FindTargetProcessor.awaitProcessing(this.findTarget, this.recruit.m_20193_(), processedFindTarget -> {
                if (processedFindTarget == null || processedFindTarget != this.findTarget) {
                    return;
                }
                this.targets = processedFindTarget.getTargets();
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

