/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.util.AttackUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RecruitMeleeAttackGoal
extends Goal {
    protected final AbstractRecruitEntity recruit;
    private final double speedModifier;
    private Path path;
    private int pathingCooldown;
    private final double range;

    public RecruitMeleeAttackGoal(AbstractRecruitEntity recruit, double speedModifier, double range) {
        this.recruit = recruit;
        this.speedModifier = speedModifier;
        this.range = range;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.recruit.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        boolean isClose = target.m_20280_((Entity)this.recruit) <= this.range * this.range;
        boolean canSee = this.recruit.m_21574_().m_148306_((Entity)target);
        if (isClose && canSee && this.canAttackHoldPos() && this.recruit.getState() != 3 && !this.recruit.needsToGetFood() && !this.recruit.getShouldMount() && !this.recruit.getShouldMovePos()) {
            double distance = this.recruit.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.path = this.recruit.m_21573_().m_6570_((Entity)target, 0);
            if (this.path != null) {
                return true;
            }
            double reach = AttackUtil.getAttackReachSqr((LivingEntity)this.recruit);
            return reach >= distance && this.canAttackHoldPos();
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity target = this.recruit.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (!this.recruit.m_21574_().m_148306_((Entity)target)) {
            return false;
        }
        boolean canAttackHoldPos = this.canAttackHoldPos();
        boolean needsToGetFood = this.recruit.needsToGetFood();
        boolean getShouldMount = this.recruit.getShouldMount();
        boolean getShouldMovePos = this.recruit.getShouldMovePos();
        return (!(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_()) && canAttackHoldPos && this.recruit.getState() != 3 && !needsToGetFood && !getShouldMount && !getShouldMovePos;
    }

    public void m_8056_() {
        this.recruit.m_21561_(true);
        this.pathingCooldown = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.recruit.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.recruit.m_6710_(null);
        }
        this.recruit.m_21561_(false);
        if (!this.recruit.isFollowing()) {
            this.recruit.m_21573_().m_26573_();
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.pathingCooldown > 0) {
            --this.pathingCooldown;
        }
        if (this.recruit.f_19862_ || this.recruit.f_185931_) {
            this.recruit.m_21569_().m_24901_();
        }
        if ((target = this.recruit.m_5448_()) != null && target.m_6084_()) {
            boolean coolDownElapsed;
            this.recruit.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distanceToTarget = this.recruit.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = AttackUtil.getAttackReachSqr((LivingEntity)this.recruit);
            boolean canSee = this.recruit.m_21574_().m_148306_((Entity)target);
            boolean isNotFollowing = !this.recruit.isFollowing();
            boolean bl = coolDownElapsed = this.pathingCooldown <= 0;
            if (distanceToTarget <= reach && canSee) {
                if (isNotFollowing) {
                    this.recruit.m_21573_().m_26573_();
                }
                AttackUtil.performAttack(this.recruit, target);
            } else if (canSee && isNotFollowing && coolDownElapsed) {
                this.pathingCooldown = 4 + this.recruit.m_217043_().m_188503_(4);
                if (distanceToTarget > 2024.0) {
                    this.pathingCooldown += 10;
                } else if (distanceToTarget > 256.0) {
                    this.pathingCooldown += 5;
                }
                this.recruit.m_21573_().m_5624_((Entity)target, this.speedModifier);
            }
        }
    }

    private boolean canAttackHoldPos() {
        Vec3 pos = this.recruit.getHoldPos();
        LivingEntity target = this.recruit.m_5448_();
        if (target != null && pos != null && this.recruit.getShouldHoldPos()) {
            double distanceToPos = target.m_20238_(pos);
            double ref = this.recruit.isInFormation ? 169.0 : 400.0;
            return distanceToPos < ref;
        }
        return true;
    }
}

