/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.IBoatController;
import com.talhanation.recruits.entities.ai.navigation.SailorPathNavigation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class CaptainControlBoatAI
extends Goal {
    private final CaptainEntity captain;
    private LivingEntity target;
    private State state;
    private Path path;
    private Node node;
    private BlockPos sailPos;
    private int timer;
    private float precision;
    public final boolean DEBUG = false;
    private byte stoppingTimer = 0;
    private int attackingTimeOut = 0;
    public final int ATTACKING_TIME_OUT = 3000;
    public final int ATTACKING_RANGE = 4000;
    public final int TARGETING_RANGE = 5000;
    public final int STOP_RANGE_LAND_TARGET = 4500;

    public CaptainControlBoatAI(IBoatController sailor) {
        this.captain = sailor.getCaptain();
    }

    public boolean m_8036_() {
        Boat boat;
        Entity entity = this.captain.m_20202_();
        return entity instanceof Boat && ((Entity)(boat = (Boat)entity).m_20197_().get(0)).equals((Object)this.captain) && boat.m_20078_().contains("smallships");
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.state = State.IDLE;
        this.precision = 100.0f;
    }

    public void m_8041_() {
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (!this.captain.m_20193_().m_5776_()) {
            if (this.captain.getFollowState() == 1 && this.captain.getOwner() != null) {
                if (this.sailPos == null || this.captain.f_19797_ % 20 == 0) {
                    this.captain.setSailPos(this.captain.getOwner().m_20097_());
                    this.sailPos = this.captain.getSailPos();
                    this.state = this.path != null && this.node != null ? State.MOVING_PATH : State.CREATING_PATH;
                }
            } else if (this.captain.getFollowState() == 5 && this.captain.getProtectingMob() != null) {
                if (this.sailPos == null || this.captain.f_19797_ % 30 == 0) {
                    this.captain.setSailPos(this.captain.getProtectingMob().m_20097_());
                    this.sailPos = this.captain.getSailPos();
                    this.state = State.CREATING_PATH;
                }
            } else if (this.sailPosChanged() && !this.captain.shipAttacking) {
                this.sailPos = this.captain.getSailPos();
                this.state = State.CREATING_PATH;
            }
            switch (this.state) {
                case IDLE: {
                    if (this.canAttackTarget()) {
                        double distance = this.captain.m_20275_(this.target.m_20185_(), this.captain.m_20186_(), this.target.m_20189_());
                        this.captain.shipAttacking = true;
                        if (distance > 4000.0) {
                            this.sailPos = this.captain.m_5448_().m_20097_();
                            this.state = State.CREATING_PATH;
                        } else {
                            this.state = State.ATTACKING;
                        }
                    } else {
                        if (this.captain.getShouldStrategicFire()) {
                            this.state = State.STRATEGIC;
                            break;
                        }
                        if (this.captain.getSailPos() != null) {
                            this.sailPos = this.captain.getSailPos();
                            this.state = State.CREATING_PATH;
                        }
                    }
                    if (this.captain.f_19797_ % 20 != 0) break;
                    if (this.captain.canRepair()) {
                        IBoatController.repairShip(this.captain);
                    }
                    this.captain.refillCannonBalls();
                    break;
                }
                case CREATING_PATH: {
                    PathNavigation pathNavigation;
                    if (this.captain.getShouldStrategicFire()) {
                        this.state = State.STRATEGIC;
                        break;
                    }
                    if (this.sailPos != null && (pathNavigation = this.captain.m_21573_()) instanceof SailorPathNavigation) {
                        SailorPathNavigation sailorPathNavigation = (SailorPathNavigation)pathNavigation;
                        this.path = sailorPathNavigation.createPath(this.sailPos, 32, false, 0);
                        if (this.path == null) break;
                        this.node = this.path.m_77401_();
                        this.state = State.MOVING_PATH;
                        break;
                    }
                    this.state = State.IDLE;
                    break;
                }
                case MOVING_PATH: {
                    double distanceToNode;
                    int reach = this.getTargetReach();
                    if (this.captain.m_20275_(this.sailPos.m_123341_(), this.captain.m_20186_(), this.sailPos.m_123343_()) < (double)reach) {
                        this.node = null;
                        this.path = null;
                        this.state = State.DONE;
                        break;
                    }
                    if (this.canAttackTarget()) {
                        double distanceToTarget = this.captain.m_20275_(this.target.m_20185_(), this.captain.m_20186_(), this.target.m_20189_());
                        if (distanceToTarget <= 4000.0) {
                            this.captain.shipAttacking = true;
                            this.state = State.ATTACKING;
                            break;
                        }
                    } else if (this.captain.getShouldStrategicFire()) {
                        this.state = State.STRATEGIC;
                        break;
                    }
                    if ((distanceToNode = this.captain.m_20275_(this.node.f_77271_, this.captain.m_20186_(), this.node.f_77273_)) <= (double)this.precision) {
                        this.path.m_77374_();
                        this.precision = this.isNeighborsWater(this.node) ? this.captain.getPrecisionMax() : this.captain.getPrecisionMin();
                        if (this.path.m_77398_() == this.path.m_77399_() - 1 || this.node.equals((Object)this.path.m_77395_())) {
                            this.node = null;
                            this.state = State.CREATING_PATH;
                        }
                        try {
                            this.node = this.path.m_77401_();
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.node = (Node)this.path.f_77362_.get(this.path.f_77362_.size() - 1);
                        }
                    } else if (++this.timer > 50) {
                        if (this.precision < 300.0f) {
                            this.precision += 25.0f;
                        } else {
                            this.precision = 50.0f;
                            this.state = State.CREATING_PATH;
                        }
                        this.timer = 0;
                    }
                    if (!(distanceToNode >= 3.0)) break;
                    this.captain.updateBoatControl(this.node.f_77271_, this.node.f_77273_, 1.0, 1.1f, this.path);
                    break;
                }
                case DONE: {
                    this.captain.setSailPos(Optional.empty());
                    this.captain.setSmallShipsSailState((Boat)this.captain.m_20202_(), 0);
                    this.stoppingTimer = (byte)(this.stoppingTimer + 1);
                    if (this.stoppingTimer <= 25) break;
                    this.stoppingTimer = 0;
                    this.state = this.captain.shipAttacking && this.canAttackTarget() ? State.ATTACKING : State.IDLE;
                    break;
                }
                case ATTACKING: {
                    if (this.canContinueAttack() && this.captain.shipAttacking && ++this.attackingTimeOut < 3000) {
                        double beta;
                        Vec3 toTarget = this.target.m_20202_() != null ? this.captain.m_20182_().m_82505_(this.target.m_20202_().m_20182_()) : this.captain.m_20182_().m_82505_(this.target.m_20182_());
                        double distanceToTarget = this.captain.m_20275_(this.target.m_20185_(), this.captain.m_20186_(), this.target.m_20189_());
                        if (distanceToTarget > 5000.0) {
                            this.captain.shipAttacking = false;
                            this.attackingTimeOut = 0;
                            this.target = null;
                            this.state = State.IDLE;
                            this.captain.setPatrolState(AbstractLeaderEntity.State.IDLE);
                            break;
                        }
                        this.captain.setSmallShipsSailState((Boat)this.captain.m_20202_(), 0);
                        Vec3 forward = this.captain.m_20202_().m_20156_().m_82541_();
                        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
                        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
                        double distanceToLeft = toTarget.m_82554_(VecLeft);
                        double distanceToRight = toTarget.m_82554_(VecRight);
                        boolean shootLeftSide = distanceToLeft < distanceToRight;
                        double alpha = IBoatController.horizontalAngleBetweenVectors(forward, toTarget);
                        double phi = shootLeftSide ? -alpha : alpha;
                        double ref = shootLeftSide ? -90.0 : 90.0;
                        boolean inputLeft = phi < ref;
                        boolean inputRight = phi > ref;
                        IBoatController.rotateSmallShip((Boat)this.captain.m_20202_(), inputLeft, inputRight);
                        double d = beta = shootLeftSide ? IBoatController.horizontalAngleBetweenVectors(forward.m_82524_(1.57f), toTarget) : IBoatController.horizontalAngleBetweenVectors(forward.m_82524_(-1.57f), toTarget);
                        if (!(beta < 10.0)) break;
                        IBoatController.shootCannonsSmallShip(this.captain, (Boat)this.captain.m_20202_(), this.target, shootLeftSide);
                        break;
                    }
                    this.captain.shipAttacking = false;
                    this.attackingTimeOut = 0;
                    this.target = null;
                    this.captain.setPatrolState(AbstractLeaderEntity.State.PATROLLING);
                    this.state = State.IDLE;
                    break;
                }
                case STRATEGIC: {
                    if (this.captain.getShouldStrategicFire() && this.captain.StrategicFirePos() != null) break;
                    this.state = State.IDLE;
                }
            }
        }
    }

    private boolean canAttackTarget() {
        if (this.captain.m_5448_() != null) {
            this.target = this.captain.m_5448_();
            return this.captain.canAttackWhilePatrolling(this.target) && this.captain.m_20202_() != null && this.target != null && this.target.m_6084_() && !this.target.m_5842_();
        }
        return false;
    }

    private boolean canContinueAttack() {
        boolean notnull = this.target != null && this.target.m_6084_();
        boolean can = this.captain.canAttackWhilePatrolling(this.target);
        boolean notUnderwater = !this.target.m_5842_();
        return notnull && notUnderwater && can;
    }

    private int getTargetReach() {
        if (this.captain.getFollowState() == 1 || this.captain.getFollowState() == 5) {
            return 400;
        }
        if (this.target != null && this.target.m_20096_()) {
            return 4500;
        }
        return this.captain.shipAttacking ? 4000 : 25;
    }

    private boolean isNeighborsWater(Node node) {
        for (int i = -2; i <= 2; ++i) {
            for (int k = -2; k <= 2; ++k) {
                BlockPos pos = new BlockPos(node.f_77271_, (int)this.captain.m_20186_(), node.f_77273_).m_7918_(i, 0, k);
                BlockState state = this.captain.m_20193_().m_8055_(pos);
                if (state.m_60713_(Blocks.f_49990_) && state.m_60713_(Blocks.f_50576_) && state.m_60713_(Blocks.f_50575_)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean sailPosChanged() {
        return this.captain.getSailPos() != null && !this.captain.getSailPos().equals((Object)this.sailPos);
    }

    static enum State {
        IDLE,
        CREATING_PATH,
        MOVING_PATH,
        DONE,
        ATTACKING,
        STRATEGIC;

    }
}

