/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractChunkLoaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.ai.UseShield;
import com.talhanation.recruits.network.MessageToClientOpenMessengerAnswerScreen;
import com.talhanation.recruits.network.MessageToClientSetToast;
import com.talhanation.recruits.pathfinding.AsyncGroundPathNavigation;
import com.talhanation.recruits.world.RecruitsPatrolSpawn;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class MessengerEntity
extends AbstractChunkLoaderEntity
implements ICompanion {
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(MessengerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> MESSENGER_STATE = SynchedEntityData.m_135353_(MessengerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WAITING_TIME = SynchedEntityData.m_135353_(MessengerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> TARGETPLAYER = SynchedEntityData.m_135353_(MessengerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private String ownerName = "";
    private String message = "";
    public int teleportWaitTimer;
    private int arrivedWaitTimer;
    public boolean targetPlayerOpened;
    public BlockPos initialPos;
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());

    public MessengerEntity(EntityType<? extends AbstractChunkLoaderEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(MESSENGER_STATE, (Object)0);
        this.f_19804_.m_135372_(WAITING_TIME, (Object)0);
        this.f_19804_.m_135372_(TARGETPLAYER, (Object)new CompoundTag());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new UseShield(this));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Message", this.getMessage());
        if (this.getTargetPlayerInfo() != null) {
            nbt.m_128365_("TargetPlayerInfo", (Tag)this.getTargetPlayerInfo().toNBT());
        }
        nbt.m_128359_("OwnerName", this.getOwnerName());
        nbt.m_128405_("waitTimer", this.teleportWaitTimer);
        nbt.m_128405_("arrivedWaitTimer", this.arrivedWaitTimer);
        nbt.m_128405_("waitingTime", this.getWaitingTime());
        if (this.getMessengerState() != null) {
            nbt.m_128405_("state", this.getMessengerState().getIndex());
        }
        if (this.initialPos != null) {
            nbt.m_128405_("initialPosX", this.initialPos.m_123341_());
            nbt.m_128405_("initialPosY", this.initialPos.m_123342_());
            nbt.m_128405_("initialPosZ", this.initialPos.m_123343_());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("TargetPlayerInfo")) {
            this.setTargetPlayerInfo(RecruitsPlayerInfo.getFromNBT(nbt.m_128469_("TargetPlayerInfo")));
        }
        this.setMessage(nbt.m_128461_("Message"));
        this.setOwnerName(nbt.m_128461_("OwnerName"));
        this.setWaitingTime(nbt.m_128451_("waitingTime"));
        this.teleportWaitTimer = nbt.m_128451_("waitTimer");
        this.arrivedWaitTimer = nbt.m_128451_("arrivedWaitTimer");
        if (nbt.m_128441_("state")) {
            this.setMessengerState(MessengerState.fromIndex(nbt.m_128451_("state")));
        }
        if (nbt.m_128441_("initialPosX")) {
            this.initialPos = new BlockPos(nbt.m_128451_("initialPosX"), nbt.m_128451_("initialPosY"), nbt.m_128451_("initialPosZ"));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((AsyncGroundPathNavigation)this.m_21573_()).setCanOpenDoors(true);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.setDropEquipment();
        this.m_21530_();
        if (this.getOwner() != null) {
            this.setOwnerName(this.getOwner().m_7755_().getString());
        }
        AbstractRecruitEntity.applySpawnValues(this);
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SwordItem && this.m_21205_().m_41619_() || itemStack.m_41720_() instanceof ShieldItem && this.m_21206_().m_41619_()) {
            return !this.hasSameTypeOfItem(itemStack);
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CrossbowItem) && !(itemStack.m_41720_() instanceof BowItem);
    }

    @Override
    public AbstractRecruitEntity get() {
        return this;
    }

    @Nullable
    public ServerPlayer getTargetPlayer() {
        if (this.getTargetPlayerInfo() != null && !this.m_20193_().m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)this.m_20193_();
            return serverLevel.m_7654_().m_6846_().m_11259_(this.getTargetPlayerInfo().getUUID());
        }
        return null;
    }

    @Override
    public void openSpecialGUI(Player player) {
    }

    public void openAnswerGUI(Player player) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.getTargetPlayerInfo() != null) {
                Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageToClientOpenMessengerAnswerScreen(this, this.message, this.getTargetPlayerInfo()));
            }
        }
    }

    @Override
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        MessengerState state = this.getMessengerState();
        if (this.getTargetPlayer() != null && this.getTargetPlayer().m_20148_().equals(player.m_20148_()) && !this.getTargetPlayer().m_20148_().equals(this.getOwnerUUID()) && state == MessengerState.ARRIVED || state == MessengerState.WAITING || state == MessengerState.MOVING_TO_TARGET_PLAYER) {
            this.openAnswerGUI(player);
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)name);
    }

    @Override
    public boolean isAtMission() {
        return this.getMessengerState() != MessengerState.IDLE;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public RecruitsPlayerInfo getTargetPlayerInfo() {
        return RecruitsPlayerInfo.getFromNBT((CompoundTag)this.f_19804_.m_135370_(TARGETPLAYER));
    }

    public void setTargetPlayerInfo(RecruitsPlayerInfo info) {
        this.f_19804_.m_135381_(TARGETPLAYER, (Object)info.toNBT());
    }

    public void setWaitingTime(int x) {
        this.f_19804_.m_135381_(WAITING_TIME, (Object)x);
    }

    public int getWaitingTime() {
        return (Integer)this.f_19804_.m_135370_(WAITING_TIME);
    }

    public void setMessengerState(MessengerState state) {
        this.f_19804_.m_135381_(MESSENGER_STATE, (Object)state.getIndex());
    }

    public MessengerState getMessengerState() {
        return MessengerState.fromIndex((Integer)this.f_19804_.m_135370_(MESSENGER_STATE));
    }

    public void start() {
        if (!this.m_20193_().m_5776_()) {
            this.initialPos = this.m_20097_();
            ServerLevel serverLevel = (ServerLevel)this.m_20193_();
            MinecraftServer server = serverLevel.m_7654_();
            ServerPlayer targetPlayer = server.m_6846_().m_11259_(this.getTargetPlayerInfo().getUUID());
            if (this.getOwner() != null) {
                if (targetPlayer == null || targetPlayer.equals((Object)this.getOwner())) {
                    this.getOwner().m_213846_((Component)this.PLAYER_NOT_FOUND());
                    return;
                }
                this.getOwner().m_213846_((Component)this.MESSENGER_INFO_ON_MY_WAY());
            }
            this.setListen(false);
            this.setState(3);
            this.teleportWaitTimer = 200;
            this.setMessengerState(MessengerState.TELEPORT);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        MessengerState state = this.getMessengerState();
        if (state != null && !this.m_20193_().m_5776_()) {
            switch (state) {
                case IDLE: {
                    break;
                }
                case TELEPORT: {
                    if (--this.teleportWaitTimer > 0) break;
                    ServerPlayer targetPlayer = this.getTargetPlayer();
                    this.teleportNearTargetPlayer((Player)targetPlayer);
                    this.arriveAtTargetPlayer(targetPlayer);
                    this.setFollowState(0);
                    this.setMessengerState(MessengerState.MOVING_TO_TARGET_PLAYER);
                    break;
                }
                case MOVING_TO_TARGET_PLAYER: {
                    ServerPlayer targetPlayer = this.getTargetPlayer();
                    if (targetPlayer != null) {
                        double distance;
                        if (this.f_19797_ % 20 == 0) {
                            this.m_21573_().m_5624_((Entity)targetPlayer, 1.0);
                        }
                        if (!((distance = this.m_20280_((Entity)targetPlayer)) <= 60.0)) break;
                        if (this.getOwner() != null) {
                            this.getOwner().m_213846_((Component)this.MESSENGER_ARRIVED_AT_TARGET_OWNER());
                        }
                        if (!this.m_21205_().m_41619_()) {
                            targetPlayer.m_213846_((Component)this.MESSENGER_INFO_AT_TARGET_WITH_ITEM());
                        } else {
                            targetPlayer.m_213846_((Component)this.MESSENGER_INFO_AT_TARGET());
                        }
                        this.setFollowState(2);
                        this.arrivedWaitTimer = 1500;
                        this.targetPlayerOpened = false;
                        this.setMessengerState(MessengerState.ARRIVED);
                        break;
                    }
                    if (this.getOwner() != null) {
                        this.getOwner().m_213846_((Component)this.MESSENGER_ARRIVED_NO_TARGET_PLAYER());
                    }
                    this.teleportWaitTimer = 100;
                    this.setMessengerState(MessengerState.TELEPORT_BACK);
                    break;
                }
                case ARRIVED: {
                    if (--this.arrivedWaitTimer < 0) {
                        if (this.getOwner() != null) {
                            this.getOwner().m_213846_((Component)this.MESSENGER_ARRIVED_NO_TARGET_PLAYER());
                        }
                        this.teleportWaitTimer = 0;
                        this.setMessengerState(MessengerState.TELEPORT_BACK);
                    }
                    if (!this.targetPlayerOpened) break;
                    this.setMessengerState(MessengerState.WAITING);
                    this.setWaitingTime(6000);
                    break;
                }
                case WAITING: {
                    int time;
                    if (this.f_19797_ % 20 == 0) {
                        this.m_21573_().m_26573_();
                        if (this.getTargetPlayer() != null) {
                            this.m_21563_().m_148051_((Entity)this.getTargetPlayer());
                        }
                    }
                    if ((time = this.getWaitingTime()) > 0) {
                        this.setWaitingTime(--time);
                        break;
                    }
                    if (this.getOwner() != null) {
                        if (this.targetPlayerOpened) {
                            this.getOwner().m_213846_((Component)this.MESSENGER_ARRIVED_TARGET_PLAYER_NOT_ANSWERED());
                        } else {
                            this.getOwner().m_213846_((Component)this.MESSENGER_ARRIVED_NO_TARGET_PLAYER());
                        }
                    }
                    this.teleportWaitTimer = 100;
                    this.setMessengerState(MessengerState.TELEPORT_BACK);
                    break;
                }
                case TELEPORT_BACK: {
                    if (--this.teleportWaitTimer > 0) break;
                    this.teleportNearOwner();
                    this.setMessengerState(MessengerState.MOVING_TO_OWNER);
                    break;
                }
                case MOVING_TO_OWNER: {
                    if (this.getOwner() != null) {
                        if (!(this.m_20280_((Entity)this.getOwner()) < 50.0)) break;
                        this.setListen(true);
                        this.setMessengerState(MessengerState.IDLE);
                        break;
                    }
                    this.teleportNearOwner();
                    this.setMessengerState(MessengerState.IDLE);
                }
            }
        }
    }

    public void dropDeliverItem() {
        ItemStack deliverItem = this.m_21205_();
        if (!deliverItem.m_41619_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.getInventory().m_6596_();
            ItemEntity itementity = new ItemEntity(this.m_20193_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 2.0, this.m_20189_() + this.m_20154_().f_82481_, deliverItem);
            this.getInventory().m_6596_();
            this.m_20193_().m_7967_((Entity)itementity);
        }
    }

    private void teleportNearOwner() {
        if (!this.m_20193_().m_5776_()) {
            if (this.getOwner() != null) {
                Entity entity;
                BlockPos targetPos = this.getOwner().m_20097_();
                BlockPos tpPos = RecruitsPatrolSpawn.func_221244_a(targetPos, 10, new Random(), (ServerLevel)this.m_20193_());
                if (tpPos == null) {
                    tpPos = targetPos;
                }
                if ((entity = this.m_20202_()) instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)entity;
                    horse.m_6021_((double)tpPos.m_123341_(), (double)tpPos.m_123342_(), (double)tpPos.m_123343_());
                } else {
                    this.m_6021_(tpPos.m_123341_(), tpPos.m_123342_(), tpPos.m_123343_());
                }
                this.setFollowState(1);
            } else {
                Entity entity;
                BlockPos tpPos = RecruitsPatrolSpawn.func_221244_a(this.initialPos, 10, new Random(), (ServerLevel)this.m_20193_());
                if (tpPos == null) {
                    tpPos = this.initialPos;
                }
                if ((entity = this.m_20202_()) instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)entity;
                    horse.m_6021_((double)tpPos.m_123341_(), (double)tpPos.m_123342_(), (double)tpPos.m_123343_());
                } else {
                    this.m_6021_(tpPos.m_123341_(), tpPos.m_123342_(), tpPos.m_123343_());
                }
                this.setHoldPos(Vec3.m_82512_((Vec3i)this.initialPos));
                this.setFollowState(3);
            }
        }
    }

    private void teleportNearTargetPlayer(Player player) {
        if (!this.m_20193_().m_5776_() && player != null) {
            Entity entity;
            BlockPos targetPos = player.m_20097_();
            BlockPos tpPos = RecruitsPatrolSpawn.func_221244_a(targetPos, 20, new Random(), (ServerLevel)this.m_20193_());
            if (tpPos == null) {
                tpPos = targetPos;
            }
            if ((entity = this.m_20202_()) instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)entity;
                horse.m_6021_((double)tpPos.m_123341_(), (double)tpPos.m_123342_(), (double)tpPos.m_123343_());
            } else {
                this.m_6021_(tpPos.m_123341_(), tpPos.m_123342_(), tpPos.m_123343_());
            }
        }
    }

    public void playHornSound() {
        this.m_5496_((SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(1)).get(), 20.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
    }

    public void arriveAtTargetPlayer(ServerPlayer target) {
        this.tellTargetPlayerArrived(target);
        this.playHornSound();
    }

    public void tellTargetPlayerArrived(ServerPlayer target) {
        if (target == null) {
            return;
        }
        Team ownerTeam = this.m_5647_();
        if (ownerTeam != null) {
            target.m_213846_((Component)this.MESSENGER_ARRIVED_TEAM(this.getOwnerName(), ownerTeam.m_5758_()));
        } else {
            target.m_213846_((Component)this.MESSENGER_ARRIVED(this.getOwnerName()));
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new MessageToClientSetToast(1, this.getOwnerName()));
    }

    private MutableComponent PLAYER_NOT_FOUND() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_player_not_found", (Object[])new Object[]{this.m_7755_().getString()});
    }

    private MutableComponent MESSENGER_ARRIVED(String ownerName) {
        return Component.m_237110_((String)"chat.recruits.text.messenger_arrived_at_target", (Object[])new Object[]{this.m_7755_().getString(), ownerName});
    }

    private MutableComponent MESSENGER_ARRIVED_TEAM(String ownerName, String teamName) {
        return Component.m_237110_((String)"chat.recruits.text.messenger_arrived_at_target_team", (Object[])new Object[]{this.m_7755_().getString(), ownerName, teamName});
    }

    private MutableComponent MESSENGER_ARRIVED_AT_TARGET_OWNER() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_arrived_at_target_owner", (Object[])new Object[]{this.m_7755_().getString(), this.getTargetPlayerInfo().getName()});
    }

    private MutableComponent MESSENGER_INFO_AT_TARGET() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_info_to_target", (Object[])new Object[]{this.m_7755_().getString(), this.getOwnerName()});
    }

    private MutableComponent MESSENGER_INFO_AT_TARGET_WITH_ITEM() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_info_to_target_with_item", (Object[])new Object[]{this.m_7755_().getString(), this.getOwnerName()});
    }

    public MutableComponent MESSENGER_INFO_ON_MY_WAY() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_info_on_my_way", (Object[])new Object[]{this.m_7755_().getString()});
    }

    private MutableComponent MESSENGER_ARRIVED_NO_TARGET_PLAYER() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_arrived_no_player", (Object[])new Object[]{this.m_7755_().getString(), this.getTargetPlayerInfo().getName()});
    }

    private MutableComponent MESSENGER_ARRIVED_TARGET_PLAYER_NOT_ANSWERED() {
        return Component.m_237110_((String)"chat.recruits.text.messenger_target_player_not_answered", (Object[])new Object[]{this.m_7755_().getString()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldGlow() {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        MessengerState messengerState = this.getMessengerState();
        if (this.getTargetPlayerInfo() != null && clientPlayer != null) {
            UUID uuid = this.getTargetPlayerInfo().getUUID();
            return clientPlayer.m_20148_().equals(uuid) && messengerState == MessengerState.ARRIVED || messengerState == MessengerState.MOVING_TO_TARGET_PLAYER;
        }
        return false;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource dmg, float amt) {
        MessengerState state = this.getMessengerState();
        if (state == null || state == MessengerState.IDLE) {
            return super.m_6469_(dmg, amt);
        }
        return false;
    }

    public static enum MessengerState {
        IDLE(0),
        TELEPORT(1),
        MOVING_TO_TARGET_PLAYER(2),
        ARRIVED(3),
        WAITING(4),
        TELEPORT_BACK(5),
        MOVING_TO_OWNER(6);

        private final int index;

        private MessengerState(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static MessengerState fromIndex(int index) {
            for (MessengerState messengerState : MessengerState.values()) {
                if (messengerState.getIndex() != index) continue;
                return messengerState;
            }
            throw new IllegalArgumentException("Invalid State index: " + index);
        }
    }
}

