/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public interface IBoatController {
    @Nullable
    public static ItemStack getSmallShipsItem() {
        return ((Item)ForgeRegistries.ITEMS.getDelegateOrThrow(ResourceLocation.m_135820_((String)"smallships:oak_cog")).get()).m_7968_();
    }

    public static void repairShip(CaptainEntity captain) {
        block4: {
            int amount = 10 + captain.m_20193_().f_46441_.m_188503_(5);
            try {
                ItemStack itemStack;
                int i;
                Class<?> shipClass;
                Boat boat;
                Entity entity;
                if (!Main.isSmallShipsLoaded || !Main.isSmallShipsCompatible || !((entity = captain.m_20202_()) instanceof Boat) || !(boat = (Boat)entity).m_20078_().contains("smallships") || !(shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship")).isInstance(boat)) break block4;
                Object ship = shipClass.cast(boat);
                Method getDamageMethod = shipClass.getMethod("getDamage", new Class[0]);
                float damage = ((Float)getDamageMethod.invoke(ship, new Object[0])).floatValue();
                if (!(damage > 5.0f)) break block4;
                Method shipRepairMethod = shipClass.getMethod("repairShip", Integer.TYPE);
                shipRepairMethod.invoke(ship, amount);
                for (i = 0; i < captain.getInventory().m_6643_(); ++i) {
                    itemStack = captain.getInventory().m_8020_(i);
                    if (!itemStack.m_204117_(ItemTags.f_13168_)) continue;
                    itemStack.m_41774_(1);
                    break;
                }
                for (i = 0; i < captain.getInventory().m_6643_(); ++i) {
                    itemStack = captain.getInventory().m_8020_(i);
                    if (!itemStack.m_150930_(Items.f_42749_)) continue;
                    itemStack.m_41774_(1);
                    break;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
    }

    default public CaptainEntity getCaptain() {
        return (CaptainEntity)this;
    }

    public BlockPos getSailPos();

    public float getPrecisionMin();

    public float getPrecisionMax();

    public void setSailPos(BlockPos var1);

    default public void updateBoatControl(double posX, double posZ, double speedFactor, double turnFactor, Path path) {
        Boat boat;
        Entity entity = this.getCaptain().m_20202_();
        if (entity instanceof Boat && ((Entity)(boat = (Boat)entity).m_20197_().get(0)).equals((Object)this.getCaptain())) {
            String string = boat.m_20078_();
            if (Main.isSmallShipsLoaded && Main.isSmallShipsCompatible && string.contains("smallships")) {
                boolean onPosIsDeep = IBoatController.getWaterDepth(boat.m_20097_(), (LivingEntity)this.getCaptain()) >= 7;
                BlockPos targetPos = new BlockPos((int)posX, (int)this.getCaptain().m_20186_(), (int)posZ);
                if (onPosIsDeep && path != null && !boat.f_19862_) {
                    boolean targetIsDeep = IBoatController.getWaterDepth(targetPos, (LivingEntity)this.getCaptain()) >= 7;
                    this.updateSmallShipsBoatControl(this.getCaptain(), boat, targetPos.m_123341_(), targetPos.m_123343_(), targetIsDeep);
                } else {
                    this.updateSmallShipsBoatControl(this.getCaptain(), boat, posX, posZ, false);
                }
            } else {
                this.updateVanillaBoatControl(boat, posX, posZ, speedFactor, turnFactor);
            }
        }
    }

    default public void updateSmallShipsBoatControl(CaptainEntity captainEntity, Boat boat, double posX, double posZ, boolean fast) {
        double ref;
        Vec3 forward = boat.m_20156_().m_82524_(-90.0f).m_82541_();
        Vec3 target = new Vec3(posX, 0.0, posZ);
        Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
        double phi = IBoatController.horizontalAngleBetweenVectors(forward, toTarget);
        boolean inputLeft = phi < (ref = (double)63.334f);
        boolean inputRight = phi > ref;
        boolean inputUp = Math.abs(phi - ref) <= ref * (double)0.35f;
        boolean inAngleForSail = Math.abs(phi - ref) <= ref * 0.6;
        float acceleration = 0.005f;
        float setPoint = 0.0f;
        float boatSpeed = 0.0f;
        boolean isLeashed = false;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassGetSpeed = shipClass.getMethod("getSpeed", new Class[0]);
                Method shipClassUpdateControls = shipClass.getMethod("updateControls", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Player.class);
                Method shipClassIsLeashed = shipClass.getMethod("isShipLeashed", new Class[0]);
                boatSpeed = ((Float)shipClassGetSpeed.invoke(ship, new Object[0])).floatValue();
                isLeashed = (Boolean)shipClassIsLeashed.invoke(ship, new Object[0]);
                shipClassUpdateControls.invoke(ship, inputUp, false, inputLeft, inputRight, null);
                if (boat.m_20069_() && !isLeashed) {
                    if (!inAngleForSail) {
                        this.setSmallShipsSailState((Boat)ship, 0);
                        setPoint = 0.02f;
                    } else if (inputUp) {
                        double distance = toTarget.m_82557_(boat.m_20182_());
                        int state = 3;
                        if (fast) {
                            state = 4;
                            setPoint = 0.3f;
                        } else {
                            setPoint = distance > 20.0 ? 0.15f : 0.075f;
                        }
                        this.setSmallShipsSailState((Boat)ship, state);
                    } else if (this.getCaptain().getFollowState() == 1) {
                        this.setSmallShipsSailState((Boat)ship, 1);
                        setPoint = 0.025f;
                    } else {
                        this.setSmallShipsSailState((Boat)ship, 0);
                        setPoint = 0.0f;
                    }
                    this.calculateSpeed(boat, boatSpeed, acceleration, setPoint);
                    IBoatController.rotateSmallShip(boat, inputLeft, inputRight);
                    boat.m_20334_(this.calculateMotionX(boatSpeed, boat.m_146908_()), boat.m_20184_().f_82480_, this.calculateMotionZ(boatSpeed, boat.m_146908_()));
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    public static boolean rotateShipTowardsPos(Boat boat, Vec3 targetVec) {
        boolean rotated = false;
        if (targetVec != null) {
            double ref;
            Vec3 forward = boat.m_20156_().m_82541_();
            Vec3 target = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82480_);
            Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
            double phi = IBoatController.horizontalAngleBetweenVectors(forward, toTarget);
            boolean inputLeft = phi < (ref = (double)63.334f);
            boolean inputRight = phi > ref;
            IBoatController.rotateSmallShip(boat, inputLeft, inputRight);
            if (Math.abs(phi - ref) <= ref * (double)0.35f) {
                rotated = true;
            }
        }
        return rotated;
    }

    public static void rotateSmallShip(Boat boat, boolean inputLeft, boolean inputRight) {
        float maxRotSp = 2.0f;
        float boatRotSpeed = 0.0f;
        float rotAcceleration = 0.35f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassSetRotSpeed = shipClass.getMethod("setRotSpeed", Float.TYPE);
                Method shipClassGetRotSpeed = shipClass.getMethod("getRotSpeed", new Class[0]);
                Method shipClassUpdateControls = shipClass.getMethod("updateControls", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Player.class);
                boatRotSpeed = ((Float)shipClassGetRotSpeed.invoke(ship, new Object[0])).floatValue();
                shipClassUpdateControls.invoke(ship, false, false, inputLeft, inputRight, null);
                float rotationSpeed = IBoatController.subtractToZero(boatRotSpeed, IBoatController.getVelocityResistance() * 2.5f);
                if (inputRight && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (inputLeft && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
                boat.f_38266_ = rotationSpeed;
                boat.m_146922_(boat.m_146908_() + boat.f_38266_);
                shipClassSetRotSpeed.invoke(ship, Float.valueOf(rotationSpeed));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    default public void setSmallShipsSailState(Boat boat, int state) {
        block6: {
            try {
                int coolDown;
                Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
                Field coolDownFlied = shipClass.getField("sailStateCooldown");
                if (coolDownFlied == null || (coolDown = coolDownFlied.getInt(boat)) != 0) break block6;
                try {
                    Object sailable;
                    Class<?> sailableClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Sailable");
                    if (sailableClass.isInstance(boat) && (sailable = sailableClass.cast(boat)) != null) {
                        Method sailableClassGetSailStateCooldown = sailableClass.getMethod("getSailStateCooldown", new Class[0]);
                        int configCoolDown = (Integer)sailableClassGetSailStateCooldown.invoke(sailable, new Object[0]);
                        Method sailableClassSetSailState = sailableClass.getMethod("setSailState", Byte.TYPE);
                        Method sailableClassGetSailState = sailableClass.getMethod("getSailState", new Class[0]);
                        byte currentSail = (Byte)sailableClassGetSailState.invoke(sailable, new Object[0]);
                        if (currentSail != (byte)state) {
                            sailableClassSetSailState.invoke(sailable, (byte)state);
                        }
                        coolDownFlied.setInt(boat, configCoolDown);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Main.LOGGER.info("SailableClass was not found");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
    }

    public static float getVelocityResistance() {
        return 0.007f;
    }

    public static float getSmallshipSpeed(Entity vehicle) {
        float speed = 0.0f;
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            try {
                Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
                if (shipClass.isInstance(boat)) {
                    Object ship = shipClass.cast(boat);
                    Method shipClassGetSpeed = shipClass.getMethod("getSpeed", new Class[0]);
                    speed = ((Float)shipClassGetSpeed.invoke(ship, new Object[0])).floatValue();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
        return speed;
    }

    public static void shootCannonsSmallShip(CaptainEntity driver, Boat boat, LivingEntity target, boolean leftSide) {
        double distanceToTarget = driver.m_20280_((Entity)target);
        double speed = 3.2f;
        double accuracy = 2.0;
        float rotation = leftSide ? 1.57f : -1.57f;
        Vec3 shootVec = boat.m_20156_().m_82524_(rotation).m_82541_();
        double heightDiff = target.m_20186_() - driver.m_20186_();
        double angle = IRangedRecruit.getCannonAngleDistanceModifier(distanceToTarget, 2) + IRangedRecruit.getCannonAngleHeightModifier(distanceToTarget, heightDiff) / 100.0;
        double yShootVec = shootVec.m_7098_() + angle;
        try {
            Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
            if (cannonAbleClass.isInstance(boat)) {
                Object cannonAble = cannonAbleClass.cast(boat);
                Method cannonAbleClassTriggerCannons = cannonAbleClass.getMethod("triggerCannons", Vec3.class, Double.TYPE, LivingEntity.class, Double.TYPE, Double.TYPE);
                cannonAbleClassTriggerCannons.invoke(cannonAble, shootVec, yShootVec, driver, speed, accuracy);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("Cannonable Class was not found");
        }
    }

    default public void updateVanillaBoatControl(Boat boat, double posX, double posZ, double speedFactor, double turnFactor) {
        double ref;
        Vec3 forward = boat.m_20156_().m_82524_(-90.0f).m_82541_();
        Vec3 target = new Vec3(posX, 0.0, posZ);
        Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
        double phi = IBoatController.horizontalAngleBetweenVectors(forward, toTarget);
        boolean inputLeft = phi < (ref = 63.5);
        boolean inputRight = phi > ref;
        boolean inputUp = Math.abs(phi - ref) <= ref * (double)0.15f;
        float f = 0.0f;
        if (inputLeft) {
            boat.m_146922_(boat.m_146908_() - 2.5f);
        }
        if (inputRight) {
            boat.m_146922_(boat.m_146908_() + 2.5f);
        }
        if (inputRight != inputLeft && !inputUp) {
            f = (float)((double)f + (double)0.005f * speedFactor);
        }
        if (inputUp) {
            f = (float)((double)f + (double)0.02f * speedFactor);
        }
        boat.m_20256_(boat.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-boat.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(boat.m_146908_() * ((float)Math.PI / 180))) * f)));
        boat.m_38339_(inputRight || inputUp, inputLeft || inputUp);
    }

    public static boolean hasCannons(Entity vehicle) {
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            try {
                Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
                if (cannonAbleClass.isInstance(boat)) {
                    Object cannonAble = cannonAbleClass.cast(boat);
                    Method cannonAbleClassGetCannons = cannonAbleClass.getMethod("getCannons", new Class[0]);
                    List list = (List)cannonAbleClassGetCannons.invoke(cannonAble, new Object[0]);
                    return list.size() > 0;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("Cannonable Class was not found");
            }
        }
        return false;
    }

    public static boolean canShootCannons(Entity vehicle) {
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            try {
                Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
                if (cannonAbleClass.isInstance(boat)) {
                    Object cannonAble = cannonAbleClass.cast(boat);
                    Method cannonAbleClassCanShootCannons = cannonAbleClass.getMethod("canShoot", new Class[0]);
                    return (Boolean)cannonAbleClassCanShootCannons.invoke(cannonAble, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("Cannonable Class was not found");
            }
        }
        return false;
    }

    public static void mountSmallShips(Boat boat) {
    }

    private void calculateSpeed(Boat boat, float speed, float acceleration, float setPoint) {
        speed = speed < setPoint ? this.addToSetPoint(speed, acceleration, setPoint) : IBoatController.subtractToZero(speed, IBoatController.getVelocityResistance() * 2.2f);
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassSetSpeed = shipClass.getMethod("setSpeed", Float.TYPE);
                shipClassSetSpeed.invoke(ship, Float.valueOf(speed));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    private float addToSetPoint(float current, float positiveChange, float setPoint) {
        if (current < setPoint) {
            current += positiveChange;
        }
        return current;
    }

    private double calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    private double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static float subtractToZero(float num, float sub) {
        float erg;
        if (num < 0.0f) {
            erg = num + sub;
            if (erg > 0.0f) {
                erg = 0.0f;
            }
        } else {
            erg = num - sub;
            if (erg < 0.0f) {
                erg = 0.0f;
            }
        }
        return erg;
    }

    public static double horizontalAngleBetweenVectors(Vec3 vector1, Vec3 vector2) {
        double dotProduct = vector1.f_82479_ * vector2.f_82479_ + vector1.f_82481_ * vector2.f_82481_;
        double magnitude1 = Math.sqrt(vector1.f_82479_ * vector1.f_82479_ + vector1.f_82481_ * vector1.f_82481_);
        double magnitude2 = Math.sqrt(vector2.f_82479_ * vector2.f_82479_ + vector2.f_82481_ * vector2.f_82481_);
        double cosTheta = dotProduct / (magnitude1 * magnitude2);
        return Math.toDegrees(Math.acos(cosTheta));
    }

    public static int getWaterDepth(BlockPos pos, LivingEntity cap) {
        BlockState state;
        int depth = 0;
        for (int i = 0; i < 10 && ((state = cap.m_20193_().m_8055_(pos.m_6625_(i))).m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50575_)); ++i) {
            ++depth;
        }
        return depth;
    }

    public static Vec3 getShootVector(Vec3 forward, CaptainEntity driver) {
        Vec3 toTarget;
        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
        LivingEntity target = driver.m_5448_();
        Vec3 vec3 = toTarget = target != null ? driver.m_20182_().m_82505_(target.m_20182_()).m_82541_() : driver.m_20154_().m_82541_();
        if (toTarget.m_82554_(VecLeft) > toTarget.m_82554_(VecRight)) {
            return VecRight;
        }
        if (toTarget.m_82554_(VecLeft) < toTarget.m_82554_(VecRight)) {
            return VecLeft;
        }
        return null;
    }
}

