/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.IBoatController;
import com.talhanation.recruits.entities.IStrategicFire;
import com.talhanation.recruits.entities.ai.CaptainControlBoatAI;
import com.talhanation.recruits.entities.ai.UseShield;
import com.talhanation.recruits.entities.ai.controller.CaptainAttackController;
import com.talhanation.recruits.entities.ai.navigation.SailorPathNavigation;
import com.talhanation.recruits.pathfinding.AsyncGroundPathNavigation;
import com.talhanation.recruits.util.RecruitCommanderUtil;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class CaptainEntity
extends AbstractLeaderEntity
implements IBoatController,
IStrategicFire {
    public boolean shipAttacking = false;
    private static final EntityDataAccessor<Optional<BlockPos>> SAIL_POS = SynchedEntityData.m_135353_(CaptainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> STRATEGIC_FIRE_POS = SynchedEntityData.m_135353_(CaptainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SHOULD_STRATEGIC_FIRE = SynchedEntityData.m_135353_(CaptainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());

    public CaptainEntity(EntityType<? extends AbstractLeaderEntity> entityType, Level world) {
        super(entityType, world);
        this.attackController = new CaptainAttackController(this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SAIL_POS, Optional.empty());
        this.f_19804_.m_135372_(STRATEGIC_FIRE_POS, Optional.empty());
        this.f_19804_.m_135372_(SHOULD_STRATEGIC_FIRE, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new CaptainControlBoatAI(this));
        this.f_21345_.m_25352_(2, (Goal)new UseShield(this));
    }

    @Override
    public double getDistanceToReachWaypoint() {
        return 150.0;
    }

    @Override
    @NotNull
    public PathNavigation m_21573_() {
        if (this.m_20202_() instanceof Boat) {
            return new SailorPathNavigation(this, this.m_20193_());
        }
        return super.m_21573_();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getSailPos() != null) {
            nbt.m_128405_("SailPosX", this.getSailPos().m_123341_());
            nbt.m_128405_("SailPosY", this.getSailPos().m_123342_());
            nbt.m_128405_("SailPosZ", this.getSailPos().m_123343_());
        }
        if (this.StrategicFirePos() != null) {
            nbt.m_128405_("StrategicFirePosX", this.StrategicFirePos().m_123341_());
            nbt.m_128405_("StrategicFirePosY", this.StrategicFirePos().m_123342_());
            nbt.m_128405_("StrategicFirePosZ", this.StrategicFirePos().m_123343_());
            nbt.m_128379_("ShouldStrategicFire", this.getShouldStrategicFire());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("SailPosX") && nbt.m_128441_("SailPosY") && nbt.m_128441_("SailPosZ")) {
            this.setSailPos(new BlockPos(nbt.m_128451_("SailPosX"), nbt.m_128451_("SailPosY"), nbt.m_128451_("SailPosZ")));
        }
        if (nbt.m_128441_("StrategicFirePosX") && nbt.m_128441_("StrategicFirePosY") && nbt.m_128441_("StrategicFirePosZ")) {
            this.setStrategicFirePos(new BlockPos(nbt.m_128451_("StrategicFirePosX"), nbt.m_128451_("StrategicFirePosY"), nbt.m_128451_("StrategicFirePosZ")));
            this.setShouldStrategicFire(nbt.m_128471_("ShouldStrategicFire"));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 128.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((AsyncGroundPathNavigation)this.m_21573_()).setCanOpenDoors(true);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.setDropEquipment();
        this.m_21530_();
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.m_41778_().contains("smallships")) {
            return true;
        }
        if (itemStack.m_41720_() instanceof SwordItem && this.m_21205_().m_41619_() || itemStack.m_41720_() instanceof ShieldItem && this.m_21206_().m_41619_()) {
            return !this.hasSameTypeOfItem(itemStack);
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CrossbowItem) && !(itemStack.m_41720_() instanceof BowItem);
    }

    @Override
    public AbstractRecruitEntity get() {
        return this;
    }

    @Override
    public BlockPos getSailPos() {
        return ((Optional)this.f_19804_.m_135370_(SAIL_POS)).orElse(null);
    }

    @Override
    public float getPrecisionMin() {
        int base = 50;
        if (this.m_20202_() != null && this.m_20202_().m_20078_().contains("smallships")) {
            base = 100;
        }
        return base;
    }

    @Override
    public float getPrecisionMax() {
        int base = 150;
        if (this.m_20202_() != null && this.m_20202_().m_20078_().contains("smallships")) {
            base = 200;
        }
        return base;
    }

    @Override
    public void setSailPos(BlockPos pos) {
        if (pos == null) {
            this.setSailPos(Optional.empty());
        } else {
            this.setSailPos(Optional.of(pos));
        }
    }

    public void setSailPos(Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(SAIL_POS, pos);
    }

    @Override
    public void setFollowState(int state) {
        super.setFollowState(state);
        this.calculateSailPos(state);
    }

    @Override
    protected void moveToCurrentWaypoint() {
        if (this.m_20202_() != null && this.m_20202_() instanceof Boat) {
            this.setSailPos(this.currentWaypoint);
        } else {
            super.moveToCurrentWaypoint();
        }
    }

    public void calculateSailPos(int state) {
        switch (state) {
            case 0: {
                if (this.getMovePos() == null) break;
                BlockPos pos = this.getMovePos();
                this.setSailPos(pos);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.getHoldPos() == null) break;
                Vec3 pos = this.getHoldPos();
                this.setSailPos(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                break;
            }
            case 5: {
                LivingEntity protect = this.getProtectingMob();
                if (protect == null) break;
                BlockPos pos = protect.m_20097_();
                this.setSailPos(pos);
            }
        }
    }

    public boolean canAttackWhilePatrolling(LivingEntity target) {
        if (this.enemyArmySpotted() || target != null && target.m_6084_()) {
            if (this.army != null && !this.army.getRanged().isEmpty()) {
                return true;
            }
            if (this.m_20202_() != null) {
                return IBoatController.hasCannons(this.m_20202_()) && IBoatController.canShootCannons(this.m_20202_());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleUpkeepState() {
        double speed;
        if (this.m_20202_() != null && this.waitForRecruitsUpkeepTime != 0 && (speed = (double)IBoatController.getSmallshipSpeed(this.m_20202_())) < 0.01) {
            this.m_8127_();
            RecruitCommanderUtil.setRecruitsDismount(this.army.getAllRecruitUnits());
        }
        if (this.waitForRecruitsUpkeepTime == 0) {
            this.shouldMount(true, this.getMountUUID());
            RecruitCommanderUtil.setRecruitsFollow(this.army.getAllRecruitUnits(), this.m_20148_());
            if (this.m_20202_() != null && this.m_20202_().m_20148_().equals(this.getMountUUID()) && this.isRecruitsInCommandOnBoard()) {
                this.waitForRecruitsUpkeepTime = this.getAgainResupplyTime();
                this.setPatrolState(AbstractLeaderEntity.State.PATROLLING);
            }
        }
    }

    private boolean isRecruitsInCommandOnBoard() {
        return this.army.getAllRecruitUnits().stream().allMatch(recruit -> recruit.m_20202_() != null && recruit.m_20202_().equals((Object)this.m_20202_()));
    }

    @Override
    public int getResupplyTime() {
        return 1000;
    }

    @Override
    public void setStrategicFirePos(BlockPos pos) {
        if (pos != null) {
            this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.of(pos));
        } else {
            this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.empty());
        }
    }

    public BlockPos StrategicFirePos() {
        return ((Optional)this.f_19804_.m_135370_(STRATEGIC_FIRE_POS)).orElse(null);
    }

    @Override
    public void setShouldStrategicFire(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_STRATEGIC_FIRE, (Object)bool);
    }

    public boolean getShouldStrategicFire() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_STRATEGIC_FIRE);
    }

    public boolean canRepair() {
        return this.getInventory().m_216874_(itemStack -> itemStack.m_150930_(Items.f_42749_)) && this.getInventory().m_216874_(itemStack -> itemStack.m_204117_(ItemTags.f_13168_));
    }

    public void refillCannonBalls() {
        Entity entity;
        if (this.getInventory().m_216874_(itemStack -> itemStack.m_41778_().contains("cannon_ball")) && (entity = this.m_20202_()) instanceof Container) {
            Container container = (Container)entity;
            block0: for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
                ItemStack stack = this.getInventory().m_8020_(i);
                if (!stack.m_41778_().contains("cannon_ball")) continue;
                ItemStack cannonball = stack.m_41777_();
                for (int k = 0; k < container.m_6643_(); ++k) {
                    if (!container.m_8020_(k).m_41619_()) continue;
                    container.m_6836_(k, cannonball);
                    stack.m_41774_(cannonball.m_41613_());
                    this.getInventory().m_6596_();
                    container.m_6596_();
                    continue block0;
                }
            }
        }
    }

    @Override
    public boolean isAtMission() {
        return this.state != AbstractLeaderEntity.State.IDLE && this.state != AbstractLeaderEntity.State.PAUSED && this.state != AbstractLeaderEntity.State.STOPPED;
    }
}

