/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.compat;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlunderbussWeapon
implements IWeapon {
    @Override
    @Nullable
    public Item getWeapon() {
        try {
            Class<?> itemClass = Class.forName("ewewukek.musketmod.Items");
            Object musketWeaponInstance = itemClass.newInstance();
            Field musketItemField = musketWeaponInstance.getClass().getField("BLUNDERBUSS");
            Object item = musketItemField.get("BLUNDERBUSS");
            return (Item)item;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            Main.LOGGER.error("Items of MusketMod was not found");
            return null;
        }
    }

    @Override
    public double getMoveSpeedAmp() {
        return 0.4;
    }

    @Override
    public int getAttackCooldown() {
        return 50;
    }

    @Override
    public int getWeaponLoadTime() {
        return 70;
    }

    @Override
    public float getProjectileSpeed() {
        return 2.0f;
    }

    @Override
    public boolean isLoaded(ItemStack itemStack) {
        try {
            Class<?> pistolItemClass = Class.forName("ewewukek.musketmod.PistolItem");
            Method pistolItemIsLoaded = pistolItemClass.getMethod("isLoaded", ItemStack.class);
            return (Boolean)pistolItemIsLoaded.invoke(pistolItemClass, itemStack);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("pistolItem was not found");
            return false;
        }
    }

    @Override
    public void setLoaded(ItemStack stack, boolean loaded) {
        try {
            Class<?> musketItemClass = Class.forName("ewewukek.musketmod.PistolItem");
            Method musketItemSetLoaded = musketItemClass.getMethod("setLoaded", ItemStack.class, Boolean.TYPE);
            musketItemSetLoaded.invoke(musketItemClass, stack, loaded);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("MusketItem was not found");
        }
    }

    @Override
    public AbstractHurtingProjectile getProjectile(LivingEntity shooter) {
        try {
            Class<?> bulletClass = Class.forName("ewewukek.musketmod.BulletEntity");
            Class[] constructorParamTypes = new Class[]{Level.class};
            Constructor<?> bulletConstructor = bulletClass.getConstructor(constructorParamTypes);
            Level level = shooter.m_20193_();
            Object bulletInstance = bulletConstructor.newInstance(level);
            if (bulletInstance instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile bullet = (AbstractHurtingProjectile)bulletInstance;
                bullet.m_5602_((Entity)shooter);
                bullet.m_6034_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - 0.1, shooter.m_20189_());
                return bullet;
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("MusketItem was not found");
            return null;
        }
    }

    @Override
    public AbstractArrow getProjectileArrow(LivingEntity shooter) {
        return null;
    }

    @Override
    @Nullable
    public AbstractHurtingProjectile shoot(LivingEntity shooter, AbstractHurtingProjectile projectile, double x, double y, double z) {
        if (!shooter.m_20193_().m_5776_()) {
            double d3 = Mth.m_14116_((float)((float)(x * x + z * z)));
            Vec3 vec3 = new Vec3(x, y + d3 * 0.065, z).m_82541_().m_82490_(10.0);
            try {
                Class<?> bulletClass = Class.forName("ewewukek.musketmod.BulletEntity");
                if (bulletClass.isInstance(projectile)) {
                    Object bullet = bulletClass.cast(projectile);
                    Field bulletDamageField = bullet.getClass().getField("damage");
                    bulletDamageField.setAccessible(true);
                    Method bulletClassSetInitialSpeedMethod = bullet.getClass().getMethod("setInitialSpeed", Float.TYPE);
                    bulletClassSetInitialSpeedMethod.invoke(bullet, Float.valueOf(5.0f));
                    bulletDamageField.setFloat(bullet, 10.0f);
                    projectile.m_20256_(vec3);
                    projectile.m_6686_(x, y + d3 * 0.065, z, 4.5f, 6.0f);
                }
            }
            catch (NoSuchFieldException e) {
                Main.LOGGER.error("bulletDamageField was not found (NoSuchFieldException)");
            }
            catch (ClassNotFoundException e) {
                Main.LOGGER.error("BulletEntity.class was not found (ClassNotFoundException)");
            }
            catch (InvocationTargetException e) {
                Main.LOGGER.error("bulletClassSetInitialSpeedMethod was not found (InvocationTargetException)");
            }
            catch (NoSuchMethodException e) {
                Main.LOGGER.error("bulletClassSetDeltaMovementMethod was not found (NoSuchMethodException)");
            }
            catch (IllegalAccessException e) {
                Main.LOGGER.error("BulletEntity.class was not found (IllegalAccessException)");
            }
            Vec3 forward = new Vec3(x, y, z).m_82541_();
            Vec3 origin = new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
            try {
                Class<?> musketModClass = Class.forName("ewewukek.musketmod.MusketMod");
                Method sendSmokeEffectMethod = musketModClass.getMethod("sendSmokeEffect", ServerLevel.class, Vec3.class, Vec3.class);
                sendSmokeEffectMethod.invoke(musketModClass, (ServerLevel)shooter.m_20193_(), origin, forward);
            }
            catch (ClassNotFoundException e) {
                Main.LOGGER.error("MusketMod.class was not found (ClassNotFoundException)");
            }
            catch (InvocationTargetException e) {
                Main.LOGGER.error("sendSmokeEffectMethod was not found (InvocationTargetException)");
            }
            catch (NoSuchMethodException e) {
                Main.LOGGER.error("sendSmokeEffectMethod was not found (NoSuchMethodException)");
            }
            catch (IllegalAccessException e) {
                Main.LOGGER.error("MusketMod.class was not found (IllegalAccessException)");
            }
            return projectile;
        }
        return null;
    }

    @Override
    public AbstractArrow shootArrow(LivingEntity shooter, AbstractArrow projectile, double x, double y, double z) {
        return null;
    }

    @Override
    public SoundEvent getShootSound() {
        try {
            Class<?> itemClass = Class.forName("ewewukek.musketmod.Sounds");
            Object musketWeaponInstance = itemClass.newInstance();
            Field musketItemField = musketWeaponInstance.getClass().getField("BLUNDERBUSS_FIRE");
            Object soundEvent = musketItemField.get("BLUNDERBUSS_FIRE");
            return (SoundEvent)soundEvent;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            Main.LOGGER.error("Sounds of MusketMod was not found");
            return null;
        }
    }

    @Override
    public SoundEvent getLoadSound() {
        try {
            Class<?> itemClass = Class.forName("ewewukek.musketmod.Sounds");
            Object musketWeaponInstance = itemClass.newInstance();
            Field musketItemField = musketWeaponInstance.getClass().getField("MUSKET_READY");
            Object soundEvent = musketItemField.get("MUSKET_READY");
            return (SoundEvent)soundEvent;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            Main.LOGGER.error("Sounds of MusketMod was not found");
            return null;
        }
    }

    @Override
    public boolean isGun() {
        return true;
    }

    @Override
    public boolean canMelee() {
        return false;
    }

    @Override
    public boolean isBow() {
        return false;
    }

    @Override
    public boolean isCrossBow() {
        return false;
    }

    @Override
    public void performRangedAttackIWeapon(AbstractRecruitEntity shooter, double x, double y, double z, float projectileSpeed) {
        for (int i = 0; i < 9; ++i) {
            AbstractHurtingProjectile projectileEntity = this.getProjectile((LivingEntity)shooter);
            double d0 = x - shooter.m_20185_();
            double d1 = y + 0.5 - projectileEntity.m_20186_();
            double d2 = z - shooter.m_20189_();
            this.shoot((LivingEntity)shooter, projectileEntity, d0, d1, d2);
            shooter.m_20193_().m_7967_((Entity)projectileEntity);
        }
        shooter.m_5496_(this.getShootSound(), 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.4f + 0.8f));
        shooter.damageMainHandItem();
    }
}

