/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.widgets;

import com.talhanation.recruits.client.gui.team.TeamEditScreen;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class ColorSelectionDropdownMatrix
extends AbstractWidget {
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)60, (int)60, (int)60);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    private final List<Color> options;
    private final Consumer<Color> onSelect;
    private final TeamEditScreen parent;
    private Color selectedOption;
    private boolean isOpen;
    private final int cellSize = 20;
    private final int colorSize = 16;
    private final int columns;
    private final int rows;
    private final String name;

    public ColorSelectionDropdownMatrix(TeamEditScreen parent, int x, int y, int width, int height, List<Color> options, Consumer<Color> onSelect) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.selectedOption = parent.getSelectedUnitColor();
        this.name = TeamEditScreen.unitColorsNames.get(parent.getSelectedUnitColorNameIndex()).getString();
        this.options = options;
        this.onSelect = onSelect;
        this.columns = 5;
        this.rows = 5;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int margin = 2;
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, BG_FILL_SELECTED);
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, this.name, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, 0xFFFFFF);
        int selectedColor = this.selectedOption.getRGB();
        guiGraphics.m_280024_(this.m_252754_() + margin, this.m_252907_() + margin, this.m_252754_() + margin + 16, this.m_252907_() + margin + 16, selectedColor, selectedColor);
        if (this.isOpen) {
            int dropdownStartX = this.m_252754_() + this.f_93618_;
            int dropdownStartY = this.m_252907_();
            for (int i = 0; i < this.options.size(); ++i) {
                int col = i % this.columns;
                int row = i / this.columns;
                int optionX = dropdownStartX + col * 20;
                int optionY = dropdownStartY + row * 20;
                Color Color2 = this.options.get(i);
                int optionColor = Color2.getRGB();
                if (this.isMouseOverOption(mouseX, mouseY, optionX, optionY)) {
                    guiGraphics.m_280509_(optionX, optionY, optionX + 20, optionY + 20, BG_FILL_HOVERED);
                } else {
                    guiGraphics.m_280509_(optionX, optionY, optionX + 20, optionY + 20, BG_FILL);
                }
                guiGraphics.m_280024_(optionX + margin, optionY + margin, optionX + margin + 16, optionY + margin + 16, optionColor, optionColor);
            }
        }
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void onMouseClicked(double mouseX, double mouseY) {
        if (this.isOpen) {
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY;
                int col = i % this.columns;
                int row = i / this.columns;
                int optionX = this.m_252754_() + this.f_93618_ + col * 20;
                if (!this.isMouseOverOption((int)mouseX, (int)mouseY, optionX, optionY = this.m_252907_() + row * 20)) continue;
                this.selectOption(this.options.get(i));
                this.isOpen = false;
                return;
            }
        }
        this.isOpen = this.isMouseOverDisplay((int)mouseX, (int)mouseY) ? !this.isOpen : false;
    }

    public void onMouseMove(double mouseX, double mouseY) {
        if (this.isOpen) {
            boolean isOverDropdown = this.isMouseOverDropdown((int)mouseX, (int)mouseY);
            boolean isOverDisplay = this.isMouseOverDisplay((int)mouseX, (int)mouseY);
            if (!isOverDropdown && !isOverDisplay) {
                this.isOpen = false;
            }
        }
    }

    private boolean isMouseOverDisplay(int mouseX, int mouseY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_;
    }

    private boolean isMouseOverDropdown(int mouseX, int mouseY) {
        if (!this.isOpen) {
            return false;
        }
        int dropdownStartX = this.m_252754_() + this.f_93618_;
        int dropdownStartY = this.m_252907_();
        int dropdownEndX = dropdownStartX + this.columns * 20;
        int dropdownEndY = dropdownStartY + this.rows * 20;
        return mouseX >= dropdownStartX && mouseX <= dropdownEndX && mouseY >= dropdownStartY && mouseY <= dropdownEndY;
    }

    private boolean isMouseOverOption(int mouseX, int mouseY, int optionX, int optionY) {
        return mouseX >= optionX && mouseX <= optionX + 20 && mouseY >= optionY && mouseY <= optionY + 20;
    }

    private void selectOption(Color option) {
        this.selectedOption = option;
        this.onSelect.accept(option);
        this.isOpen = false;
    }
}

