/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.player.IPlayerSelection;
import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.player.RecruitsPlayerEntry;
import com.talhanation.recruits.client.gui.widgets.ListScreenBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.network.MessageToServerRequestUpdatePlayerList;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class SelectPlayerScreen
extends ListScreenBase
implements IPlayerSelection {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/select_player.png");
    public static final Component TITLE = Component.m_237115_((String)"gui.recruits.select_player_screen.title");
    public static final Component BUTTON_SELECT = Component.m_237115_((String)"gui.recruits.select_player_screen.selectPlayer");
    public static final Component BUTTON_SELECT_TOOLTIP = Component.m_237115_((String)"gui.recruits.select_player_screen.selectPlayerTooltip");
    protected static final Component BUTTON_BACK = Component.m_237115_((String)"gui.recruits.button.back");
    protected static Component BUTTON_TEXT;
    protected static Component TOOLTIP_BUTTON;
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    public PlayersList playerList;
    protected EditBox searchBox;
    protected String lastSearch;
    protected int units;
    protected Screen parent;
    public RecruitsPlayerInfo selected;
    private Button backButton;
    private Button actionButton;
    private final Consumer<RecruitsPlayerInfo> buttonAction;
    private final Player player;
    private final boolean includeSelf;
    private final PlayersList.FilterType filterType;
    private int gapTop;
    private int gapBottom;
    private int refreshTime = 20;

    public SelectPlayerScreen(Screen parent, Player player, Component title, Component buttonText, Component buttonTooltip, boolean includeSelf, PlayersList.FilterType filterType, Consumer<RecruitsPlayerInfo> buttonAction) {
        super(title, 236, 0);
        this.parent = parent;
        this.buttonAction = buttonAction;
        this.player = player;
        this.includeSelf = includeSelf;
        this.filterType = filterType;
        BUTTON_TEXT = buttonText;
        TOOLTIP_BUTTON = buttonTooltip;
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageToServerRequestUpdatePlayerList());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.gapTop = (int)((double)this.f_96544_ * 0.1);
        this.gapBottom = (int)((double)this.f_96544_ * 0.1);
        this.guiLeft += 2;
        this.guiTop = this.gapTop;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.gapTop - this.gapBottom - 16) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.playerList != null) {
            this.playerList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.playerList = new PlayersList(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18, 36, this, this.filterType, this.player, this.includeSelf);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 8, this.guiTop + 16, 220, 16, (Component)Component.m_237113_((String)"SEARCH_HINT"));
        this.searchBox.m_94199_(16);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.playerList);
        this.m_264313_((GuiEventListener)this.searchBox);
        int buttonY = this.guiTop + 16 + 5 + this.units * 18;
        this.backButton = new ExtendedButton(this.guiLeft + 129, buttonY, 100, 20, BUTTON_BACK, button -> this.f_96541_.m_91152_(this.parent));
        this.actionButton = new ExtendedButton(this.guiLeft + 7, buttonY, 100, 20, BUTTON_TEXT, button -> {
            this.buttonAction.accept(this.selected);
            PlayersList.onlinePlayers.remove(this.selected);
            this.playerList.recruitsTeam.removeJoinRequest(this.selected.getName());
            this.playerList.m_7522_(null);
            this.playerList.updateEntryList();
            this.selected = null;
            this.m_7856_();
        });
        this.actionButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.backButton);
        this.m_142416_((GuiEventListener)this.actionButton);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.playerList != null) {
            this.playerList.tick();
        }
        if (--this.refreshTime <= 0) {
            this.refreshTime = 20;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageToServerRequestUpdatePlayerList());
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        boolean flag = super.m_7933_(p_96552_, p_96553_, p_96554_);
        this.selected = null;
        this.playerList.m_7522_(null);
        this.actionButton.f_93623_ = false;
        return flag;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.playerList.isEmpty()) {
            this.playerList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, "EMPTY_SEARCH", n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280488_(this.f_96547_, "", this.searchBox.m_252754_(), this.searchBox.m_252907_(), -1);
        }
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.playerList.setFilter(string);
            this.lastSearch = string;
        }
    }

    public boolean m_6375_(double x, double y, int z) {
        if (this.playerList != null) {
            this.playerList.m_6375_(x, y, z);
        }
        boolean flag = super.m_6375_(x, y, z);
        if (this.playerList.m_7222_() != null) {
            this.selected = ((RecruitsPlayerEntry)this.playerList.m_7222_()).getPlayerInfo();
            this.actionButton.f_93623_ = true;
        }
        return flag;
    }

    public Component m_96636_() {
        return this.f_96539_;
    }

    @Override
    public RecruitsPlayerInfo getSelected() {
        return this.selected;
    }

    @Override
    public ListScreenListBase<RecruitsPlayerEntry> getPlayerList() {
        return this.playerList;
    }
}

