/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.google.common.collect.Lists;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.group.RecruitsGroupEntry;
import com.talhanation.recruits.client.gui.group.RecruitsGroupListScreen;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.network.MessageServerSavePlayerGroups;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RecruitsGroupList
extends ListScreenListBase<RecruitsGroupEntry> {
    protected RecruitsGroupListScreen screen;
    protected final List<RecruitsGroupEntry> entries;
    protected String filter;
    public static List<RecruitsGroup> groups;
    public static boolean hasUpdated;

    public RecruitsGroupList(int width, int height, int x, int y, int size, RecruitsGroupListScreen screen) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
        hasUpdated = false;
    }

    public void tick() {
        if (!hasUpdated && groups != null) {
            this.updateEntryList();
            hasUpdated = true;
        }
    }

    public void updateEntryList() {
        this.entries.clear();
        for (RecruitsGroup group : groups) {
            this.entries.add(new RecruitsGroupEntry(this.screen, group));
        }
        this.updateFilter();
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<RecruitsGroupEntry> filteredEntries = new ArrayList<RecruitsGroupEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(teamEntry -> teamEntry.getGroup() == null || !teamEntry.getGroup().getName().toLowerCase(Locale.ROOT).contains(this.filter.toLowerCase(Locale.ROOT)));
        }
        filteredEntries.sort((e1, e2) -> {
            if (e1.getGroup() == null || e2.getGroup() == null) {
                return 0;
            }
            return Integer.compare(e1.getGroup().getId(), e2.getGroup().getId());
        });
        this.m_5988_(filteredEntries);
    }

    private String volumeEntryToString(RecruitsGroupEntry entry) {
        return entry.getGroup().getName() == null ? "" : entry.getGroup().getName();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }

    public static void saveGroups(boolean update) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageServerSavePlayerGroups(groups, update));
        hasUpdated = false;
    }
}

