/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.DebugInvMenu;
import com.talhanation.recruits.network.MessageDebugGui;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.ForgeMod;

@OnlyIn(value=Dist.CLIENT)
public class DebugInvScreen
extends ScreenBase<DebugInvMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/debug_gui.png");
    private static final int fontColor = 0x404040;
    private EditBox textField;
    private final AbstractRecruitEntity recruit;
    private final Player player;
    private final Inventory playerInventory;
    private int follow;
    private int aggro;

    public DebugInvScreen(DebugInvMenu commandContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, commandContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 201;
        this.f_97727_ = 250;
        this.recruit = commandContainer.getRecruit();
        this.player = playerInventory.f_35978_;
        this.playerInventory = playerInventory;
    }

    protected void m_7856_() {
        super.m_7856_();
        int zeroLeftPos = this.f_97735_ + 100;
        int zeroTopPos = this.f_97736_ + 10;
        this.xpButton(zeroLeftPos, zeroTopPos);
        this.lvlButton(zeroLeftPos, zeroTopPos);
        this.costButton(zeroLeftPos, zeroTopPos);
        this.hungerButton(zeroLeftPos, zeroTopPos);
        this.moralButton(zeroLeftPos, zeroTopPos);
        this.healthButton(zeroLeftPos, zeroTopPos);
        this.variantButton(zeroLeftPos, zeroTopPos);
        this.biomeButton(zeroLeftPos, zeroTopPos);
        this.killHealButton(zeroLeftPos, zeroTopPos);
        this.clearButton(zeroLeftPos, zeroTopPos);
        this.clearButton2(zeroLeftPos, zeroTopPos);
        this.promoteButton(zeroLeftPos, zeroTopPos);
        this.clearTeam(zeroLeftPos, zeroTopPos);
        this.teamColorButton(zeroLeftPos, zeroTopPos);
        this.disband(zeroLeftPos, zeroTopPos);
        MutableComponent name = Component.m_237113_((String)"Name");
        if (this.recruit.m_7770_() != null) {
            name = this.recruit.m_7770_();
        }
        this.textField = new EditBox(this.f_96547_, this.f_97735_ + 18, this.f_97736_ - 23, 140, 20, (Component)name);
        this.textField.m_94144_(name.getString());
        this.textField.m_94202_(-1);
        this.textField.m_94205_(-1);
        this.textField.m_94182_(true);
        this.textField.m_94199_(24);
        this.m_142416_((GuiEventListener)this.textField);
        this.m_264313_((GuiEventListener)this.textField);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.textField != null) {
            this.textField.m_94120_();
        }
    }

    public boolean m_6375_(double p_100753_, double p_100754_, int p_100755_) {
        if (this.textField.m_93696_()) {
            this.textField.m_6375_(p_100753_, p_100754_, p_100755_);
        }
        return super.m_6375_(p_100753_, p_100754_, p_100755_);
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 256) {
            this.m_7379_();
            return true;
        }
        this.m_7522_((GuiEventListener)this.textField);
        return this.textField.m_7933_(key, a, b) || this.textField.m_94204_() || super.m_7933_(key, a, b);
    }

    public void m_7379_() {
        super.m_7379_();
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(99, this.recruit.m_20148_(), this.textField.m_94155_()));
    }

    private void xpButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 0, 40, 20, (Component)Component.m_237113_((String)"+xp"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(0, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 0, 40, 20, (Component)Component.m_237113_((String)"+10xp"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(21, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void lvlButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 25, 40, 20, (Component)Component.m_237113_((String)"+lvl"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(1, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 25, 40, 20, (Component)Component.m_237113_((String)"+5lvl"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(22, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void costButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 50, 40, 20, (Component)Component.m_237113_((String)"+cost"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(2, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 50, 40, 20, (Component)Component.m_237113_((String)"-cost"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(3, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void hungerButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 75, 40, 20, (Component)Component.m_237113_((String)"+hunger"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(4, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 75, 40, 20, (Component)Component.m_237113_((String)"-hunger"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(5, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void moralButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 100, 40, 20, (Component)Component.m_237113_((String)"+morale"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(6, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 100, 40, 20, (Component)Component.m_237113_((String)"-morale"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(7, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void healthButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 125, 40, 20, (Component)Component.m_237113_((String)"+health"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(8, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 125, 40, 20, (Component)Component.m_237113_((String)"-health"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(9, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void variantButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 150, 40, 20, (Component)Component.m_237113_((String)"+variant"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(10, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 150, 40, 20, (Component)Component.m_237113_((String)"-variant"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(11, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void biomeButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 175, 40, 20, (Component)Component.m_237113_((String)"+biome"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(12, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 175, 40, 20, (Component)Component.m_237113_((String)"-biome"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(13, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void teamColorButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 210, zeroTopPos + 200, 40, 20, (Component)Component.m_237113_((String)"+tcolor"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(24, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 160, zeroTopPos + 200, 40, 20, (Component)Component.m_237113_((String)"-tcolor"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(25, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void killHealButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 130, zeroTopPos + 50, 40, 20, (Component)Component.m_237113_((String)"heal"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(14, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 50, 40, 20, (Component)Component.m_237113_((String)"-kill"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(15, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void clearButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 130, zeroTopPos + 75, 40, 20, (Component)Component.m_237113_((String)"c upkeep"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(16, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 75, 40, 20, (Component)Component.m_237113_((String)"c hold"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(17, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void clearButton2(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 130, zeroTopPos + 100, 40, 20, (Component)Component.m_237113_((String)"c prot"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(18, this.recruit.m_20148_(), this.textField.m_94155_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 100, 40, 20, (Component)Component.m_237113_((String)"c mount"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(19, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void promoteButton(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 125, 40, 20, (Component)Component.m_237113_((String)"pro"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(20, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void clearTeam(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 150, 40, 20, (Component)Component.m_237113_((String)"c team"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(23, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    private void disband(int zeroLeftPos, int zeroTopPos) {
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos + 80, zeroTopPos + 175, 40, 20, (Component)Component.m_237113_((String)"c owner"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(26, this.recruit.m_20148_(), this.textField.m_94155_()))));
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int health = Mth.m_14167_((float)this.recruit.m_21223_());
        int maxHealth = Mth.m_14167_((float)this.recruit.m_21233_());
        int moral = Mth.m_14167_((float)this.recruit.getMorale());
        double attackReach = this.recruit.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        double attackSpeed = this.recruit.m_21133_(Attributes.f_22283_);
        double attackDamage = this.recruit.getAttackDamage();
        DecimalFormat decimalformat = new DecimalFormat("##.#");
        double armor = this.recruit.m_21230_();
        int costs = this.recruit.getCost();
        double hunger = this.recruit.getHunger();
        int group = this.recruit.getGroup();
        String team = this.recruit.m_5647_() != null ? this.recruit.m_5647_().m_5758_() : "null";
        int k = 30;
        int l = 15;
        String follow = switch (this.recruit.getFollowState()) {
            case 0 -> "wander";
            case 1 -> "follow";
            case 2 -> "hold my pos";
            case 3 -> "back to pos";
            case 4 -> "hold your pos";
            case 5 -> "protect";
            default -> "{}";
        };
        String aggro = switch (this.recruit.getState()) {
            case 0 -> "neutral";
            case 1 -> "aggro";
            case 2 -> "raid";
            case 3 -> "passive";
            default -> "{}";
        };
        String biome = switch (this.recruit.getBiome()) {
            case 0 -> "desert";
            case 1 -> "jungle";
            case 2 -> "plains";
            case 3 -> "savanna";
            case 4 -> "snowy";
            case 5 -> "swamp";
            case 6 -> "taiga";
            default -> "{}";
        };
        String tcolor = switch (this.recruit.getColor()) {
            case 0 -> "white";
            case 1 -> "black";
            case 2 -> "light_gray";
            case 3 -> "gray";
            case 4 -> "dark_gray";
            case 5 -> "light_blue";
            case 6 -> "blue";
            case 7 -> "dark_blue";
            case 8 -> "light_green";
            case 9 -> "green";
            case 10 -> "dark_green";
            case 11 -> "light_red";
            case 12 -> "red";
            case 13 -> "dark_red";
            case 14 -> "light_brown";
            case 15 -> "brown";
            case 16 -> "dark_brown";
            case 17 -> "light_cyan";
            case 18 -> "cyan";
            case 19 -> "dark_cyan";
            case 20 -> "yellow";
            case 21 -> "orange";
            case 22 -> "magenta";
            case 23 -> "purple";
            case 24 -> "gold";
            default -> "{}";
        };
        guiGraphics.m_280168_();
        guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        guiGraphics.m_280649_(this.f_96547_, this.recruit.m_5446_().m_7532_(), 8, 5, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Hp:", k, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, health + "/" + maxHealth, k + 25, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Lvl:", k, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXpLevel(), k + 25, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Exp:", k, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXp(), k + 25, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Kills:", k, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getKills(), k + 25, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Morale:", k, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + moral, k + 40, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Hunger:", k, l + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, decimalformat.format(hunger), k + 40, l + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Upkeep Pos:", k, l + 60, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getUpkeepPos(), k + 43 + 20, l + 60, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "MaxHp:", k + 43 + 20, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + maxHealth, k + 77 + 20, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Armor:", k + 43 + 20, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + armor, k + 77 + 20, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Cost:", k + 43 + 20, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + costs, k + 77 + 20, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Team:", k, l + 70, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, team, k + 40, l + 70, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "A Dmg:", k + 43 + 80, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, decimalformat.format(attackDamage), k + 90 + 80, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "A reach:", k + 43 + 80, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, decimalformat.format(attackReach), k + 90 + 80, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "A speed:", k + 43 + 80, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, decimalformat.format(attackSpeed), k + 90 + 80, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Armor:", k + 43 + 80, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + armor, k + 90 + 80, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Cost:", k + 43 + 80, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + costs, k + 90 + 80, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Group:", k + 43 + 80, l + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + group, k + 90 + 80, l + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Follow:", k + 43 + 80, l + 60, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, follow, k + 90 + 80, l + 60, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Aggro:", k + 43 + 80, l + 70, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, aggro, k + 90 + 80, l + 70, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Variant:", k + 43 + 80, l + 80, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getVariant(), k + 90 + 80, l + 80, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Biome:", k + 43 + 80, l + 90, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, biome, k + 90 + 80, l + 90, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "tColor:", k + 43 + 80, l + 100, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, tcolor, k + 90 + 80, l + 100, 0x404040, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private int calculateADamage() {
        BowItem bow;
        Item item;
        int damage = Math.round(this.recruit.getAttackDamage());
        Main.LOGGER.debug("damage: " + damage);
        ItemStack handItem = this.recruit.m_21120_(InteractionHand.MAIN_HAND);
        if (handItem.m_41720_() instanceof SwordItem || handItem.m_41720_() instanceof AxeItem) {
            Main.LOGGER.debug("Sword damage: " + handItem.m_41773_());
            Main.LOGGER.debug("Sword damage: " + (damage += handItem.m_41773_()));
        }
        if ((item = handItem.m_41720_()) instanceof BowItem) {
            bow = (BowItem)item;
            Main.LOGGER.debug("Bow damage: " + (damage += 8));
        }
        if ((item = handItem.m_41720_()) instanceof CrossbowItem) {
            bow = (CrossbowItem)item;
            Main.LOGGER.debug("Cross damage: " + (damage += 11));
        }
        return damage;
    }
}

