/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.events.ClientEvent;
import com.talhanation.recruits.client.gui.group.RecruitsCategoryButton;
import com.talhanation.recruits.client.gui.group.RecruitsCommandButton;
import com.talhanation.recruits.client.gui.group.RecruitsFormationButton;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.group.RecruitsGroupButton;
import com.talhanation.recruits.client.gui.group.RecruitsGroupListScreen;
import com.talhanation.recruits.client.gui.team.TeamMainScreen;
import com.talhanation.recruits.config.RecruitsClientConfig;
import com.talhanation.recruits.inventory.CommandMenu;
import com.talhanation.recruits.network.MessageAggro;
import com.talhanation.recruits.network.MessageBackToMountEntity;
import com.talhanation.recruits.network.MessageClearTarget;
import com.talhanation.recruits.network.MessageClearUpkeep;
import com.talhanation.recruits.network.MessageDismount;
import com.talhanation.recruits.network.MessageMountEntity;
import com.talhanation.recruits.network.MessageMovement;
import com.talhanation.recruits.network.MessageProtectEntity;
import com.talhanation.recruits.network.MessageRangedFire;
import com.talhanation.recruits.network.MessageRest;
import com.talhanation.recruits.network.MessageSaveFormationFollowMovement;
import com.talhanation.recruits.network.MessageServerSavePlayerGroups;
import com.talhanation.recruits.network.MessageShields;
import com.talhanation.recruits.network.MessageStrategicFire;
import com.talhanation.recruits.network.MessageUpkeepEntity;
import com.talhanation.recruits.network.MessageUpkeepPos;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CommandScreen
extends ScreenBase<CommandMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/command_gui.png");
    private static final MutableComponent TOOLTIP_STRATEGIC_FIRE = Component.m_237115_((String)"gui.recruits.command.tooltip.strategic_fire");
    private static final MutableComponent TOOLTIP_HOLD_STRATEGIC_FIRE = Component.m_237115_((String)"gui.recruits.command.tooltip.hold_strategic_fire");
    private static final MutableComponent TOOLTIP_DISMOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.dismount");
    private static final MutableComponent TOOLTIP_MOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.mount");
    private static final MutableComponent TOOLTIP_SHIELDS_UP = Component.m_237115_((String)"gui.recruits.command.tooltip.shields_up");
    private static final MutableComponent TOOLTIP_SHIELDS_DOWN = Component.m_237115_((String)"gui.recruits.command.tooltip.shields_down");
    private static final MutableComponent TOOLTIP_PROTECT = Component.m_237115_((String)"gui.recruits.command.tooltip.protect");
    private static final MutableComponent TOOLTIP_MOVE = Component.m_237115_((String)"gui.recruits.command.tooltip.move_hold");
    private static final MutableComponent TOOLTIP_FORWARD = Component.m_237115_((String)"gui.recruits.command.tooltip.forward");
    private static final MutableComponent TOOLTIP_FORMATION = Component.m_237115_((String)"gui.recruits.command.tooltip.formation");
    private static final MutableComponent TOOLTIP_BACKWARD = Component.m_237115_((String)"gui.recruits.command.tooltip.backward");
    private static final MutableComponent TOOLTIP_FOLLOW = Component.m_237115_((String)"gui.recruits.command.tooltip.follow");
    private static final MutableComponent TOOLTIP_WANDER = Component.m_237115_((String)"gui.recruits.command.tooltip.wander");
    private static final MutableComponent TOOLTIP_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.holdMyPos");
    private static final MutableComponent TOOLTIP_HOLD_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.holdPos");
    private static final MutableComponent TOOLTIP_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.backToPos");
    private static final MutableComponent TOOLTIP_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.backToMount");
    private static final MutableComponent TOOLTIP_PASSIVE = Component.m_237115_((String)"gui.recruits.command.tooltip.passive");
    private static final MutableComponent TOOLTIP_NEUTRAL = Component.m_237115_((String)"gui.recruits.command.tooltip.neutral");
    private static final MutableComponent TOOLTIP_AGGRESSIVE = Component.m_237115_((String)"gui.recruits.command.tooltip.aggressive");
    private static final MutableComponent TOOLTIP_RAID = Component.m_237115_((String)"gui.recruits.command.tooltip.raid");
    private static final MutableComponent TOOLTIP_UPKEEP = Component.m_237115_((String)"gui.recruits.command.tooltip.upkeep");
    private static final MutableComponent TOOLTIP_REST = Component.m_237115_((String)"gui.recruits.command.tooltip.rest");
    private static final MutableComponent TOOLTIP_TEAM = Component.m_237115_((String)"gui.recruits.command.tooltip.team");
    private static final MutableComponent TOOLTIP_CLEAR_TARGET = Component.m_237115_((String)"gui.recruits.command.tooltip.clearTargets");
    private static final MutableComponent TOOLTIP_HOLD_FIRE = Component.m_237115_((String)"gui.recruits.command.tooltip.hold_fire");
    private static final MutableComponent TOOLTIP_FIRE_AT_WILL = Component.m_237115_((String)"gui.recruits.command.tooltip.fire_at_will");
    private static final MutableComponent TOOLTIP_MOVEMENT = Component.m_237115_((String)"gui.recruits.command.tooltip.movement");
    private static final MutableComponent TOOLTIP_COMBAT = Component.m_237115_((String)"gui.recruits.command.tooltip.combat");
    private static final MutableComponent TOOLTIP_OTHER = Component.m_237115_((String)"gui.recruits.command.tooltip.other");
    private static final MutableComponent TEXT_EVERYONE = Component.m_237115_((String)"gui.recruits.command.text.everyone");
    private static final MutableComponent TEXT_PROTECT = Component.m_237115_((String)"gui.recruits.command.text.protect");
    private static final MutableComponent TEXT_MOVE = Component.m_237115_((String)"gui.recruits.command.text.move");
    private static final MutableComponent TEXT_MOVE_HOLD = Component.m_237115_((String)"gui.recruits.command.text.move_hold");
    private static final MutableComponent TEXT_FORWARD = Component.m_237115_((String)"gui.recruits.command.text.forward");
    private static final MutableComponent TEXT_BACKWARD = Component.m_237115_((String)"gui.recruits.command.text.backward");
    private static final MutableComponent TEXT_SHIELDS_UP = Component.m_237115_((String)"gui.recruits.command.text.shields_up");
    private static final MutableComponent TEXT_SHIELDS_DOWN = Component.m_237115_((String)"gui.recruits.command.text.shields_down");
    private static final MutableComponent TEXT_DISMOUNT = Component.m_237115_((String)"gui.recruits.command.text.dismount");
    private static final MutableComponent TEXT_MOUNT = Component.m_237115_((String)"gui.recruits.command.text.mount");
    private static final MutableComponent TEXT_FOLLOW = Component.m_237115_((String)"gui.recruits.command.text.follow");
    private static final MutableComponent TEXT_WANDER = Component.m_237115_((String)"gui.recruits.command.text.wander");
    private static final MutableComponent TEXT_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.command.text.holdMyPos");
    private static final MutableComponent TEXT_HOLD_POS = Component.m_237115_((String)"gui.recruits.command.text.holdPos");
    private static final MutableComponent TEXT_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.command.text.backToPos");
    private static final MutableComponent TEXT_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.command.text.backToMount");
    private static final MutableComponent TEXT_PASSIVE = Component.m_237115_((String)"gui.recruits.command.text.passive");
    private static final MutableComponent TEXT_NEUTRAL = Component.m_237115_((String)"gui.recruits.command.text.neutral");
    private static final MutableComponent TEXT_AGGRESSIVE = Component.m_237115_((String)"gui.recruits.command.text.aggressive");
    private static final MutableComponent TEXT_RAID = Component.m_237115_((String)"gui.recruits.command.text.raid");
    private static final MutableComponent TEXT_STRATEGIC_FIRE = Component.m_237115_((String)"gui.recruits.command.text.strategic_fire");
    private static final MutableComponent TEXT_HOLD_STRATEGIC_FIRE = Component.m_237115_((String)"gui.recruits.command.text.hold_strategic_fire");
    private static final MutableComponent TEXT_FIRE_AT_WILL = Component.m_237115_((String)"gui.recruits.command.text.fire_at_will");
    private static final MutableComponent TEXT_HOLD_FIRE = Component.m_237115_((String)"gui.recruits.command.text.hold_fire");
    private static final MutableComponent TEXT_CLEAR_TARGET = Component.m_237115_((String)"gui.recruits.command.text.clearTargets");
    private static final MutableComponent TEXT_UPKEEP = Component.m_237115_((String)"gui.recruits.command.text.upkeep");
    private static final MutableComponent TEXT_REST = Component.m_237115_((String)"gui.recruits.command.text.rest");
    private static final MutableComponent TEXT_TEAM = Component.m_237115_((String)"gui.recruits.command.text.team");
    private static final MutableComponent TEXT_FORMATION_NONE = Component.m_237115_((String)"gui.recruits.command.text.formation_none");
    private static final MutableComponent TEXT_FORMATION_LINEUP = Component.m_237115_((String)"gui.recruits.command.text.formation_lineup");
    private static final MutableComponent TEXT_FORMATION_SQUARE = Component.m_237115_((String)"gui.recruits.command.text.formation_square");
    private static final MutableComponent TEXT_FORMATION_TRIANGLE = Component.m_237115_((String)"gui.recruits.command.text.formation_triangle");
    private static final MutableComponent TEXT_FORMATION_HOLLOW_SQUARE = Component.m_237115_((String)"gui.recruits.command.text.formation_hollow_square");
    private static final MutableComponent TEXT_FORMATION_HOLLOW_CIRCLE = Component.m_237115_((String)"gui.recruits.command.text.formation_hollow_circle");
    private static final MutableComponent TEXT_FORMATION_V = Component.m_237115_((String)"gui.recruits.command.text.formation_v");
    private static final MutableComponent TEXT_FORMATION_CIRCLE = Component.m_237115_((String)"gui.recruits.command.text.formation_circle");
    private static final MutableComponent TEXT_FORMATION_MOVEMENT = Component.m_237115_((String)"gui.recruits.command.text.formation_movement");
    private static final MutableComponent TOOLTIP_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.command.tooltip.clear_upkeep");
    private static final MutableComponent TEXT_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.command.text.clear_upkeep");
    private static final int fontColor = 0xF7F7F7;
    private final Player player;
    private BlockPos rayBlockPos;
    private Entity rayEntity;
    private Selection selection;
    public static List<RecruitsGroup> groups;
    public static Formation formation;
    public boolean mouseGroupsInverted;
    private List<RecruitsGroupButton> groupButtons;
    private boolean buttonsSet = false;
    boolean statusSet = false;

    public CommandScreen(CommandMenu commandContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, commandContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.player = playerInventory.f_35978_;
    }

    public boolean m_7920_(int x, int y, int z) {
        super.m_7920_(x, y, z);
        if (!((Boolean)RecruitsClientConfig.CommandScreenToggle.get()).booleanValue()) {
            this.m_7379_();
        }
        return true;
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveGroups();
        groups = new ArrayList<RecruitsGroup>();
        this.groupButtons = new ArrayList<RecruitsGroupButton>();
        this.saveSelectionOnClient();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rayBlockPos = this.getBlockPos();
        this.rayEntity = ClientEvent.getEntityByLooking();
        this.selection = this.getSelectionFromClient();
        formation = this.getSavedFormationFromClient();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.buttonsSet) {
            this.setButtons();
            this.saveGroups();
            this.buttonsSet = true;
        }
    }

    private void saveGroups() {
        if (groups != null && !groups.isEmpty()) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageServerSavePlayerGroups(groups, true));
        }
    }

    private void setButtons() {
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        formation = this.getSavedFormationFromClient();
        this.m_169413_();
        this.groupButtons = new ArrayList<RecruitsGroupButton>();
        int index = 0;
        if (groups != null && !groups.isEmpty()) {
            for (RecruitsGroup group : groups) {
                if (index >= 9) continue;
                this.createRecruitsGroupButton(group, index, x, y);
                ++index;
            }
        }
        this.createManageGroupsButton(index, x, y);
        this.createCommandButtons(this.selection, x, y);
        if (!this.statusSet) {
            this.mouseGroupsInverted = this.getInvertedStatus();
            this.statusSet = true;
        }
    }

    private void createRecruitsGroupButton(RecruitsGroup group, int index, int x, int y) {
        RecruitsGroupButton groupButton = new RecruitsGroupButton(group, x - 200 + 45 * index, y - 120, 40, 40, (Component)Component.m_237113_((String)group.getName()), button -> {
            group.setDisabled(!group.isDisabled());
            this.setButtons();
        });
        this.m_142416_((GuiEventListener)groupButton);
        groupButton.f_93623_ = !group.isDisabled();
        this.groupButtons.add(groupButton);
    }

    private void createManageGroupsButton(int index, int x, int y) {
        int posX = x - 200 + 45 * index;
        int posY = y - 100;
        if (index > 8) {
            posX = x + 180;
            posY = y - 70;
        }
        ExtendedButton groupButton = new ExtendedButton(posX, posY, 20, 20, (Component)Component.m_237113_((String)"+/-"), button -> this.f_96541_.m_91152_((Screen)new RecruitsGroupListScreen(this.player)));
        this.m_142416_((GuiEventListener)groupButton);
    }

    private void setSelection(Selection selection) {
        this.selection = selection;
        this.saveSelectionOnClient();
        this.setButtons();
    }

    private void setFormation(Formation f) {
        formation = f;
        this.saveFormationSelection();
        this.setButtons();
    }

    private Selection getSelectionFromClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        byte x = nbt.m_128445_("RecruitsSelection");
        return Selection.fromIndex(x);
    }

    private void saveSelectionOnClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128405_("RecruitsSelection", (int)this.selection.index);
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    private void createCommandButtons(Selection selection, int x, int y) {
        RecruitsCategoryButton movementButton = new RecruitsCategoryButton(Items.f_42463_.m_7968_(), x, y + 87, (Component)Component.m_237113_((String)""), button -> this.setSelection(Selection.MOVEMENT));
        movementButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOVEMENT));
        this.m_142416_((GuiEventListener)movementButton);
        RecruitsCategoryButton combatButton = new RecruitsCategoryButton(Items.f_42383_.m_7968_(), x - 30, y + 87, (Component)Component.m_237113_((String)""), button -> this.setSelection(Selection.COMBAT));
        combatButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_COMBAT));
        this.m_142416_((GuiEventListener)combatButton);
        RecruitsCategoryButton otherButton = new RecruitsCategoryButton(Items.f_42009_.m_7968_(), x + 30, y + 87, (Component)Component.m_237113_((String)""), button -> this.setSelection(Selection.OTHER));
        otherButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_OTHER));
        this.m_142416_((GuiEventListener)otherButton);
        movementButton.f_93623_ = selection == Selection.MOVEMENT;
        combatButton.f_93623_ = selection == Selection.COMBAT;
        otherButton.f_93623_ = selection == Selection.OTHER;
        switch (selection) {
            case MOVEMENT: {
                RecruitsCommandButton moveButton = new RecruitsCommandButton(x, y - 50, (Component)TEXT_MOVE, button -> {
                    this.sendMovementCommandToServer(6);
                    this.sendCommandInChat(6);
                });
                moveButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOVE));
                this.m_142416_((GuiEventListener)moveButton);
                RecruitsCommandButton forwardButton = new RecruitsCommandButton(x - 60, y - 25, (Component)TEXT_FORWARD, button -> {
                    this.sendMovementCommandToServer(7);
                    this.sendCommandInChat(7);
                });
                forwardButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FORWARD));
                this.m_142416_((GuiEventListener)forwardButton);
                RecruitsCommandButton followButton = new RecruitsCommandButton(x + 60, y - 25, (Component)TEXT_FOLLOW, button -> {
                    if (formation.getIndex() != 0) {
                        ArrayList<RecruitsGroup> activeGroups = new ArrayList<RecruitsGroup>();
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            activeGroups.add(group);
                        }
                        int[] array = new int[activeGroups.size()];
                        for (int i = 0; i < activeGroups.size(); ++i) {
                            RecruitsGroup group = (RecruitsGroup)activeGroups.get(i);
                            if (group.isDisabled()) continue;
                            array[i] = group.getId();
                        }
                        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveFormationFollowMovement(this.player.m_20148_(), array, formation.getIndex()));
                    } else {
                        this.sendMovementCommandToServer(1);
                    }
                    this.sendCommandInChat(1);
                });
                followButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FOLLOW));
                this.m_142416_((GuiEventListener)followButton);
                RecruitsCommandButton wanderButton = new RecruitsCommandButton(x + 120, y, (Component)TEXT_WANDER, button -> {
                    this.sendMovementCommandToServer(0);
                    this.sendCommandInChat(0);
                });
                wanderButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_WANDER));
                this.m_142416_((GuiEventListener)wanderButton);
                RecruitsCommandButton backToPosButton = new RecruitsCommandButton(x - 120, y, (Component)TEXT_BACK_TO_POS, button -> {
                    this.sendMovementCommandToServer(3);
                    this.sendCommandInChat(3);
                });
                backToPosButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_POS));
                this.m_142416_((GuiEventListener)backToPosButton);
                RecruitsCommandButton holdPosButton = new RecruitsCommandButton(x + 60, y + 25, (Component)TEXT_HOLD_POS, button -> {
                    this.sendMovementCommandToServer(2);
                    this.sendCommandInChat(2);
                });
                holdPosButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_POS));
                this.m_142416_((GuiEventListener)holdPosButton);
                RecruitsCommandButton backwardButton = new RecruitsCommandButton(x - 60, y + 25, (Component)TEXT_BACKWARD, button -> {
                    this.sendMovementCommandToServer(8);
                    this.sendCommandInChat(8);
                });
                backwardButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACKWARD));
                this.m_142416_((GuiEventListener)backwardButton);
                RecruitsFormationButton noneFormationButton = new RecruitsFormationButton(Formation.NONE, x, y + 50, button -> this.setFormation(Formation.NONE));
                noneFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_NONE));
                this.m_142416_((GuiEventListener)noneFormationButton);
                RecruitsFormationButton lineUpFormationButton = new RecruitsFormationButton(Formation.LINE, x - 21, y + 50, button -> this.setFormation(Formation.LINE));
                lineUpFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_LINEUP));
                this.m_142416_((GuiEventListener)lineUpFormationButton);
                RecruitsFormationButton squareFormationButton = new RecruitsFormationButton(Formation.SQUARE, x + 21, y + 50, button -> this.setFormation(Formation.SQUARE));
                squareFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_SQUARE));
                this.m_142416_((GuiEventListener)squareFormationButton);
                RecruitsFormationButton triangleFormationButton = new RecruitsFormationButton(Formation.TRIANGLE, x - 42, y + 50, button -> this.setFormation(Formation.TRIANGLE));
                triangleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_TRIANGLE));
                this.m_142416_((GuiEventListener)triangleFormationButton);
                RecruitsFormationButton VFormFormationButton = new RecruitsFormationButton(Formation.VFORM, x + 42, y + 50, button -> this.setFormation(Formation.VFORM));
                VFormFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_V));
                this.m_142416_((GuiEventListener)VFormFormationButton);
                RecruitsFormationButton hcircleFormationButton = new RecruitsFormationButton(Formation.HCIRCLE, x - 63, y + 50, button -> this.setFormation(Formation.HCIRCLE));
                hcircleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_HOLLOW_CIRCLE));
                this.m_142416_((GuiEventListener)hcircleFormationButton);
                RecruitsFormationButton hSquareFormationButton = new RecruitsFormationButton(Formation.HSQUARE, x + 63, y + 50, button -> this.setFormation(Formation.HSQUARE));
                hSquareFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_HOLLOW_SQUARE));
                this.m_142416_((GuiEventListener)hSquareFormationButton);
                RecruitsFormationButton circleFormationButton = new RecruitsFormationButton(Formation.CIRCLE, x - 84, y + 50, button -> this.setFormation(Formation.CIRCLE));
                circleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_CIRCLE));
                this.m_142416_((GuiEventListener)circleFormationButton);
                RecruitsFormationButton movementFormationButton = new RecruitsFormationButton(Formation.MOVEMENT, x + 84, y + 50, button -> this.setFormation(Formation.MOVEMENT));
                movementFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_MOVEMENT));
                this.m_142416_((GuiEventListener)movementFormationButton);
                noneFormationButton.f_93623_ = formation == Formation.NONE;
                lineUpFormationButton.f_93623_ = formation == Formation.LINE;
                squareFormationButton.f_93623_ = formation == Formation.SQUARE;
                hSquareFormationButton.f_93623_ = formation == Formation.HSQUARE;
                triangleFormationButton.f_93623_ = formation == Formation.TRIANGLE;
                VFormFormationButton.f_93623_ = formation == Formation.VFORM;
                hcircleFormationButton.f_93623_ = formation == Formation.HCIRCLE;
                circleFormationButton.f_93623_ = formation == Formation.CIRCLE;
                movementFormationButton.f_93623_ = formation == Formation.MOVEMENT;
                break;
            }
            case COMBAT: {
                RecruitsCommandButton strategicFireButton = new RecruitsCommandButton(x, y - 50, (Component)TEXT_STRATEGIC_FIRE, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStrategicFire(this.player.m_20148_(), group.getId(), true));
                        }
                        this.sendCommandInChat(72);
                    }
                });
                strategicFireButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_STRATEGIC_FIRE));
                this.m_142416_((GuiEventListener)strategicFireButton);
                RecruitsCommandButton holdStrategicFireButton = new RecruitsCommandButton(x, y - 25, (Component)TEXT_HOLD_STRATEGIC_FIRE, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStrategicFire(this.player.m_20148_(), group.getId(), false));
                        }
                        this.sendCommandInChat(73);
                    }
                });
                holdStrategicFireButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_STRATEGIC_FIRE));
                this.m_142416_((GuiEventListener)holdStrategicFireButton);
                RecruitsCommandButton fireAtWillButton = new RecruitsCommandButton(x + 100, y - 38, (Component)TEXT_FIRE_AT_WILL, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRangedFire(this.player.m_20148_(), group.getId(), true));
                        }
                        this.sendCommandInChat(70);
                    }
                });
                fireAtWillButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FIRE_AT_WILL));
                this.m_142416_((GuiEventListener)fireAtWillButton);
                RecruitsCommandButton holdFireButton = new RecruitsCommandButton(x + 100, y - 13, (Component)TEXT_HOLD_FIRE, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStrategicFire(this.player.m_20148_(), group.getId(), false));
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRangedFire(this.player.m_20148_(), group.getId(), false));
                        }
                        this.sendCommandInChat(71);
                    }
                });
                holdFireButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_FIRE));
                this.m_142416_((GuiEventListener)holdFireButton);
                RecruitsCommandButton shieldsUpButton = new RecruitsCommandButton(x + 100, y + 13, (Component)TEXT_SHIELDS_UP, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShields(this.player.m_20148_(), group.getId(), true));
                        }
                        this.sendCommandInChat(74);
                    }
                });
                shieldsUpButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_SHIELDS_UP));
                this.m_142416_((GuiEventListener)shieldsUpButton);
                RecruitsCommandButton shieldsDownButton = new RecruitsCommandButton(x + 100, y + 38, (Component)TEXT_SHIELDS_DOWN, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShields(this.player.m_20148_(), group.getId(), false));
                        }
                        this.sendCommandInChat(75);
                    }
                });
                shieldsDownButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_SHIELDS_DOWN));
                this.m_142416_((GuiEventListener)shieldsDownButton);
                RecruitsCommandButton clearTargetsButton = new RecruitsCommandButton(x, y + 50, (Component)TEXT_CLEAR_TARGET, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageClearTarget(this.player.m_20148_(), group.getId()));
                        }
                        this.sendCommandInChat(9);
                    }
                });
                clearTargetsButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_CLEAR_TARGET));
                this.m_142416_((GuiEventListener)clearTargetsButton);
                RecruitsCommandButton passiveButton = new RecruitsCommandButton(x - 100, y - 38, (Component)TEXT_PASSIVE, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggro(this.player.m_20148_(), 3, group.getId()));
                        }
                        this.sendCommandInChat(13);
                    }
                });
                passiveButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_PASSIVE));
                this.m_142416_((GuiEventListener)passiveButton);
                RecruitsCommandButton neutralButton = new RecruitsCommandButton(x - 100, y - 13, (Component)TEXT_NEUTRAL, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggro(this.player.m_20148_(), 0, group.getId()));
                        }
                        this.sendCommandInChat(10);
                    }
                });
                neutralButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_NEUTRAL));
                this.m_142416_((GuiEventListener)neutralButton);
                RecruitsCommandButton raidButton = new RecruitsCommandButton(x - 100, y + 38, (Component)TEXT_RAID, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggro(this.player.m_20148_(), 2, group.getId()));
                        }
                        this.sendCommandInChat(12);
                    }
                });
                raidButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_RAID));
                this.m_142416_((GuiEventListener)raidButton);
                RecruitsCommandButton aggressiveButton = new RecruitsCommandButton(x - 100, y + 13, (Component)TEXT_AGGRESSIVE, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggro(this.player.m_20148_(), 1, group.getId()));
                        }
                        this.sendCommandInChat(11);
                    }
                });
                aggressiveButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_AGGRESSIVE));
                this.m_142416_((GuiEventListener)aggressiveButton);
                break;
            }
            case OTHER: {
                RecruitsCommandButton protectButton = new RecruitsCommandButton(x, y - 25, (Component)TEXT_PROTECT, button -> {
                    if (this.rayEntity != null && !groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageProtectEntity(this.player.m_20148_(), this.rayEntity.m_20148_(), group.getId()));
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMovement(this.player.m_20148_(), 5, formation.getIndex(), group.getId()));
                        }
                        this.sendCommandInChat(5);
                    }
                });
                protectButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_PROTECT));
                this.m_142416_((GuiEventListener)protectButton);
                RecruitsCommandButton mountButton = new RecruitsCommandButton(x, y + 25, (Component)TEXT_MOUNT, button -> {
                    if (this.rayEntity != null && !groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMountEntity(this.player.m_20148_(), this.rayEntity.m_20148_(), group.getId()));
                        }
                        this.sendCommandInChat(99);
                    }
                });
                mountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOUNT));
                this.m_142416_((GuiEventListener)mountButton);
                RecruitsCommandButton teamButton = new RecruitsCommandButton(x - 60, y + 50, (Component)TEXT_TEAM, button -> this.f_96541_.m_91152_((Screen)new TeamMainScreen(this.player)));
                teamButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_TEAM));
                this.m_142416_((GuiEventListener)teamButton);
                RecruitsCommandButton backToMountButton = new RecruitsCommandButton(x + 100, y + 25, (Component)TEXT_BACK_TO_MOUNT, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageBackToMountEntity(this.player.m_20148_(), group.getId()));
                        }
                        this.sendCommandInChat(91);
                    }
                });
                backToMountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_MOUNT));
                this.m_142416_((GuiEventListener)backToMountButton);
                RecruitsCommandButton dismountButton = new RecruitsCommandButton(x - 100, y + 25, (Component)TEXT_DISMOUNT, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDismount(this.player.m_20148_(), group.getId()));
                        }
                        this.sendCommandInChat(98);
                    }
                });
                dismountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_DISMOUNT));
                this.m_142416_((GuiEventListener)dismountButton);
                RecruitsCommandButton upkeepButton = new RecruitsCommandButton(x + 100, y, (Component)TEXT_UPKEEP, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (!group.isDisabled() && this.rayEntity != null) {
                                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpkeepEntity(this.player.m_20148_(), this.rayEntity.m_20148_(), group.getId()));
                                continue;
                            }
                            if (group.isDisabled() || this.rayBlockPos == null) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpkeepPos(this.player.m_20148_(), group.getId(), this.rayBlockPos));
                        }
                        this.sendCommandInChat(92);
                    }
                });
                upkeepButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_UPKEEP));
                this.m_142416_((GuiEventListener)upkeepButton);
                RecruitsCommandButton clearUpkeepButton = new RecruitsCommandButton(x + 60, y + 50, (Component)TEXT_CLEAR_UPKEEP, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageClearUpkeep(this.player.m_20148_(), group.getId()));
                        }
                        this.sendCommandInChat(93);
                    }
                });
                upkeepButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_CLEAR_UPKEEP));
                this.m_142416_((GuiEventListener)clearUpkeepButton);
                RecruitsCommandButton restButton = new RecruitsCommandButton(x - 100, y, (Component)TEXT_REST, button -> {
                    if (!groups.isEmpty()) {
                        for (RecruitsGroup group : groups) {
                            if (group.isDisabled()) continue;
                            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRest(this.player.m_20148_(), group.getId(), true));
                        }
                        this.sendCommandInChat(88);
                    }
                });
                restButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_REST));
                this.m_142416_((GuiEventListener)restButton);
            }
        }
    }

    private void sendMovementCommandToServer(int state) {
        if (state != 1) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveFormationFollowMovement(this.player.m_20148_(), new int[0], -1));
        }
        if (!groups.isEmpty()) {
            for (RecruitsGroup group : groups) {
                if (group.isDisabled()) continue;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMovement(this.player.m_20148_(), state, group.getId(), formation.getIndex()));
            }
        }
    }

    public Formation getSavedFormationFromClient() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        return Formation.fromIndex((byte)nbt.m_128451_("FormationSelection"));
    }

    public void saveFormationSelection() {
        CompoundTag playerNBT = this.player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128344_("FormationSelection", formation.getIndex());
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    public void sendCommandInChat(int state) {
        StringBuilder group_string = new StringBuilder();
        int i = 0;
        for (RecruitsGroup group : groups) {
            if (group.isDisabled()) continue;
            ++i;
        }
        if (i >= 9) {
            group_string = new StringBuilder(TEXT_EVERYONE.getString() + ", ");
        } else {
            for (RecruitsGroup group : groups) {
                if (group.isDisabled()) continue;
                group_string.append(group.getName()).append(", ");
            }
        }
        switch (state) {
            case 0: {
                this.player.m_213846_((Component)CommandScreen.TEXT_WANDER(group_string.toString()));
                break;
            }
            case 1: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FOLLOW(group_string.toString()));
                break;
            }
            case 2: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_POS(group_string.toString()));
                break;
            }
            case 3: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACK_TO_POS(group_string.toString()));
                break;
            }
            case 4: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_MY_POS(group_string.toString()));
                break;
            }
            case 5: {
                this.player.m_213846_((Component)CommandScreen.TEXT_PROTECT(group_string.toString()));
                break;
            }
            case 6: {
                this.player.m_213846_((Component)CommandScreen.TEXT_MOVE(group_string.toString()));
                break;
            }
            case 7: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FORWARD(group_string.toString()));
                break;
            }
            case 8: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACKWARD(group_string.toString()));
                break;
            }
            case 9: {
                this.player.m_213846_((Component)CommandScreen.TEXT_CLEAR_TARGETS(group_string.toString()));
                break;
            }
            case 10: {
                this.player.m_213846_((Component)CommandScreen.TEXT_NEUTRAL(group_string.toString()));
                break;
            }
            case 11: {
                this.player.m_213846_((Component)CommandScreen.TEXT_AGGRESSIVE(group_string.toString()));
                break;
            }
            case 12: {
                this.player.m_213846_((Component)CommandScreen.TEXT_RAID(group_string.toString()));
                break;
            }
            case 13: {
                this.player.m_213846_((Component)CommandScreen.TEXT_PASSIVE(group_string.toString()));
                break;
            }
            case 70: {
                this.player.m_213846_((Component)CommandScreen.TEXT_FIRE_AT_WILL(group_string.toString()));
                break;
            }
            case 71: {
                this.player.m_213846_((Component)CommandScreen.TEXT_HOLD_FIRE(group_string.toString()));
                break;
            }
            case 72: {
                this.player.m_213846_((Component)CommandScreen.TEXT_STRATEGIC_FIRE(group_string.toString()));
                break;
            }
            case 73: {
                this.player.m_213846_((Component)CommandScreen.TEXT_STRATEGIC_FIRE_OFF(group_string.toString()));
                break;
            }
            case 74: {
                this.player.m_213846_((Component)CommandScreen.TEXT_SHIELDS(group_string.toString()));
                break;
            }
            case 75: {
                this.player.m_213846_((Component)CommandScreen.TEXT_SHIELDS_OFF(group_string.toString()));
                break;
            }
            case 88: {
                this.player.m_213846_((Component)CommandScreen.TEXT_REST(group_string.toString()));
                break;
            }
            case 91: {
                this.player.m_213846_((Component)CommandScreen.TEXT_BACK_TO_MOUNT(group_string.toString()));
                break;
            }
            case 92: {
                this.player.m_213846_((Component)CommandScreen.TEXT_UPKEEP(group_string.toString()));
                break;
            }
            case 93: {
                this.player.m_213846_((Component)CommandScreen.TEXT_CLEAR_UPKEEP(group_string.toString()));
                break;
            }
            case 98: {
                this.player.m_213846_((Component)CommandScreen.TEXT_DISMOUNT(group_string.toString()));
                break;
            }
            case 99: {
                this.player.m_213846_((Component)CommandScreen.TEXT_MOUNT(group_string.toString()));
            }
        }
    }

    private static MutableComponent TEXT_WANDER(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.wander", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FOLLOW(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.follow", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.holdPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACK_TO_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backToPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACK_TO_MOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backToMount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_REST(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.rest", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_MY_POS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.holdMyPos", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_PROTECT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.protect", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_UPKEEP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.upkeep", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_CLEAR_UPKEEP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.clear_upkeep", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_OFF(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_STRATEGIC_FIRE_OFF(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.strategic_fire_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_STRATEGIC_FIRE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.strategic_fire", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_MOVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.move", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FORWARD(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.forward", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_BACKWARD(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.backward", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_CLEAR_TARGETS(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.clearTargets", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_DISMOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.dismount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_MOUNT(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.mount", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_PASSIVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.passive", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_RAID(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.raid", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_AGGRESSIVE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.aggressive", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_NEUTRAL(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.neutral", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_UP(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_SHIELDS_DOWN(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.shields_off", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_FIRE_AT_WILL(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.fire_at_will", (Object[])new Object[]{group_string});
    }

    private static MutableComponent TEXT_HOLD_FIRE(String group_string) {
        return Component.m_237110_((String)"chat.recruits.command.hold_fire", (Object[])new Object[]{group_string});
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
    }

    @Nullable
    private BlockPos getBlockPos() {
        HitResult rayTraceResult = this.player.m_19907_(100.0, 1.0f, true);
        if (rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)rayTraceResult;
            return blockraytraceresult.m_82425_();
        }
        return null;
    }

    public boolean m_6375_(double x, double y, int id) {
        if (id == 1) {
            this.invertGroups();
        }
        return super.m_6375_(x, y, id);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        if (p_94688_ > 0.0) {
            this.setSelection(this.selection.getBefore());
        } else {
            this.setSelection(this.selection.getNext());
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    private void invertGroups() {
        for (RecruitsGroupButton button : this.groupButtons) {
            button.getGroup().setDisabled(this.mouseGroupsInverted);
        }
        this.setButtons();
        this.mouseGroupsInverted = !this.mouseGroupsInverted;
    }

    private boolean getInvertedStatus() {
        boolean allActive = true;
        boolean allInactive = true;
        for (RecruitsGroupButton button : this.groupButtons) {
            if (button.f_93623_) {
                allInactive = false;
            } else {
                allActive = false;
            }
            if (allActive || allInactive) continue;
            return false;
        }
        return allActive;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static enum Selection {
        COMBAT(-1),
        MOVEMENT(0),
        OTHER(1);

        private final byte index;

        private Selection(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public Selection getNext() {
            byte newIndex = (byte)(this.index + 1);
            int length = Selection.values().length;
            if (newIndex >= length - 1) {
                return this;
            }
            return Selection.fromIndex(newIndex);
        }

        public Selection getBefore() {
            byte newIndex = (byte)(this.index - 1);
            if (newIndex < -1) {
                return this;
            }
            return Selection.fromIndex(newIndex);
        }

        public static Selection fromIndex(byte index) {
            for (Selection state : Selection.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid Selection index: " + index);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Formation {
        NONE(0),
        LINE(1),
        SQUARE(2),
        TRIANGLE(3),
        HCIRCLE(4),
        HSQUARE(5),
        VFORM(6),
        CIRCLE(7),
        MOVEMENT(8);

        private final byte index;

        private Formation(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public static Formation fromIndex(byte index) {
            for (Formation state : Formation.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid Selection index: " + index);
        }
    }
}

