/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.events;

import com.talhanation.recruits.client.gui.component.ImageToast;
import com.talhanation.recruits.client.gui.component.RecruitsTeamImageToast;
import com.talhanation.recruits.world.RecruitsTeam;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RecruitsToastManager {
    private static final ResourceLocation LETTER_IMAGE = new ResourceLocation("recruits", "textures/gui/image/letter.png");
    private static final ResourceLocation ALLY_IMAGE = new ResourceLocation("recruits", "textures/gui/image/ally.png");
    private static final ResourceLocation ENEMY_IMAGE = new ResourceLocation("recruits", "textures/gui/image/enemy.png");
    private static final ResourceLocation NEUTRAL_IMAGE = new ResourceLocation("recruits", "textures/gui/image/neutral.png");
    private static final ResourceLocation CROWN_IMAGE = new ResourceLocation("recruits", "textures/gui/image/leader_crown.png");
    public static Images savedTeamForPlayer;
    public static Images savedForPlayer;
    public static final Component TOAST_PLAYER_JOINED_TITLE;
    public static final Component TOAST_TEAM_JOINED_TITLE;
    public static final Component TOAST_JOIN_REQUEST_TITLE;
    public static final Component TOAST_SENT_JOIN_REQUEST_TITLE;
    public static final Component TOAST_ENEMY_TITLE;
    public static final Component TOAST_NEUTRAL_TITLE;
    public static final Component TOAST_ALLY_TITLE;
    public static final Component TOAST_MESSENGER_ARRIVED_TITLE;
    public static final Component TOAST_RECRUIT_ASSIGNED_TITLE;

    public static void setTeamToastForPlayer(Images id, @Nullable Component title, @Nullable Component text, RecruitsTeam team) {
        if (savedTeamForPlayer == id) {
            savedTeamForPlayer = null;
            return;
        }
        savedTeamForPlayer = id;
        RecruitsTeamImageToast toast = switch (id) {
            case Images.ALLY -> new RecruitsTeamImageToast(ALLY_IMAGE, title, text, team);
            case Images.NEUTRAL -> new RecruitsTeamImageToast(NEUTRAL_IMAGE, title, text, team);
            case Images.ENEMY -> new RecruitsTeamImageToast(ENEMY_IMAGE, title, text, team);
            case Images.TEAM_JOIN -> new RecruitsTeamImageToast(null, title, text, team);
            default -> new RecruitsTeamImageToast(LETTER_IMAGE, title, text, team);
        };
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91300_().m_94922_((Toast)toast);
    }

    public static void setToastForPlayer(Images id, @Nullable Component title, @Nullable Component text) {
        if (savedForPlayer == id) {
            savedForPlayer = null;
            return;
        }
        savedForPlayer = id;
        ImageToast toast = switch (id) {
            case Images.ALLY -> new ImageToast(ALLY_IMAGE, title, text);
            case Images.NEUTRAL -> new ImageToast(NEUTRAL_IMAGE, title, text);
            case Images.ENEMY -> new ImageToast(ENEMY_IMAGE, title, text);
            case Images.CROWN -> new ImageToast(CROWN_IMAGE, title, text);
            default -> new ImageToast(LETTER_IMAGE, title, text);
        };
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91300_().m_94922_((Toast)toast);
    }

    public static Component TOAST_TO(String team) {
        return Component.m_237110_((String)"gui.recruits.toast.to", (Object[])new Object[]{team});
    }

    public static Component TOAST_FOR(String team) {
        return Component.m_237110_((String)"gui.recruits.toast.for", (Object[])new Object[]{team});
    }

    public static Component TOAST_FROM(String team) {
        return Component.m_237110_((String)"gui.recruits.toast.from", (Object[])new Object[]{team});
    }

    public static Component TOAST_PLAYER_JOINED_TEAM(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.playerJoinedTeam", (Object[])new Object[]{s});
    }

    public static Component TOAST_TEAM_JOINED(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.teamJoined", (Object[])new Object[]{s});
    }

    public static Component TOAST_WANTS_TO_JOIN(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.wantsToJoin", (Object[])new Object[]{s});
    }

    public static Component TOAST_ENEMY_INFO(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setYouAsEnemy", (Object[])new Object[]{s}).m_130940_(ChatFormatting.RED);
    }

    public static Component TOAST_NEUTRAL_INFO(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setYouAsNeutral", (Object[])new Object[]{s});
    }

    public static Component TOAST_ALLY_INFO(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setYouAsAlly", (Object[])new Object[]{s}).m_130940_(ChatFormatting.GREEN);
    }

    public static Component TOAST_ENEMY_SET(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setAsEnemy", (Object[])new Object[]{s});
    }

    public static Component TOAST_NEUTRAL_SET(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setAsNeutral", (Object[])new Object[]{s});
    }

    public static Component TOAST_ALLY_SET(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.setAsAlly", (Object[])new Object[]{s});
    }

    public static Component TOAST_RECRUIT_ASSIGNED_INFO(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.recruitAssigned", (Object[])new Object[]{s});
    }

    public static Component TOAST_MESSENGER_ARRIVED_INFO(String s) {
        return Component.m_237110_((String)"gui.recruits.toast.messengerArrived", (Object[])new Object[]{s});
    }

    static {
        TOAST_PLAYER_JOINED_TITLE = Component.m_237115_((String)"gui.recruits.toast.playerJoinedTeamTitle");
        TOAST_TEAM_JOINED_TITLE = Component.m_237115_((String)"gui.recruits.toast.teamJoinedTitle");
        TOAST_JOIN_REQUEST_TITLE = Component.m_237115_((String)"gui.recruits.toast.JoinRequestTitle");
        TOAST_SENT_JOIN_REQUEST_TITLE = Component.m_237115_((String)"gui.recruits.toast.sendJoinRequestTitle");
        TOAST_ENEMY_TITLE = Component.m_237115_((String)"gui.recruits.toast.enemyTitle").m_130940_(ChatFormatting.RED);
        TOAST_NEUTRAL_TITLE = Component.m_237115_((String)"gui.recruits.toast.neutralTitle");
        TOAST_ALLY_TITLE = Component.m_237115_((String)"gui.recruits.toast.allyTitle").m_130940_(ChatFormatting.GREEN);
        TOAST_MESSENGER_ARRIVED_TITLE = Component.m_237115_((String)"gui.recruits.toast.messengerArrivedTitle");
        TOAST_RECRUIT_ASSIGNED_TITLE = Component.m_237115_((String)"gui.recruits.toast.recruitAssignedTitle");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Images {
        NONE,
        LETTER,
        ALLY,
        NEUTRAL,
        ENEMY,
        CROWN,
        TEAM_JOIN;

    }
}

